/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.zzj;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzp;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    public static final Parcelable.Creator<MediaTrack> CREATOR = new zzj();
    private final int mVersionCode;
    private long fr;
    private int lN;
    private String kY;
    private String la;
    private String mName;
    private String R;
    private int lO;
    String lf;
    private JSONObject lh;

    MediaTrack(int n, long l, int n2, String string2, String string3, String string4, String string5, int n3, String string6) {
        this.mVersionCode = n;
        this.fr = l;
        this.lN = n2;
        this.kY = string2;
        this.la = string3;
        this.mName = string4;
        this.R = string5;
        this.lO = n3;
        this.lf = string6;
        if (this.lf != null) {
            try {
                this.lh = new JSONObject(this.lf);
            }
            catch (JSONException jSONException) {
                this.lh = null;
                this.lf = null;
            }
        } else {
            this.lh = null;
        }
    }

    MediaTrack(JSONObject jSONObject) throws JSONException {
        this(1, 0L, 0, null, null, null, null, -1, null);
        this.zzm(jSONObject);
    }

    MediaTrack(long l, int n) throws IllegalArgumentException {
        this(1, 0L, 0, null, null, null, null, -1, null);
        this.fr = l;
        if (n <= 0 || n > 3) {
            throw new IllegalArgumentException(new StringBuilder(24).append("invalid type ").append(n).toString());
        }
        this.lN = n;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long getId() {
        return this.fr;
    }

    public int getType() {
        return this.lN;
    }

    public String getContentId() {
        return this.kY;
    }

    public void setContentId(String string2) {
        this.kY = string2;
    }

    public String getContentType() {
        return this.la;
    }

    public void setContentType(String string2) {
        this.la = string2;
    }

    public String getName() {
        return this.mName;
    }

    void setName(String string2) {
        this.mName = string2;
    }

    public String getLanguage() {
        return this.R;
    }

    void setLanguage(String string2) {
        this.R = string2;
    }

    public int getSubtype() {
        return this.lO;
    }

    void zzek(int n) throws IllegalArgumentException {
        if (n <= -1 || n > 5) {
            throw new IllegalArgumentException(new StringBuilder(27).append("invalid subtype ").append(n).toString());
        }
        if (n != 0 && this.lN != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.lO = n;
    }

    public JSONObject getCustomData() {
        return this.lh;
    }

    void setCustomData(JSONObject jSONObject) {
        this.lh = jSONObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void zzm(JSONObject jSONObject) throws JSONException {
        block12: {
            block13: {
                String string2;
                block16: {
                    block15: {
                        block14: {
                            this.fr = jSONObject.getLong("trackId");
                            string2 = jSONObject.getString("type");
                            if ("TEXT".equals(string2)) {
                                this.lN = 1;
                            } else if ("AUDIO".equals(string2)) {
                                this.lN = 2;
                            } else if ("VIDEO".equals(string2)) {
                                this.lN = 3;
                            } else {
                                String string3;
                                String string4 = String.valueOf(string2);
                                if (string4.length() != 0) {
                                    string3 = "invalid type: ".concat(string4);
                                    throw new JSONException(string3);
                                }
                                string3 = new String("invalid type: ");
                                throw new JSONException(string3);
                            }
                            this.kY = jSONObject.optString("trackContentId", null);
                            this.la = jSONObject.optString("trackContentType", null);
                            this.mName = jSONObject.optString("name", null);
                            this.R = jSONObject.optString("language", null);
                            if (!jSONObject.has("subtype")) break block13;
                            string2 = jSONObject.getString("subtype");
                            if (!"SUBTITLES".equals(string2)) break block14;
                            this.lO = 1;
                            break block12;
                        }
                        if (!"CAPTIONS".equals(string2)) break block15;
                        this.lO = 2;
                        break block12;
                    }
                    if (!"DESCRIPTIONS".equals(string2)) break block16;
                    this.lO = 3;
                    break block12;
                }
                if ("CHAPTERS".equals(string2)) {
                    this.lO = 4;
                    break block12;
                } else if ("METADATA".equals(string2)) {
                    this.lO = 5;
                    break block12;
                } else {
                    String string5;
                    String string6 = String.valueOf(string2);
                    if (string6.length() != 0) {
                        string5 = "invalid subtype: ".concat(string6);
                        throw new JSONException(string5);
                    }
                    string5 = new String("invalid subtype: ");
                    throw new JSONException(string5);
                }
            }
            this.lO = 0;
        }
        this.lh = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.fr);
            switch (this.lN) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                    break;
                }
            }
            if (this.kY != null) {
                jSONObject.put("trackContentId", (Object)this.kY);
            }
            if (this.la != null) {
                jSONObject.put("trackContentType", (Object)this.la);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.R)) {
                jSONObject.put("language", (Object)this.R);
            }
            switch (this.lO) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                    break;
                }
            }
            if (this.lh != null) {
                jSONObject.put("customData", (Object)this.lh);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)((Object)object);
        if (this.lh == null != (mediaTrack.lh == null)) {
            return false;
        }
        if (this.lh != null && mediaTrack.lh != null && !zzp.zzf((Object)this.lh, (Object)mediaTrack.lh)) {
            return false;
        }
        return this.fr == mediaTrack.fr && this.lN == mediaTrack.lN && zzf.zza(this.kY, mediaTrack.kY) && zzf.zza(this.la, mediaTrack.la) && zzf.zza(this.mName, mediaTrack.mName) && zzf.zza(this.R, mediaTrack.R) && this.lO == mediaTrack.lO;
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.fr, this.lN, this.kY, this.la, this.mName, this.R, this.lO, this.lh});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.lf = this.lh == null ? null : this.lh.toString();
        zzj.zza(this, parcel, n);
    }

    public static class Builder {
        private final MediaTrack lP;

        public Builder(long l, int n) throws IllegalArgumentException {
            this.lP = new MediaTrack(l, n);
        }

        public Builder setContentId(String string2) {
            this.lP.setContentId(string2);
            return this;
        }

        public Builder setContentType(String string2) {
            this.lP.setContentType(string2);
            return this;
        }

        public Builder setName(String string2) {
            this.lP.setName(string2);
            return this;
        }

        public Builder setLanguage(String string2) {
            this.lP.setLanguage(string2);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.lP.setLanguage(zzf.zzb(locale));
            return this;
        }

        public Builder setSubtype(int n) throws IllegalArgumentException {
            this.lP.zzek(n);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.lP.setCustomData(jSONObject);
            return this;
        }

        public MediaTrack build() {
            return this.lP;
        }
    }
}

