/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.zzi;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaStatus
extends AbstractSafeParcelable {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    public static final int REPEAT_MODE_REPEAT_OFF = 0;
    public static final int REPEAT_MODE_REPEAT_ALL = 1;
    public static final int REPEAT_MODE_REPEAT_SINGLE = 2;
    public static final int REPEAT_MODE_REPEAT_ALL_AND_SHUFFLE = 3;
    public static final Parcelable.Creator<MediaStatus> CREATOR = new zzi();
    private final int mVersionCode;
    private MediaInfo li;
    private long ly;
    private int lz;
    private double lA;
    private int lB;
    private int lC;
    private long lD;
    long lE;
    private double lF;
    private boolean lG;
    private long[] lw;
    private int lH;
    private int lI;
    String lf;
    private JSONObject lh;
    int lJ;
    final ArrayList<MediaQueueItem> lK = new ArrayList();
    private boolean lL;
    private final SparseArray<Integer> lM = new SparseArray();

    MediaStatus(int n, MediaInfo mediaInfo, long l, int n2, double d, int n3, int n4, long l2, long l3, double d2, boolean bl, long[] lArray, int n5, int n6, String string2, int n7, List<MediaQueueItem> list, boolean bl2) {
        this.mVersionCode = n;
        this.li = mediaInfo;
        this.ly = l;
        this.lz = n2;
        this.lA = d;
        this.lB = n3;
        this.lC = n4;
        this.lD = l2;
        this.lE = l3;
        this.lF = d2;
        this.lG = bl;
        this.lw = lArray;
        this.lH = n5;
        this.lI = n6;
        this.lf = string2;
        if (this.lf != null) {
            try {
                this.lh = new JSONObject(this.lf);
            }
            catch (JSONException jSONException) {
                this.lh = null;
                this.lf = null;
            }
        } else {
            this.lh = null;
        }
        this.lJ = n7;
        if (list != null && !list.isEmpty()) {
            this.zza(list.toArray(new MediaQueueItem[list.size()]));
        }
        this.lL = bl2;
    }

    public MediaStatus(JSONObject jSONObject) throws JSONException {
        this(1, null, 0L, 0, 0.0, 0, 0, 0L, 0L, 0.0, false, null, 0, 0, null, 0, null, false);
        this.zza(jSONObject, 0);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzajz() {
        return this.ly;
    }

    public int getPlayerState() {
        return this.lB;
    }

    public int getIdleReason() {
        return this.lC;
    }

    public double getPlaybackRate() {
        return this.lA;
    }

    public MediaInfo getMediaInfo() {
        return this.li;
    }

    public long getStreamPosition() {
        return this.lD;
    }

    public boolean isMediaCommandSupported(long l) {
        return (this.lE & l) != 0L;
    }

    public double getStreamVolume() {
        return this.lF;
    }

    public boolean isMute() {
        return this.lG;
    }

    public long[] getActiveTrackIds() {
        return this.lw;
    }

    public JSONObject getCustomData() {
        return this.lh;
    }

    public int getCurrentItemId() {
        return this.lz;
    }

    public int getLoadingItemId() {
        return this.lH;
    }

    public int getPreloadedItemId() {
        return this.lI;
    }

    public int getQueueRepeatMode() {
        return this.lJ;
    }

    public List<MediaQueueItem> getQueueItems() {
        return this.lK;
    }

    public int getQueueItemCount() {
        return this.lK.size();
    }

    public MediaQueueItem getQueueItemById(int n) {
        return this.getItemById(n);
    }

    public MediaQueueItem getQueueItem(int n) {
        return this.getItemByIndex(n);
    }

    public boolean isPlayingAd() {
        return this.lL;
    }

    public void zzbk(boolean bl) {
        this.lL = bl;
    }

    public int zza(JSONObject jSONObject, int n) throws JSONException {
        int n2;
        int n3;
        int n4;
        int n5;
        long l;
        long l2;
        double d;
        int n6 = 0;
        long l3 = jSONObject.getLong("mediaSessionId");
        if (l3 != this.ly) {
            this.ly = l3;
            n6 = 1;
        }
        if (jSONObject.has("playerState")) {
            int n7 = 0;
            String string2 = jSONObject.getString("playerState");
            if (string2.equals("IDLE")) {
                n7 = 1;
            } else if (string2.equals("PLAYING")) {
                n7 = 2;
            } else if (string2.equals("PAUSED")) {
                n7 = 3;
            } else if (string2.equals("BUFFERING")) {
                n7 = 4;
            }
            if (n7 != this.lB) {
                this.lB = n7;
                n6 |= 2;
            }
            if (n7 == 1 && jSONObject.has("idleReason")) {
                int n8 = 0;
                string2 = jSONObject.getString("idleReason");
                if (string2.equals("CANCELLED")) {
                    n8 = 2;
                } else if (string2.equals("INTERRUPTED")) {
                    n8 = 3;
                } else if (string2.equals("FINISHED")) {
                    n8 = 1;
                } else if (string2.equals("ERROR")) {
                    n8 = 4;
                }
                if (n8 != this.lC) {
                    this.lC = n8;
                    n6 |= 2;
                }
            }
        }
        if (jSONObject.has("playbackRate") && this.lA != (d = jSONObject.getDouble("playbackRate"))) {
            this.lA = d;
            n6 |= 2;
        }
        if (jSONObject.has("currentTime") && (n & 2) == 0 && (l2 = zzf.zzf(jSONObject.getDouble("currentTime"))) != this.lD) {
            this.lD = l2;
            n6 |= 2;
        }
        if (jSONObject.has("supportedMediaCommands") && (l = jSONObject.getLong("supportedMediaCommands")) != this.lE) {
            this.lE = l;
            n6 |= 2;
        }
        if (jSONObject.has("volume") && (n & 1) == 0) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
            double d2 = jSONObject2.getDouble("level");
            if (d2 != this.lF) {
                this.lF = d2;
                n6 |= 2;
            }
            if ((n5 = (int)(jSONObject2.getBoolean("muted") ? 1 : 0)) != this.lG) {
                this.lG = n5;
                n6 |= 2;
            }
        }
        boolean bl = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            n5 = jSONArray.length();
            lArray = new long[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                lArray[n4] = jSONArray.getLong(n4);
            }
            if (this.lw == null) {
                bl = true;
            } else if (this.lw.length != n5) {
                bl = true;
            } else {
                for (n4 = 0; n4 < n5; ++n4) {
                    if (this.lw[n4] == lArray[n4]) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.lw = lArray;
            }
        } else if (this.lw != null) {
            bl = true;
        }
        if (bl) {
            this.lw = lArray;
            n6 |= 2;
        }
        if (jSONObject.has("customData")) {
            this.lh = jSONObject.getJSONObject("customData");
            this.lf = null;
            n6 |= 2;
        }
        if (jSONObject.has("media")) {
            JSONObject jSONObject3 = jSONObject.getJSONObject("media");
            this.li = new MediaInfo(jSONObject3);
            n6 |= 2;
            if (jSONObject3.has("metadata")) {
                n6 |= 4;
            }
        }
        if (jSONObject.has("currentItemId") && this.lz != (n3 = jSONObject.getInt("currentItemId"))) {
            this.lz = n3;
            n6 |= 2;
        }
        if (this.lI != (n2 = jSONObject.optInt("preloadedItemId", 0))) {
            this.lI = n2;
            n6 |= 0x10;
        }
        if (this.lH != (n5 = jSONObject.optInt("loadingItemId", 0))) {
            this.lH = n5;
            n6 |= 2;
        }
        int n9 = n4 = this.li == null ? -1 : this.li.getStreamType();
        if (!this.zzf(this.lB, this.lC, this.lH, n4)) {
            if (this.zzo(jSONObject)) {
                n6 |= 8;
            }
        } else {
            this.lz = 0;
            this.lH = 0;
            this.lI = 0;
            if (!this.lK.isEmpty()) {
                this.zzaka();
                n6 |= 8;
            }
        }
        return n6;
    }

    private boolean zzf(int n, int n2, int n3, int n4) {
        if (n != 1) {
            return false;
        }
        switch (n2) {
            case 1: 
            case 3: {
                return n3 == 0;
            }
            case 2: {
                return n4 != 2;
            }
        }
        return true;
    }

    private void zzaka() {
        this.lJ = 0;
        this.lK.clear();
        this.lM.clear();
    }

    public MediaQueueItem getItemById(int n) {
        Integer n2 = (Integer)this.lM.get(n);
        return n2 == null ? null : this.lK.get(n2);
    }

    public MediaQueueItem getItemByIndex(int n) {
        if (n < 0 || n >= this.lK.size()) {
            return null;
        }
        return this.lK.get(n);
    }

    public Integer getIndexById(int n) {
        return (Integer)this.lM.get(n);
    }

    boolean zzo(JSONObject jSONObject) throws JSONException {
        int n;
        String string2;
        boolean bl = false;
        if (jSONObject.has("repeatMode")) {
            String string3;
            int n2 = this.lJ;
            string2 = string3 = jSONObject.getString("repeatMode");
            n = -1;
            switch (string2.hashCode()) {
                case 1645952171: {
                    if (!string2.equals("REPEAT_OFF")) break;
                    n = 0;
                    break;
                }
                case 1645938909: {
                    if (!string2.equals("REPEAT_ALL")) break;
                    n = 1;
                    break;
                }
                case -962896020: {
                    if (!string2.equals("REPEAT_SINGLE")) break;
                    n = 2;
                    break;
                }
                case -1118317585: {
                    if (!string2.equals("REPEAT_ALL_AND_SHUFFLE")) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: {
                    n2 = 0;
                    break;
                }
                case 1: {
                    n2 = 1;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                }
            }
            if (this.lJ != n2) {
                this.lJ = n2;
                bl = true;
            }
        }
        if (jSONObject.has("items")) {
            JSONArray jSONArray = jSONObject.getJSONArray("items");
            int n3 = jSONArray.length();
            string2 = new SparseArray();
            for (n = 0; n < n3; ++n) {
                string2.put(n, (Object)jSONArray.getJSONObject(n).getInt("itemId"));
            }
            MediaQueueItem[] mediaQueueItemArray = new MediaQueueItem[n3];
            for (int i = 0; i < n3; ++i) {
                Integer n4 = (Integer)string2.get(i);
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                MediaQueueItem mediaQueueItem = this.getItemById(n4);
                if (mediaQueueItem != null) {
                    bl |= mediaQueueItem.zzn(jSONObject2);
                    mediaQueueItemArray[i] = mediaQueueItem;
                    if (i == this.getIndexById(n4)) continue;
                    bl = true;
                    continue;
                }
                bl = true;
                if (n4 == this.lz) {
                    mediaQueueItemArray[i] = new MediaQueueItem.Builder(this.li).build();
                    mediaQueueItemArray[i].zzn(jSONObject2);
                    continue;
                }
                mediaQueueItemArray[i] = new MediaQueueItem(jSONObject2);
            }
            if (this.lK.size() != n3) {
                bl = true;
            }
            this.zza(mediaQueueItemArray);
        }
        return bl;
    }

    private void zza(MediaQueueItem[] mediaQueueItemArray) {
        this.lK.clear();
        this.lM.clear();
        for (int i = 0; i < mediaQueueItemArray.length; ++i) {
            MediaQueueItem mediaQueueItem = mediaQueueItemArray[i];
            this.lK.add(mediaQueueItem);
            this.lM.put(mediaQueueItem.getItemId(), (Object)i);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaStatus)) {
            return false;
        }
        MediaStatus mediaStatus = (MediaStatus)((Object)object);
        if (this.lh == null != (mediaStatus.lh == null)) {
            return false;
        }
        return this.ly == mediaStatus.ly && this.lz == mediaStatus.lz && this.lA == mediaStatus.lA && this.lB == mediaStatus.lB && this.lC == mediaStatus.lC && this.lD == mediaStatus.lD && this.lF == mediaStatus.lF && this.lG == mediaStatus.lG && this.lH == mediaStatus.lH && this.lI == mediaStatus.lI && this.lJ == mediaStatus.lJ && Arrays.equals(this.lw, mediaStatus.lw) && zzf.zza(this.lE, mediaStatus.lE) && zzf.zza(this.lK, mediaStatus.lK) && zzf.zza(this.li, mediaStatus.li) && this.zza(mediaStatus) && this.lL == mediaStatus.isPlayingAd();
    }

    private boolean zza(MediaStatus mediaStatus) {
        return this.lh == null || mediaStatus.lh == null || zzp.zzf((Object)this.lh, (Object)mediaStatus.lh);
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.li, this.ly, this.lz, this.lA, this.lB, this.lC, this.lD, this.lE, this.lF, this.lG, Arrays.hashCode(this.lw), this.lH, this.lI, this.lh, this.lJ, this.lK, this.lL});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.lf = this.lh == null ? null : this.lh.toString();
        zzi.zza(this, parcel, n);
    }
}

