/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.zzh;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzp;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaQueueItem
extends AbstractSafeParcelable {
    public static final int INVALID_ITEM_ID = 0;
    public static final double DEFAULT_PLAYBACK_DURATION = Double.POSITIVE_INFINITY;
    public static final Parcelable.Creator<MediaQueueItem> CREATOR = new zzh();
    private final int mVersionCode;
    private MediaInfo lq;
    private int lr;
    private boolean ls;
    private double lt;
    private double lu;
    private double lv;
    private long[] lw;
    String lf;
    private JSONObject lh;

    MediaQueueItem(int n, MediaInfo mediaInfo, int n2, boolean bl, double d, double d2, double d3, long[] lArray, String string2) {
        this.mVersionCode = n;
        this.lq = mediaInfo;
        this.lr = n2;
        this.ls = bl;
        this.lt = d;
        this.lu = d2;
        this.lv = d3;
        this.lw = lArray;
        this.lf = string2;
        if (this.lf != null) {
            try {
                this.lh = new JSONObject(this.lf);
            }
            catch (JSONException jSONException) {
                this.lh = null;
                this.lf = null;
            }
        } else {
            this.lh = null;
        }
    }

    private MediaQueueItem(MediaInfo mediaInfo) throws IllegalArgumentException {
        this(1, mediaInfo, 0, true, 0.0, Double.POSITIVE_INFINITY, 0.0, null, null);
        if (mediaInfo == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
    }

    MediaQueueItem(JSONObject jSONObject) throws JSONException {
        this(1, null, 0, true, 0.0, Double.POSITIVE_INFINITY, 0.0, null, null);
        this.zzn(jSONObject);
    }

    private MediaQueueItem(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
        this(1, mediaQueueItem.getMedia(), mediaQueueItem.getItemId(), mediaQueueItem.getAutoplay(), mediaQueueItem.getStartTime(), mediaQueueItem.getPlaybackDuration(), mediaQueueItem.getPreloadTime(), mediaQueueItem.getActiveTrackIds(), null);
        if (this.lq == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.lh = mediaQueueItem.getCustomData();
    }

    public boolean zzn(JSONObject jSONObject) throws JSONException {
        double d;
        double d2;
        double d3;
        int n;
        boolean bl = false;
        if (jSONObject.has("media")) {
            this.lq = new MediaInfo(jSONObject.getJSONObject("media"));
            bl = true;
        }
        if (jSONObject.has("itemId") && this.lr != (n = jSONObject.getInt("itemId"))) {
            this.lr = n;
            bl = true;
        }
        if (jSONObject.has("autoplay") && this.ls != (n = (int)(jSONObject.getBoolean("autoplay") ? 1 : 0))) {
            this.ls = n;
            bl = true;
        }
        if (jSONObject.has("startTime") && Math.abs((d3 = jSONObject.getDouble("startTime")) - this.lt) > 1.0E-7) {
            this.lt = d3;
            bl = true;
        }
        if (jSONObject.has("playbackDuration") && Math.abs((d2 = jSONObject.getDouble("playbackDuration")) - this.lu) > 1.0E-7) {
            this.lu = d2;
            bl = true;
        }
        if (jSONObject.has("preloadTime") && Math.abs((d = jSONObject.getDouble("preloadTime")) - this.lv) > 1.0E-7) {
            this.lv = d;
            bl = true;
        }
        boolean bl2 = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n2;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            int n3 = jSONArray.length();
            lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = jSONArray.getLong(n2);
            }
            if (this.lw == null) {
                bl2 = true;
            } else if (this.lw.length != n3) {
                bl2 = true;
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.lw[n2] == lArray[n2]) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.lw = lArray;
            bl = true;
        }
        if (jSONObject.has("customData")) {
            this.lh = jSONObject.getJSONObject("customData");
            bl = true;
        }
        return bl;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public MediaInfo getMedia() {
        return this.lq;
    }

    public int getItemId() {
        return this.lr;
    }

    void zzeh(int n) {
        this.lr = n;
    }

    public boolean getAutoplay() {
        return this.ls;
    }

    void zzbj(boolean bl) {
        this.ls = bl;
    }

    public double getStartTime() {
        return this.lt;
    }

    void zzc(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        this.lt = d;
    }

    public double getPlaybackDuration() {
        return this.lu;
    }

    void zzd(double d) throws IllegalArgumentException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        this.lu = d;
    }

    public double getPreloadTime() {
        return this.lv;
    }

    void zze(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or NaN.");
        }
        this.lv = d;
    }

    public long[] getActiveTrackIds() {
        return this.lw;
    }

    void zza(long[] lArray) {
        this.lw = lArray;
    }

    public JSONObject getCustomData() {
        return this.lh;
    }

    void setCustomData(JSONObject jSONObject) {
        this.lh = jSONObject;
    }

    void zzajy() throws IllegalArgumentException {
        if (this.lq == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        if (Double.isNaN(this.lt) || this.lt < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        if (Double.isNaN(this.lu)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        if (Double.isNaN(this.lv) || this.lv < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or Nan.");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("media", (Object)this.lq.toJson());
            if (this.lr != 0) {
                jSONObject.put("itemId", this.lr);
            }
            jSONObject.put("autoplay", this.ls);
            jSONObject.put("startTime", this.lt);
            if (this.lu != Double.POSITIVE_INFINITY) {
                jSONObject.put("playbackDuration", this.lu);
            }
            jSONObject.put("preloadTime", this.lv);
            if (this.lw != null) {
                JSONArray jSONArray = new JSONArray();
                for (long l : this.lw) {
                    jSONArray.put(l);
                }
                jSONObject.put("activeTrackIds", (Object)jSONArray);
            }
            if (this.lh != null) {
                jSONObject.put("customData", (Object)this.lh);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaQueueItem)) {
            return false;
        }
        MediaQueueItem mediaQueueItem = (MediaQueueItem)((Object)object);
        if (this.lh == null != (mediaQueueItem.lh == null)) {
            return false;
        }
        if (this.lh != null && mediaQueueItem.lh != null && !zzp.zzf((Object)this.lh, (Object)mediaQueueItem.lh)) {
            return false;
        }
        return zzf.zza(this.lq, mediaQueueItem.lq) && this.lr == mediaQueueItem.lr && this.ls == mediaQueueItem.ls && this.lt == mediaQueueItem.lt && this.lu == mediaQueueItem.lu && this.lv == mediaQueueItem.lv && Arrays.equals(this.lw, mediaQueueItem.lw);
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.lq, this.lr, this.ls, this.lt, this.lu, this.lv, Arrays.hashCode(this.lw), String.valueOf(this.lh)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.lf = this.lh == null ? null : this.lh.toString();
        zzh.zza(this, parcel, n);
    }

    public static class Builder {
        private final MediaQueueItem lx;

        public Builder(MediaInfo mediaInfo) throws IllegalArgumentException {
            this.lx = new MediaQueueItem(mediaInfo);
        }

        public Builder(JSONObject jSONObject) throws JSONException {
            this.lx = new MediaQueueItem(jSONObject);
        }

        public Builder(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
            this.lx = new MediaQueueItem(mediaQueueItem);
        }

        public Builder clearItemId() {
            this.lx.zzeh(0);
            return this;
        }

        public Builder setAutoplay(boolean bl) {
            this.lx.zzbj(bl);
            return this;
        }

        public Builder setStartTime(double d) throws IllegalArgumentException {
            this.lx.zzc(d);
            return this;
        }

        public Builder setPlaybackDuration(double d) {
            this.lx.zzd(d);
            return this;
        }

        public Builder setPreloadTime(double d) throws IllegalArgumentException {
            this.lx.zze(d);
            return this;
        }

        public Builder setActiveTrackIds(long[] lArray) {
            this.lx.zza(lArray);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.lx.setCustomData(jSONObject);
            return this;
        }

        public MediaQueueItem build() {
            this.lx.zzajy();
            return this.lx;
        }
    }
}

