/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.zzf;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzp;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    public static final Parcelable.Creator<MediaInfo> CREATOR = new zzf();
    private final int mVersionCode;
    private final String kY;
    private int kZ;
    private String la;
    private MediaMetadata lb;
    private long lc;
    private List<MediaTrack> ld;
    private TextTrackStyle le;
    String lf;
    private List<AdBreakInfo> lg;
    private JSONObject lh;

    MediaInfo(int n, String string2, int n2, String string3, MediaMetadata mediaMetadata, long l, List<MediaTrack> list, TextTrackStyle textTrackStyle, String string4, List<AdBreakInfo> list2) {
        this.mVersionCode = n;
        this.kY = string2;
        this.kZ = n2;
        this.la = string3;
        this.lb = mediaMetadata;
        this.lc = l;
        this.ld = list;
        this.le = textTrackStyle;
        this.lf = string4;
        if (this.lf != null) {
            try {
                this.lh = new JSONObject(this.lf);
            }
            catch (JSONException jSONException) {
                this.lh = null;
                this.lf = null;
            }
        } else {
            this.lh = null;
        }
        this.lg = list2;
    }

    MediaInfo(String string2) throws IllegalArgumentException {
        this(1, string2, -1, null, null, -1L, null, null, null, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
    }

    MediaInfo(JSONObject jSONObject) throws JSONException {
        this(1, jSONObject.getString("contentId"), -1, null, null, -1L, null, null, null, null);
        double d;
        int n;
        JSONObject jSONObject2;
        String string2 = jSONObject.getString("streamType");
        this.kZ = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.la = jSONObject.getString("contentType");
        if (jSONObject.has("metadata")) {
            jSONObject2 = jSONObject.getJSONObject("metadata");
            n = jSONObject2.getInt("metadataType");
            this.lb = new MediaMetadata(n);
            this.lb.zzm(jSONObject2);
        }
        this.lc = -1L;
        if (jSONObject.has("duration") && !jSONObject.isNull("duration") && !Double.isNaN(d = jSONObject.optDouble("duration", 0.0)) && !Double.isInfinite(d)) {
            this.lc = com.google.android.gms.cast.internal.zzf.zzf(d);
        }
        if (jSONObject.has("tracks")) {
            this.ld = new ArrayList<MediaTrack>();
            jSONObject2 = jSONObject.getJSONArray("tracks");
            for (n = 0; n < jSONObject2.length(); ++n) {
                JSONObject jSONObject3 = jSONObject2.getJSONObject(n);
                MediaTrack mediaTrack = new MediaTrack(jSONObject3);
                this.ld.add(mediaTrack);
            }
        } else {
            this.ld = null;
        }
        if (jSONObject.has("textTrackStyle")) {
            jSONObject2 = jSONObject.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.zzm(jSONObject2);
            this.le = textTrackStyle;
        } else {
            this.le = null;
        }
        this.lh = jSONObject.optJSONObject("customData");
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getContentId() {
        return this.kY;
    }

    void setStreamType(int n) throws IllegalArgumentException {
        if (n < -1 || n > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.kZ = n;
    }

    public int getStreamType() {
        return this.kZ;
    }

    void setContentType(String string2) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.la = string2;
    }

    public String getContentType() {
        return this.la;
    }

    void zza(MediaMetadata mediaMetadata) {
        this.lb = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.lb;
    }

    void zzab(long l) throws IllegalArgumentException {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Invalid stream duration");
        }
        this.lc = l;
    }

    public long getStreamDuration() {
        return this.lc;
    }

    void zzx(List<MediaTrack> list) {
        this.ld = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.ld;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.le = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.le;
    }

    void setCustomData(JSONObject jSONObject) {
        this.lh = jSONObject;
    }

    public JSONObject getCustomData() {
        return this.lh;
    }

    public List<AdBreakInfo> getAdBreaks() {
        return this.lg;
    }

    public void zzy(List<AdBreakInfo> list) {
        this.lg = list;
    }

    void zzajy() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.kY)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.la)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.kZ == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            jSONObject.put("contentId", (Object)this.kY);
            switch (this.kZ) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.la != null) {
                jSONObject.put("contentType", (Object)this.la);
            }
            if (this.lb != null) {
                jSONObject.put("metadata", (Object)this.lb.toJson());
            }
            if (this.lc <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                jSONObject.put("duration", com.google.android.gms.cast.internal.zzf.zzaf(this.lc));
            }
            if (this.ld != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.ld) {
                    jSONArray.put((Object)mediaTrack.toJson());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.le != null) {
                jSONObject.put("textTrackStyle", (Object)this.le.toJson());
            }
            if (this.lh != null) {
                jSONObject.put("customData", (Object)this.lh);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)((Object)object);
        if (this.lh == null != (mediaInfo.lh == null)) {
            return false;
        }
        if (this.lh != null && mediaInfo.lh != null && !zzp.zzf((Object)this.lh, (Object)mediaInfo.lh)) {
            return false;
        }
        return com.google.android.gms.cast.internal.zzf.zza(this.kY, mediaInfo.kY) && this.kZ == mediaInfo.kZ && com.google.android.gms.cast.internal.zzf.zza(this.la, mediaInfo.la) && com.google.android.gms.cast.internal.zzf.zza(this.lb, mediaInfo.lb) && this.lc == mediaInfo.lc;
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.kY, this.kZ, this.la, this.lb, this.lc, String.valueOf(this.lh)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.lf = this.lh == null ? null : this.lh.toString();
        zzf.zza(this, parcel, n);
    }

    public static class Builder {
        private final MediaInfo li;

        public Builder(String string2) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.li = new MediaInfo(string2);
        }

        public Builder setStreamType(int n) throws IllegalArgumentException {
            this.li.setStreamType(n);
            return this;
        }

        public Builder setContentType(String string2) throws IllegalArgumentException {
            this.li.setContentType(string2);
            return this;
        }

        public Builder setMetadata(MediaMetadata mediaMetadata) {
            this.li.zza(mediaMetadata);
            return this;
        }

        public Builder setStreamDuration(long l) throws IllegalArgumentException {
            this.li.zzab(l);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.li.setCustomData(jSONObject);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> list) {
            this.li.zzx(list);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.li.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.li.zzajy();
            return this.li;
        }
    }
}

