/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationCompat;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;
import android.view.Display;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastMediaControlIntent;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=19)
public abstract class CastRemoteDisplayLocalService
extends Service {
    private static final zzm kr = new zzm("CastRemoteDisplayLocalService");
    private static final int ks = CastRemoteDisplayLocalService.zzajl();
    private static final Object kt = new Object();
    private static AtomicBoolean ku = new AtomicBoolean(false);
    private GoogleApiClient kv;
    private CastRemoteDisplay.CastRemoteDisplaySessionCallbacks kw;
    private String jM;
    private Callbacks kx;
    private zzb ky;
    private NotificationSettings kz;
    private Notification mNotification;
    private boolean kA;
    private PendingIntent kB;
    private CastDevice kC;
    private Display zzbzd;
    private Context kD;
    private ServiceConnection kE;
    private Handler mHandler;
    private MediaRouter kF;
    private boolean kG = false;
    private final MediaRouter.Callback kH = new MediaRouter.Callback(){

        public void onRouteUnselected(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            CastRemoteDisplayLocalService.this.zzeq("onRouteUnselected");
            if (CastRemoteDisplayLocalService.this.kC == null) {
                CastRemoteDisplayLocalService.this.zzeq("onRouteUnselected, no device was selected");
                return;
            }
            CastDevice castDevice = CastDevice.getFromBundle(routeInfo.getExtras());
            if (!castDevice.getDeviceId().equals(CastRemoteDisplayLocalService.this.kC.getDeviceId())) {
                CastRemoteDisplayLocalService.this.zzeq("onRouteUnselected, device does not match");
                return;
            }
            CastRemoteDisplayLocalService.stopService();
        }
    };
    private static CastRemoteDisplayLocalService kI;
    private final IBinder kJ = new zza();

    private static int zzajl() {
        return R.id.cast_notification_id;
    }

    public IBinder onBind(Intent intent) {
        this.zzeq("onBind");
        return this.kJ;
    }

    public void onCreate() {
        this.zzeq("onCreate");
        super.onCreate();
        this.mHandler = new Handler(this.getMainLooper());
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                boolean bl = CastRemoteDisplayLocalService.this.kG;
                CastRemoteDisplayLocalService.this.zzeq(new StringBuilder(59).append("onCreate after delay. The local service been started: ").append(bl).toString());
                if (!CastRemoteDisplayLocalService.this.kG) {
                    CastRemoteDisplayLocalService.this.zzet("The local service has not been been started, stopping it");
                    CastRemoteDisplayLocalService.this.stopSelf();
                }
            }
        }, 100L);
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        this.zzeq("onStartCommand");
        this.kG = true;
        return 2;
    }

    protected static void setDebugEnabled() {
        kr.zzbp(true);
    }

    protected Display getDisplay() {
        return this.zzbzd;
    }

    public abstract void onCreatePresentation(Display var1);

    public abstract void onDismissPresentation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CastRemoteDisplayLocalService getInstance() {
        Object object = kt;
        synchronized (object) {
            return kI;
        }
    }

    public static void startService(Context context, Class<? extends CastRemoteDisplayLocalService> clazz, String string2, CastDevice castDevice, NotificationSettings notificationSettings, Callbacks callbacks) {
        CastRemoteDisplayLocalService.startServiceWithOptions(context, clazz, string2, castDevice, new Options(), notificationSettings, callbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startServiceWithOptions(final @NonNull Context context, @NonNull Class<? extends CastRemoteDisplayLocalService> clazz, final @NonNull String string2, final @NonNull CastDevice castDevice, final @NonNull Options options, final @NonNull NotificationSettings notificationSettings, final @NonNull Callbacks callbacks) {
        kr.zzb("Starting Service", new Object[0]);
        Object object = kt;
        synchronized (object) {
            if (kI != null) {
                kr.zzf("An existing service had not been stopped before starting one", new Object[0]);
                CastRemoteDisplayLocalService.zzbg(true);
            }
        }
        CastRemoteDisplayLocalService.zza(context, clazz);
        zzac.zzb((Object)context, (Object)"activityContext is required.");
        zzac.zzb(clazz, (Object)"serviceClass is required.");
        zzac.zzb((Object)string2, (Object)"applicationId is required.");
        zzac.zzb((Object)((Object)castDevice), (Object)"device is required.");
        zzac.zzb((Object)options, (Object)"options is required.");
        zzac.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzac.zzb((Object)callbacks, (Object)"callbacks is required.");
        if (notificationSettings.mNotification == null && notificationSettings.kR == null) {
            throw new IllegalArgumentException("notificationSettings: Either the notification or the notificationPendingIntent must be provided");
        }
        if (ku.getAndSet(true)) {
            kr.zzc("Service is already being started, startService has been called twice", new Object[0]);
            return;
        }
        object = new Intent(context, clazz);
        context.startService((Intent)object);
        context.bindService((Intent)object, new ServiceConnection(){

            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                CastRemoteDisplayLocalService castRemoteDisplayLocalService = ((zza)iBinder).zzajx();
                if (castRemoteDisplayLocalService == null || !castRemoteDisplayLocalService.zza(string2, castDevice, options, notificationSettings, context, this, callbacks)) {
                    kr.zzc("Connected but unable to get the service instance", new Object[0]);
                    callbacks.onRemoteDisplaySessionError(new Status(2200));
                    ku.set(false);
                    try {
                        context.unbindService((ServiceConnection)this);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        kr.zzb("No need to unbind service, already unbound", new Object[0]);
                    }
                }
            }

            public void onServiceDisconnected(ComponentName componentName) {
                kr.zzb("onServiceDisconnected", new Object[0]);
                callbacks.onRemoteDisplaySessionError(new Status(2201, "Service Disconnected"));
                ku.set(false);
                try {
                    context.unbindService((ServiceConnection)this);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    kr.zzb("No need to unbind service, already unbound", new Object[0]);
                }
            }
        }, 64);
    }

    private void zzbe(final boolean bl) {
        if (this.mHandler != null) {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        CastRemoteDisplayLocalService.this.zzbf(bl);
                    }
                });
            } else {
                this.zzbf(bl);
            }
        }
    }

    private void zzbf(boolean bl) {
        this.zzeq("Stopping Service");
        zzac.zzhq((String)"stopServiceInstanceInternal must be called on the main thread");
        if (!bl && this.kF != null) {
            this.zzeq("Setting default route");
            this.kF.selectRoute(this.kF.getDefaultRoute());
        }
        if (this.ky != null) {
            this.zzeq("Unregistering notification receiver");
            this.unregisterReceiver(this.ky);
        }
        this.zzajq();
        this.zzajr();
        this.zzajm();
        if (this.kv != null) {
            this.kv.disconnect();
            this.kv = null;
        }
        if (this.kD != null && this.kE != null) {
            try {
                this.kD.unbindService(this.kE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.zzeq("No need to unbind service, already unbound");
            }
            this.kE = null;
            this.kD = null;
        }
        this.jM = null;
        this.kv = null;
        this.mNotification = null;
        this.zzbzd = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzbg(boolean bl) {
        CastRemoteDisplayLocalService castRemoteDisplayLocalService;
        kr.zzb("Stopping Service", new Object[0]);
        ku.set(false);
        Object object = kt;
        synchronized (object) {
            if (kI == null) {
                kr.zzc("Service is already being stopped", new Object[0]);
                return;
            }
            castRemoteDisplayLocalService = kI;
            kI = null;
        }
        castRemoteDisplayLocalService.zzbe(bl);
    }

    public static void stopService() {
        CastRemoteDisplayLocalService.zzbg(false);
    }

    public void updateNotificationSettings(final NotificationSettings notificationSettings) {
        zzac.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzac.zzb((Object)this.mHandler, (Object)"Service is not ready yet.");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                CastRemoteDisplayLocalService.this.zza(notificationSettings);
            }
        });
    }

    private void zza(NotificationSettings notificationSettings) {
        zzac.zzhq((String)"updateNotificationSettingsInternal must be called on the main thread");
        if (this.kz == null) {
            throw new IllegalStateException("No current notification settings to update");
        }
        if (this.kA) {
            if (notificationSettings.mNotification != null) {
                throw new IllegalStateException("Current mode is default notification, notification attribute must not be provided");
            }
            if (notificationSettings.kR != null) {
                this.kz.kR = notificationSettings.kR;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.kS)) {
                this.kz.kS = notificationSettings.kS;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.kT)) {
                this.kz.kT = notificationSettings.kT;
            }
            this.mNotification = this.zzbh(true);
        } else {
            zzac.zzb((Object)notificationSettings.mNotification, (Object)"notification is required.");
            this.mNotification = notificationSettings.mNotification;
            this.kz.mNotification = this.mNotification;
        }
        this.startForeground(ks, this.mNotification);
    }

    private static void zza(Context context, Class<? extends CastRemoteDisplayLocalService> clazz) {
        try {
            ComponentName componentName = new ComponentName(context, clazz);
            ServiceInfo serviceInfo = context.getPackageManager().getServiceInfo(componentName, 128);
            if (serviceInfo != null && serviceInfo.exported) {
                throw new IllegalStateException("The service must not be exported, verify the manifest configuration");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException("Service not found, did you forget to configure it in the manifest?");
        }
    }

    private void zza(Display display) {
        this.zzbzd = display;
        if (this.kA) {
            this.mNotification = this.zzbh(true);
            this.startForeground(ks, this.mNotification);
        }
        if (this.kx != null) {
            this.kx.onRemoteDisplaySessionStarted(this);
            this.kx = null;
        }
        this.onCreatePresentation(this.zzbzd);
    }

    private void zzajm() {
        if (this.kF != null) {
            zzac.zzhq((String)"CastRemoteDisplayLocalService calls must be done on the main thread");
            this.zzeq("removeMediaRouterCallback");
            this.kF.removeCallback(this.kH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(String string2, CastDevice castDevice, Options options, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        this.zzeq("startRemoteDisplaySession");
        zzac.zzhq((String)"Starting the Cast Remote Display must be done on the main thread");
        Object object = kt;
        synchronized (object) {
            if (kI != null) {
                kr.zzf("An existing service had not been stopped before starting one", new Object[0]);
                return false;
            }
            kI = this;
        }
        this.kx = callbacks;
        this.jM = string2;
        this.kC = castDevice;
        this.kD = context;
        this.kE = serviceConnection;
        this.kF = MediaRouter.getInstance((Context)this.getApplicationContext());
        object = new MediaRouteSelector.Builder().addControlCategory(CastMediaControlIntent.categoryForCast(this.jM)).build();
        this.zzeq("addMediaRouterCallback");
        this.kF.addCallback((MediaRouteSelector)object, this.kH, 4);
        this.kw = new CastRemoteDisplay.CastRemoteDisplaySessionCallbacks(){

            @Override
            public void onRemoteDisplayEnded(Status status) {
                kr.zzb(String.format("Cast screen has ended: %d", status.getStatusCode()), new Object[0]);
                CastRemoteDisplayLocalService.zzbg(false);
            }
        };
        this.mNotification = notificationSettings.mNotification;
        this.ky = new zzb();
        this.registerReceiver(this.ky, new IntentFilter("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT"));
        this.kz = new NotificationSettings(notificationSettings);
        if (this.kz.mNotification == null) {
            this.kA = true;
            this.mNotification = this.zzbh(false);
        } else {
            this.kA = false;
            this.mNotification = this.kz.mNotification;
        }
        this.startForeground(ks, this.mNotification);
        this.kv = this.zza(castDevice, options);
        this.kv.connect();
        if (this.kx != null) {
            this.kx.onServiceCreated(this);
        }
        return true;
    }

    private void zzajn() {
        this.zzeq("startRemoteDisplay");
        if (this.kv == null || !this.kv.isConnected()) {
            kr.zzc("Unable to start the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.startRemoteDisplay(this.kv, this.jM).setResultCallback((ResultCallback)new ResultCallback<CastRemoteDisplay.CastRemoteDisplaySessionResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void zza(CastRemoteDisplay.CastRemoteDisplaySessionResult castRemoteDisplaySessionResult) {
                if (!castRemoteDisplaySessionResult.getStatus().isSuccess()) {
                    kr.zzc("Connection was not successful", new Object[0]);
                    CastRemoteDisplayLocalService.this.zzajp();
                    return;
                }
                kr.zzb("startRemoteDisplay successful", new Object[0]);
                Object object = kt;
                synchronized (object) {
                    if (kI == null) {
                        kr.zzb("Remote Display started but session already cancelled", new Object[0]);
                        CastRemoteDisplayLocalService.this.zzajp();
                        return;
                    }
                }
                object = castRemoteDisplaySessionResult.getPresentationDisplay();
                if (object != null) {
                    CastRemoteDisplayLocalService.this.zza((Display)object);
                } else {
                    kr.zzc("Cast Remote Display session created without display", new Object[0]);
                }
                ku.set(false);
                if (CastRemoteDisplayLocalService.this.kD != null && CastRemoteDisplayLocalService.this.kE != null) {
                    try {
                        CastRemoteDisplayLocalService.this.kD.unbindService(CastRemoteDisplayLocalService.this.kE);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        kr.zzb("No need to unbind service, already unbound", new Object[0]);
                    }
                    CastRemoteDisplayLocalService.this.kE = null;
                    CastRemoteDisplayLocalService.this.kD = null;
                }
            }

            public /* synthetic */ void onResult(Result result) {
                this.zza((CastRemoteDisplay.CastRemoteDisplaySessionResult)result);
            }
        });
    }

    private void zzajo() {
        this.zzeq("stopRemoteDisplay");
        if (this.kv == null || !this.kv.isConnected()) {
            kr.zzc("Unable to stop the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.stopRemoteDisplay(this.kv).setResultCallback((ResultCallback)new ResultCallback<CastRemoteDisplay.CastRemoteDisplaySessionResult>(){

            public void zza(CastRemoteDisplay.CastRemoteDisplaySessionResult castRemoteDisplaySessionResult) {
                if (!castRemoteDisplaySessionResult.getStatus().isSuccess()) {
                    CastRemoteDisplayLocalService.this.zzeq("Unable to stop the remote display, result unsuccessful");
                } else {
                    CastRemoteDisplayLocalService.this.zzeq("remote display stopped");
                }
                CastRemoteDisplayLocalService.this.zzbzd = null;
            }

            public /* synthetic */ void onResult(Result result) {
                this.zza((CastRemoteDisplay.CastRemoteDisplaySessionResult)result);
            }
        });
    }

    private void zzajp() {
        if (this.kx != null) {
            this.kx.onRemoteDisplaySessionError(new Status(2200));
            this.kx = null;
        }
        CastRemoteDisplayLocalService.stopService();
    }

    private void zzajq() {
        this.zzeq("stopRemoteDisplaySession");
        this.zzajo();
        this.onDismissPresentation();
    }

    private void zzajr() {
        this.zzeq("Stopping the remote display Service");
        this.stopForeground(true);
        this.stopSelf();
    }

    private GoogleApiClient zza(CastDevice castDevice, Options options) {
        CastRemoteDisplay.CastRemoteDisplayOptions.Builder builder = new CastRemoteDisplay.CastRemoteDisplayOptions.Builder(castDevice, this.kw);
        if (options != null) {
            builder.setConfigPreset(options.ko);
        }
        GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

            public void onConnected(Bundle bundle) {
                CastRemoteDisplayLocalService.this.zzeq("onConnected");
                CastRemoteDisplayLocalService.this.zzajn();
            }

            public void onConnectionSuspended(int n) {
                kr.zzf(String.format("[Instance: %s] ConnectionSuspended %d", this, n), new Object[0]);
            }
        };
        GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

            public void onConnectionFailed(ConnectionResult connectionResult) {
                String string2 = String.valueOf(connectionResult);
                CastRemoteDisplayLocalService.this.zzet(new StringBuilder(19 + String.valueOf(string2).length()).append("Connection failed: ").append(string2).toString());
                CastRemoteDisplayLocalService.this.zzajp();
            }
        };
        return new GoogleApiClient.Builder((Context)this, connectionCallbacks, onConnectionFailedListener).addApi(CastRemoteDisplay.API, (Api.ApiOptions.HasOptions)builder.build()).build();
    }

    private PendingIntent zzajs() {
        if (this.kB == null) {
            Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
            intent.setPackage(this.kD.getPackageName());
            this.kB = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)intent, (int)0x10000000);
        }
        return this.kB;
    }

    private Notification zzbh(boolean bl) {
        int n;
        int n2;
        this.zzeq("createDefaultNotification");
        int n3 = this.getApplicationInfo().labelRes;
        String string2 = this.kz.kS;
        String string3 = this.kz.kT;
        if (bl) {
            n2 = R.string.cast_notification_connected_message;
            n = R.drawable.cast_ic_notification_on;
        } else {
            n2 = R.string.cast_notification_connecting_message;
            n = R.drawable.cast_ic_notification_connecting;
        }
        String string4 = TextUtils.isEmpty((CharSequence)string2) ? this.getString(n3) : string2;
        String string5 = TextUtils.isEmpty((CharSequence)string3) ? this.getString(n2, new Object[]{this.kC.getFriendlyName()}) : string3;
        Notification notification = new NotificationCompat.Builder((Context)this).setContentTitle((CharSequence)string4).setContentText((CharSequence)string5).setContentIntent(this.kz.kR).setSmallIcon(n).setOngoing(true).addAction(17301560, (CharSequence)this.getString(R.string.cast_notification_disconnect), this.zzajs()).build();
        return notification;
    }

    private void zzeq(String string2) {
        kr.zzb("[Instance: %s] %s", new Object[]{this, string2});
    }

    private void zzet(String string2) {
        kr.zzc("[Instance: %s] %s", new Object[]{this, string2});
    }

    private class zza
    extends Binder {
        private zza() {
        }

        CastRemoteDisplayLocalService zzajx() {
            return CastRemoteDisplayLocalService.this;
        }
    }

    private static final class zzb
    extends BroadcastReceiver {
        private zzb() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT")) {
                kr.zzb("disconnecting", new Object[0]);
                CastRemoteDisplayLocalService.stopService();
            }
        }
    }

    public static class Options {
        @CastRemoteDisplay.Configuration
        int ko = 2;

        public void setConfigPreset(@CastRemoteDisplay.Configuration int n) {
            this.ko = n;
        }

        public int getConfigPreset() {
            return this.ko;
        }
    }

    public static final class NotificationSettings {
        private Notification mNotification;
        private PendingIntent kR;
        private String kS;
        private String kT;

        private NotificationSettings() {
        }

        private NotificationSettings(NotificationSettings notificationSettings) {
            this.mNotification = notificationSettings.mNotification;
            this.kR = notificationSettings.kR;
            this.kS = notificationSettings.kS;
            this.kT = notificationSettings.kT;
        }

        public static final class Builder {
            private NotificationSettings kU = new NotificationSettings();

            public Builder setNotification(Notification notification) {
                this.kU.mNotification = notification;
                return this;
            }

            public Builder setNotificationPendingIntent(PendingIntent pendingIntent) {
                this.kU.kR = pendingIntent;
                return this;
            }

            public Builder setNotificationTitle(String string2) {
                this.kU.kS = string2;
                return this;
            }

            public Builder setNotificationText(String string2) {
                this.kU.kT = string2;
                return this;
            }

            public NotificationSettings build() {
                if (this.kU.mNotification != null) {
                    if (!TextUtils.isEmpty((CharSequence)this.kU.kS)) {
                        throw new IllegalArgumentException("notificationTitle requires using the default notification");
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.kU.kT)) {
                        throw new IllegalArgumentException("notificationText requires using the default notification");
                    }
                    if (this.kU.kR != null) {
                        throw new IllegalArgumentException("notificationPendingIntent requires using the default notification");
                    }
                } else if (TextUtils.isEmpty((CharSequence)this.kU.kS) && TextUtils.isEmpty((CharSequence)this.kU.kT) && this.kU.kR == null) {
                    throw new IllegalArgumentException("At least an argument must be provided");
                }
                return this.kU;
            }
        }
    }

    public static interface Callbacks {
        public void onServiceCreated(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionStarted(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionError(Status var1);
    }
}

