/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.view.Display;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastRemoteDisplayApi;
import com.google.android.gms.cast.internal.zzh;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzpm;
import com.google.android.gms.internal.zzpn;

public final class CastRemoteDisplay {
    public static final int CONFIGURATION_INTERACTIVE_REALTIME = 1;
    public static final int CONFIGURATION_INTERACTIVE_NONREALTIME = 2;
    public static final int CONFIGURATION_NONINTERACTIVE = 3;
    private static final Api.zza<zzpn, CastRemoteDisplayOptions> fb = new Api.zza<zzpn, CastRemoteDisplayOptions>(){

        public zzpn zza(Context context, Looper looper, com.google.android.gms.common.internal.zzh zzh2, CastRemoteDisplayOptions castRemoteDisplayOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            Bundle bundle = new Bundle();
            bundle.putInt("configuration", castRemoteDisplayOptions.ko);
            return new zzpn(context, looper, zzh2, castRemoteDisplayOptions.jV, bundle, castRemoteDisplayOptions.kn, connectionCallbacks, onConnectionFailedListener);
        }
    };
    public static final Api<CastRemoteDisplayOptions> API = new Api("CastRemoteDisplay.API", fb, zzl.sP);
    public static final CastRemoteDisplayApi CastRemoteDisplayApi = new zzpm(API);

    public static final boolean isRemoteDisplaySdkSupported(Context context) {
        zzh.initialize(context);
        return (Boolean)zzh.sN.get();
    }

    private CastRemoteDisplay() {
    }

    public static final class CastRemoteDisplayOptions
    implements Api.ApiOptions.HasOptions {
        final CastDevice jV;
        final CastRemoteDisplaySessionCallbacks kn;
        final int ko;

        private CastRemoteDisplayOptions(Builder builder) {
            this.jV = builder.jY;
            this.kn = builder.kp;
            this.ko = builder.kq;
        }

        public static final class Builder {
            CastDevice jY;
            CastRemoteDisplaySessionCallbacks kp;
            int kq;

            public Builder(CastDevice castDevice, CastRemoteDisplaySessionCallbacks castRemoteDisplaySessionCallbacks) {
                zzac.zzb((Object)((Object)castDevice), (Object)"CastDevice parameter cannot be null");
                this.jY = castDevice;
                this.kp = castRemoteDisplaySessionCallbacks;
                this.kq = 2;
            }

            public Builder setConfigPreset(@Configuration int n) {
                this.kq = n;
                return this;
            }

            public CastRemoteDisplayOptions build() {
                return new CastRemoteDisplayOptions(this);
            }
        }
    }

    public static interface CastRemoteDisplaySessionResult
    extends Result {
        public Display getPresentationDisplay();
    }

    public static interface CastRemoteDisplaySessionCallbacks {
        public void onRemoteDisplayEnded(Status var1);
    }

    public static @interface Configuration {
    }
}

