/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.zzc;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final int CAPABILITY_VIDEO_OUT = 1;
    public static final int CAPABILITY_VIDEO_IN = 2;
    public static final int CAPABILITY_AUDIO_OUT = 4;
    public static final int CAPABILITY_AUDIO_IN = 8;
    public static final int CAPABILITY_MULTIZONE_GROUP = 32;
    public static final Parcelable.Creator<CastDevice> CREATOR = new zzc();
    private final int mVersionCode;
    private String kd;
    String ke;
    private Inet4Address kf;
    private String kg;
    private String kh;
    private String ki;
    private int kj;
    private List<WebImage> kk;
    private int kl;
    private int zzbqm;
    private String km;

    CastDevice(int n, String string, String string2, String string3, String string4, String string5, int n2, List<WebImage> arrayList, int n3, int n4, String string6) {
        this.mVersionCode = n;
        this.kd = CastDevice.zzgg(string);
        this.ke = CastDevice.zzgg(string2);
        if (!TextUtils.isEmpty((CharSequence)this.ke)) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.ke);
                if (inetAddress instanceof Inet4Address) {
                    this.kf = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                String string7 = this.ke;
                String string8 = String.valueOf(unknownHostException.getMessage());
                Log.i((String)"CastDevice", (String)new StringBuilder(48 + String.valueOf(string7).length() + String.valueOf(string8).length()).append("Unable to convert host address (").append(string7).append(") to ipaddress: ").append(string8).toString());
            }
        }
        this.kg = CastDevice.zzgg(string3);
        this.kh = CastDevice.zzgg(string4);
        this.ki = CastDevice.zzgg(string5);
        this.kj = n2;
        this.kk = arrayList != null ? arrayList : new ArrayList();
        this.kl = n3;
        this.zzbqm = n4;
        this.km = CastDevice.zzgg(string6);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public String getDeviceId() {
        if (this.kd.startsWith("__cast_nearby__")) {
            return this.kd.substring("__cast_nearby__".length() + 1);
        }
        return this.kd;
    }

    public String zzaji() {
        return this.kd;
    }

    public Inet4Address getIpAddress() {
        return this.kf;
    }

    public String getFriendlyName() {
        return this.kg;
    }

    public String getModelName() {
        return this.kh;
    }

    public String getDeviceVersion() {
        return this.ki;
    }

    public String zzajj() {
        return this.km;
    }

    public int getServicePort() {
        return this.kj;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.kk);
    }

    public WebImage getIcon(int n, int n2) {
        if (this.kk.isEmpty()) {
            return null;
        }
        if (n <= 0 || n2 <= 0) {
            return this.kk.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.kk) {
            int n3 = webImage3.getWidth();
            int n4 = webImage3.getHeight();
            if (n3 >= n && n4 >= n2) {
                if (webImage != null && (webImage.getWidth() <= n3 || webImage.getHeight() <= n4)) continue;
                webImage = webImage3;
                continue;
            }
            if (n3 >= n || n4 >= n2 || webImage2 != null && (webImage2.getWidth() >= n3 || webImage2.getHeight() >= n4)) continue;
            webImage2 = webImage3;
        }
        WebImage webImage4 = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.kk.get(0));
        return webImage4;
    }

    public boolean hasIcons() {
        return !this.kk.isEmpty();
    }

    public int getCapabilities() {
        return this.kl;
    }

    public boolean hasCapability(int n) {
        return (this.kl & n) == n;
    }

    public boolean hasCapabilities(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        for (int n : nArray) {
            if (this.hasCapability(n)) continue;
            return false;
        }
        return true;
    }

    public int getStatus() {
        return this.zzbqm;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.kg, this.kd);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)((Object)object);
        if (this.kd == null) {
            return castDevice.kd == null;
        }
        return zzf.zza(this.kd, castDevice.kd) && zzf.zza(this.kf, castDevice.kf) && zzf.zza(this.kh, castDevice.kh) && zzf.zza(this.kg, castDevice.kg) && zzf.zza(this.ki, castDevice.ki) && this.kj == castDevice.kj && zzf.zza(this.kk, castDevice.kk) && this.kl == castDevice.kl && this.zzbqm == castDevice.zzbqm && zzf.zza(this.km, castDevice.km);
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.kd == null) {
            return castDevice.kd == null;
        }
        return zzf.zza(this.kd, castDevice.kd);
    }

    public int hashCode() {
        return this.kd == null ? 0 : this.kd.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        bundle.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)bundle.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }

    public boolean isOnLocalNetwork() {
        return !this.kd.startsWith("__cast_nearby__");
    }

    private static String zzgg(String string) {
        return string == null ? "" : string;
    }
}

