/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.zzb;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ApplicationMetadata
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<ApplicationMetadata> CREATOR = new zzb();
    private final int mVersionCode;
    String jM;
    String mName;
    List<WebImage> zzbjr;
    List<String> jN;
    String jO;
    Uri jP;

    ApplicationMetadata(int n, String string, String string2, List<WebImage> list, List<String> list2, String string3, Uri uri) {
        this.mVersionCode = n;
        this.jM = string;
        this.mName = string2;
        this.zzbjr = list;
        this.jN = list2;
        this.jO = string3;
        this.jP = uri;
    }

    private ApplicationMetadata() {
        this.mVersionCode = 1;
        this.zzbjr = new ArrayList<WebImage>();
        this.jN = new ArrayList<String>();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getApplicationId() {
        return this.jM;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isNamespaceSupported(String string) {
        return this.jN != null && this.jN.contains(string);
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.jN);
    }

    public boolean areNamespacesSupported(List<String> list) {
        return this.jN != null && this.jN.containsAll(list);
    }

    public String getSenderAppIdentifier() {
        return this.jO;
    }

    public Uri zzajh() {
        return this.jP;
    }

    public List<WebImage> getImages() {
        return this.zzbjr;
    }

    public String toString() {
        return "applicationId: " + this.jM + ", name: " + this.mName + ", images.count: " + (this.zzbjr == null ? 0 : this.zzbjr.size()) + ", namespaces.count: " + (this.jN == null ? 0 : this.jN.size()) + ", senderAppIdentifier: " + this.jO + ", senderAppLaunchUrl: " + this.jP;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.mVersionCode, this.jM, this.mName, this.zzbjr, this.jN, this.jO, this.jP});
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ApplicationMetadata)) {
            return false;
        }
        ApplicationMetadata applicationMetadata = (ApplicationMetadata)((Object)object);
        return zzf.zza(this.jM, applicationMetadata.jM) && zzf.zza(this.zzbjr, applicationMetadata.zzbjr) && zzf.zza(this.mName, applicationMetadata.mName) && zzf.zza(this.jN, applicationMetadata.jN) && zzf.zza(this.jO, applicationMetadata.jO) && zzf.zza(this.jP, applicationMetadata.jP);
    }
}

