/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.maps.internal.zzc;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public class zzai {
    private static Context amt;
    private static zzc amu;

    public static zzc zzdp(Context context) throws GooglePlayServicesNotAvailableException {
        zzac.zzy((Object)context);
        if (amu != null) {
            return amu;
        }
        zzai.zzdq(context);
        amu = zzai.zzdr(context);
        try {
            amu.zzh(zze.zzac((Object)zzai.getRemoteContext(context).getResources()), GooglePlayServicesUtil.GOOGLE_PLAY_SERVICES_VERSION_CODE);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return amu;
    }

    public static boolean zzbse() {
        return false;
    }

    private static Class<?> zzbsf() {
        try {
            return Class.forName("com.google.android.gms.maps.internal.CreatorImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    private static void zzdq(Context context) throws GooglePlayServicesNotAvailableException {
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context);
        switch (n) {
            case 0: {
                return;
            }
        }
        throw new GooglePlayServicesNotAvailableException(n);
    }

    private static zzc zzdr(Context context) {
        if (zzai.zzbse()) {
            Log.i((String)zzai.class.getSimpleName(), (String)"Making Creator statically");
            Class<?> clazz = zzai.zzbsf();
            return (zzc)zzai.zzf(clazz);
        }
        Log.i((String)zzai.class.getSimpleName(), (String)"Making Creator dynamically");
        IBinder iBinder = (IBinder)zzai.zza(zzai.getRemoteContext(context).getClassLoader(), "com.google.android.gms.maps.internal.CreatorImpl");
        return zzc.zza.zzhn(iBinder);
    }

    private static Context getRemoteContext(Context context) {
        if (amt == null) {
            amt = zzai.zzbse() ? context.getApplicationContext() : GooglePlayServicesUtil.getRemoteContext((Context)context);
        }
        return amt;
    }

    private static <T> T zza(ClassLoader classLoader, String string) {
        try {
            return zzai.zzf(((ClassLoader)zzac.zzy((Object)classLoader)).loadClass(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = String.valueOf(string);
            throw new IllegalStateException(string2.length() != 0 ? "Unable to find dynamic class ".concat(string2) : new String("Unable to find dynamic class "));
        }
    }

    private static <T> T zzf(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            String string = String.valueOf(clazz.getName());
            throw new IllegalStateException(string.length() != 0 ? "Unable to instantiate the dynamic class ".concat(string) : new String("Unable to instantiate the dynamic class "));
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = String.valueOf(clazz.getName());
            throw new IllegalStateException(string.length() != 0 ? "Unable to call the default constructor of ".concat(string) : new String("Unable to call the default constructor of "));
        }
    }
}

