/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.SignInAccount;
import com.google.android.gms.auth.api.signin.internal.SignInConfiguration;
import com.google.android.gms.auth.api.signin.internal.zzb;
import com.google.android.gms.auth.api.signin.internal.zzk;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;

@KeepName
public class SignInHubActivity
extends FragmentActivity {
    private zzk hC;
    private SignInConfiguration hD;
    private boolean hE;
    private int hF;
    private Intent hG;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.hC = zzk.zzbd((Context)this);
        Intent intent = this.getIntent();
        if (!"com.google.android.gms.auth.GOOGLE_SIGN_IN".equals(intent.getAction())) {
            String string = String.valueOf(intent.getAction());
            Log.e((String)"AuthSignInClient", (String)(string.length() != 0 ? "Unknown action: ".concat(string) : new String("Unknown action: ")));
            this.finish();
        }
        this.hD = (SignInConfiguration)intent.getParcelableExtra("config");
        if (this.hD == null) {
            Log.e((String)"AuthSignInClient", (String)"Activity started with invalid configuration.");
            this.setResult(0);
            this.finish();
            return;
        }
        if (bundle == null) {
            this.zzj(new Intent("com.google.android.gms.auth.GOOGLE_SIGN_IN"));
        } else {
            this.hE = bundle.getBoolean("signingInGoogleApiClients");
            if (this.hE) {
                this.hF = bundle.getInt("signInResultCode");
                this.hG = (Intent)bundle.getParcelable("signInResultData");
                this.zzaib();
            }
        }
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("signingInGoogleApiClients", this.hE);
        if (this.hE) {
            bundle.putInt("signInResultCode", this.hF);
            bundle.putParcelable("signInResultData", (Parcelable)this.hG);
        }
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        this.setResult(0);
        switch (n) {
            case 40962: {
                this.zza(n2, intent);
            }
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return true;
    }

    private void zza(int n, Intent intent) {
        if (intent != null) {
            SignInAccount signInAccount = (SignInAccount)intent.getParcelableExtra("signInAccount");
            if (signInAccount != null && signInAccount.zzahp() != null) {
                GoogleSignInAccount googleSignInAccount = signInAccount.zzahp();
                this.hC.zzb(googleSignInAccount, this.hD.zzaia());
                intent.removeExtra("signInAccount");
                intent.putExtra("googleSignInAccount", (Parcelable)googleSignInAccount);
                this.hE = true;
                this.hF = n;
                this.hG = intent;
                this.zzaib();
                return;
            }
            if (intent.hasExtra("errorCode")) {
                int n2 = intent.getIntExtra("errorCode", 8);
                this.zzdk(n2);
                return;
            }
        }
        this.zzdk(8);
    }

    private void zzj(Intent intent) {
        intent.setPackage("com.google.android.gms");
        intent.putExtra("config", (Parcelable)this.hD);
        try {
            this.startActivityForResult(intent, 40962);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.w((String)"AuthSignInClient", (String)"Could not launch sign in Intent. Google Play Service is probably being updated...");
            this.zzdk(8);
        }
    }

    private void zzaib() {
        this.getSupportLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)new zza());
    }

    private void zzdk(int n) {
        Status status = new Status(n);
        Intent intent = new Intent();
        intent.putExtra("googleSignInStatus", (Parcelable)status);
        this.setResult(0, intent);
        this.finish();
    }

    private class zza
    implements LoaderManager.LoaderCallbacks<Void> {
        private zza() {
        }

        public Loader<Void> onCreateLoader(int n, Bundle bundle) {
            return new zzb((Context)SignInHubActivity.this, GoogleApiClient.zzaqa());
        }

        public void zza(Loader<Void> loader, Void void_) {
            SignInHubActivity.this.setResult(SignInHubActivity.this.hF, SignInHubActivity.this.hG);
            SignInHubActivity.this.finish();
        }

        public void onLoaderReset(Loader<Void> loader) {
        }

        public /* synthetic */ void onLoadFinished(Loader loader, Object object) {
            this.zza((Loader<Void>)loader, (Void)object);
        }
    }
}

