/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.zzf;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public final class PasswordSpecification
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final zzf CREATOR = new zzf();
    public static final PasswordSpecification gt = new zza().zzj(12, 16).zzft("abcdefghijkmnopqrstxyzABCDEFGHJKLMNPQRSTXY3456789").zzf("abcdefghijkmnopqrstxyz", 1).zzf("ABCDEFGHJKLMNPQRSTXY", 1).zzf("3456789", 1).zzagz();
    public static final PasswordSpecification gu = new zza().zzj(12, 16).zzft("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890").zzf("abcdefghijklmnopqrstuvwxyz", 1).zzf("ABCDEFGHIJKLMNOPQRSTUVWXYZ", 1).zzf("1234567890", 1).zzagz();
    final int mVersionCode;
    final String gv;
    final List<String> gw;
    final List<Integer> gx;
    final int gy;
    final int gz;
    private final int[] gA;
    private final Random zzayg;

    PasswordSpecification(int n, String string, List<String> list, List<Integer> list2, int n2, int n3) {
        this.mVersionCode = n;
        this.gv = string;
        this.gw = Collections.unmodifiableList(list);
        this.gx = Collections.unmodifiableList(list2);
        this.gy = n2;
        this.gz = n3;
        this.gA = this.zzagy();
        this.zzayg = new SecureRandom();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzf.zza(this, parcel, n);
    }

    private int[] zzagy() {
        int[] nArray = new int[95];
        Arrays.fill(nArray, -1);
        int n = 0;
        for (String string : this.gw) {
            for (char c : string.toCharArray()) {
                nArray[this.zza((char)c)] = n;
            }
            ++n;
        }
        return nArray;
    }

    private int zza(char c) {
        return c - 32;
    }

    private static String zzb(Collection<Character> collection) {
        char[] cArray = new char[collection.size()];
        int n = 0;
        for (char c : collection) {
            cArray[n++] = c;
        }
        return new String(cArray);
    }

    private static boolean zzc(int n, int n2, int n3) {
        return n < n2 || n > n3;
    }

    public static class zzb
    extends Error {
        public zzb(String string) {
            super(string);
        }
    }

    public static class zza {
        private final TreeSet<Character> gB = new TreeSet();
        private final List<String> gw = new ArrayList<String>();
        private final List<Integer> gx = new ArrayList<Integer>();
        private int gy = 12;
        private int gz = 16;

        public zza zzft(@NonNull String string) {
            this.gB.addAll(this.zzw(string, "allowedChars"));
            return this;
        }

        public zza zzf(@NonNull String string, int n) {
            if (n < 1) {
                throw new zzb("count must be at least 1");
            }
            TreeSet<Character> treeSet = this.zzw(string, "requiredChars");
            this.gw.add(PasswordSpecification.zzb(treeSet));
            this.gx.add(n);
            return this;
        }

        public zza zzj(int n, int n2) {
            if (n < 1) {
                throw new zzb("minimumSize must be at least 1");
            }
            if (n > n2) {
                throw new zzb("maximumSize must be greater than or equal to minimumSize");
            }
            this.gy = n;
            this.gz = n2;
            return this;
        }

        public PasswordSpecification zzagz() {
            if (this.gB.isEmpty()) {
                throw new zzb("no allowed characters specified");
            }
            this.zzaha();
            this.zzahb();
            return new PasswordSpecification(1, PasswordSpecification.zzb(this.gB), this.gw, this.gx, this.gy, this.gz);
        }

        private TreeSet<Character> zzw(String string, String string2) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new zzb(String.valueOf(string2).concat(" cannot be null or empty"));
            }
            TreeSet<Character> treeSet = new TreeSet<Character>();
            for (char c : string.toCharArray()) {
                if (PasswordSpecification.zzc(c, 32, 126)) {
                    throw new zzb(String.valueOf(string2).concat(" must only contain ASCII printable characters"));
                }
                treeSet.add(Character.valueOf(c));
            }
            return treeSet;
        }

        private void zzaha() {
            int n = 0;
            for (int n2 : this.gx) {
                n += n2;
            }
            if (n > this.gz) {
                throw new zzb("required character count cannot be greater than the max password size");
            }
        }

        private void zzahb() {
            boolean[] blArray = new boolean[95];
            for (String string : this.gw) {
                for (char c : string.toCharArray()) {
                    if (blArray[c - 32]) {
                        throw new zzb(new StringBuilder(58).append("character ").append(c).append(" occurs in more than one required character set").toString());
                    }
                    blArray[c - 32] = true;
                }
            }
        }
    }
}

