/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.auth.api.credentials.CredentialPickerConfig;
import com.google.android.gms.auth.api.credentials.zzd;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzac;

public final class HintRequest
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<HintRequest> CREATOR = new zzd();
    final int mVersionCode;
    private final CredentialPickerConfig gp;
    private final boolean gq;
    private final boolean gr;
    private final String[] gm;

    HintRequest(int n, CredentialPickerConfig credentialPickerConfig, boolean bl, boolean bl2, String[] stringArray) {
        this.mVersionCode = n;
        this.gp = (CredentialPickerConfig)((Object)zzac.zzy((Object)((Object)credentialPickerConfig)));
        this.gq = bl;
        this.gr = bl2;
        this.gm = (String[])zzac.zzy((Object)stringArray);
    }

    private HintRequest(Builder builder) {
        this(1, builder.gp, builder.gq, builder.gr, builder.gm);
    }

    @NonNull
    public CredentialPickerConfig getHintPickerConfig() {
        return this.gp;
    }

    public boolean isEmailAddressIdentifierSupported() {
        return this.gq;
    }

    public boolean zzagx() {
        return this.gr;
    }

    @NonNull
    public String[] getAccountTypes() {
        return this.gm;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public static final class Builder {
        private boolean gq;
        private boolean gr;
        private String[] gm;
        private CredentialPickerConfig gp = new CredentialPickerConfig.Builder().build();

        public Builder setEmailAddressIdentifierSupported(boolean bl) {
            this.gq = bl;
            return this;
        }

        public Builder setPhoneNumberIdentifierSupported(boolean bl) {
            this.gr = bl;
            return this;
        }

        public Builder setAccountTypes(String ... stringArray) {
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            this.gm = stringArray;
            return this;
        }

        public Builder setHintPickerConfig(@NonNull CredentialPickerConfig credentialPickerConfig) {
            this.gp = (CredentialPickerConfig)((Object)zzac.zzy((Object)((Object)credentialPickerConfig)));
            return this;
        }

        public HintRequest build() {
            if (this.gm == null) {
                this.gm = new String[0];
            }
            if (!this.gq && !this.gr && this.gm.length == 0) {
                throw new IllegalStateException("At least one authentication method must be specified");
            }
            return new HintRequest(this);
        }
    }
}

