/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.auth.api.credentials.CredentialPickerConfig;
import com.google.android.gms.auth.api.credentials.zzc;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzac;

public final class CredentialRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<CredentialRequest> CREATOR = new zzc();
    final int mVersionCode;
    private final boolean gl;
    private final String[] gm;
    private final CredentialPickerConfig gn;
    private final CredentialPickerConfig go;

    CredentialRequest(int n, boolean bl, String[] stringArray, CredentialPickerConfig credentialPickerConfig, CredentialPickerConfig credentialPickerConfig2) {
        this.mVersionCode = n;
        this.gl = bl;
        this.gm = (String[])zzac.zzy((Object)stringArray);
        this.gn = credentialPickerConfig == null ? new CredentialPickerConfig.Builder().build() : credentialPickerConfig;
        this.go = credentialPickerConfig2 == null ? new CredentialPickerConfig.Builder().build() : credentialPickerConfig2;
    }

    private CredentialRequest(Builder builder) {
        this(2, builder.gl, builder.gm, builder.gn, builder.go);
    }

    @Deprecated
    public boolean getSupportsPasswordLogin() {
        return this.isPasswordLoginSupported();
    }

    public boolean isPasswordLoginSupported() {
        return this.gl;
    }

    @NonNull
    public String[] getAccountTypes() {
        return this.gm;
    }

    @NonNull
    public CredentialPickerConfig getCredentialPickerConfig() {
        return this.gn;
    }

    @NonNull
    public CredentialPickerConfig getCredentialHintPickerConfig() {
        return this.go;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    public static final class Builder {
        private boolean gl;
        private String[] gm;
        private CredentialPickerConfig gn;
        private CredentialPickerConfig go;

        @Deprecated
        public Builder setSupportsPasswordLogin(boolean bl) {
            return this.setPasswordLoginSupported(bl);
        }

        public Builder setPasswordLoginSupported(boolean bl) {
            this.gl = bl;
            return this;
        }

        public Builder setAccountTypes(String ... stringArray) {
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            this.gm = stringArray;
            return this;
        }

        public Builder setCredentialPickerConfig(CredentialPickerConfig credentialPickerConfig) {
            this.gn = credentialPickerConfig;
            return this;
        }

        public Builder setCredentialHintPickerConfig(CredentialPickerConfig credentialPickerConfig) {
            this.go = credentialPickerConfig;
            return this;
        }

        public CredentialRequest build() {
            if (this.gm == null) {
                this.gm = new String[0];
            }
            if (!this.gl && this.gm.length == 0) {
                throw new IllegalStateException("At least one authentication method must be specified");
            }
            return new CredentialRequest(this);
        }
    }
}

