/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.internal.zzb;
import com.google.android.gms.auth.api.credentials.zza;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import java.util.Collections;
import java.util.List;

public class Credential
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final String EXTRA_KEY = "com.google.android.gms.credentials.Credential";
    public static final Parcelable.Creator<Credential> CREATOR = new zza();
    final int mVersionCode;
    private final String zzbks;
    @Nullable
    private final String mName;
    @Nullable
    private final Uri gb;
    private final List<IdToken> gc;
    @Nullable
    private final String gd;
    @Nullable
    private final String ge;
    @Nullable
    private final String gf;
    @Nullable
    private final String gg;

    Credential(int n, String string, String string2, Uri uri, List<IdToken> list, String string3, String string4, String string5, String string6) {
        this.mVersionCode = n;
        String string7 = ((String)zzac.zzb((Object)string, (Object)"credential identifier cannot be null")).trim();
        zzac.zzh((String)string7, (Object)"credential identifier cannot be empty");
        this.zzbks = string7;
        if (string2 != null && TextUtils.isEmpty((CharSequence)string2.trim())) {
            string2 = null;
        }
        this.mName = string2;
        this.gb = uri;
        this.gc = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        this.gd = string3;
        if (string3 != null && string3.isEmpty()) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            zzb.zzfu(string4);
        }
        this.ge = string4;
        this.gf = string5;
        this.gg = string6;
        if (!TextUtils.isEmpty((CharSequence)this.gd) && !TextUtils.isEmpty((CharSequence)this.ge)) {
            throw new IllegalStateException("password and accountType cannot both be set");
        }
    }

    public String getId() {
        return this.zzbks;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public Uri getProfilePictureUri() {
        return this.gb;
    }

    public List<IdToken> getIdTokens() {
        return this.gc;
    }

    @Nullable
    public String getPassword() {
        return this.gd;
    }

    @Nullable
    public String getGeneratedPassword() {
        return this.gf;
    }

    @Nullable
    public String getAccountType() {
        return this.ge;
    }

    public String zzagv() {
        return this.gg;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Credential)) {
            return false;
        }
        Credential credential = (Credential)((Object)object);
        return TextUtils.equals((CharSequence)this.zzbks, (CharSequence)credential.zzbks) && TextUtils.equals((CharSequence)this.mName, (CharSequence)credential.mName) && zzab.equal((Object)this.gb, (Object)credential.gb) && TextUtils.equals((CharSequence)this.gd, (CharSequence)credential.gd) && TextUtils.equals((CharSequence)this.ge, (CharSequence)credential.ge) && TextUtils.equals((CharSequence)this.gf, (CharSequence)credential.gf);
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.zzbks, this.mName, this.gb, this.gd, this.ge, this.gf});
    }

    public static class Builder {
        private final String zzbks;
        private String mName;
        private Uri gb;
        private List<IdToken> gc;
        private String gd;
        private String ge;
        private String gf;
        private String gg;

        public Builder(String string) {
            this.zzbks = string;
        }

        public Builder(Credential credential) {
            this.zzbks = credential.zzbks;
            this.mName = credential.mName;
            this.gb = credential.gb;
            this.gc = credential.gc;
            this.gd = credential.gd;
            this.ge = credential.ge;
            this.gf = credential.gf;
            this.gg = credential.gg;
        }

        public Builder setName(String string) {
            this.mName = string;
            return this;
        }

        public Builder setProfilePictureUri(Uri uri) {
            this.gb = uri;
            return this;
        }

        public Builder setPassword(String string) {
            this.gd = string;
            return this;
        }

        public Builder setAccountType(String string) {
            this.ge = string;
            return this;
        }

        public Credential build() {
            return new Credential(3, this.zzbks, this.mName, this.gb, this.gc, this.gd, this.ge, this.gf, this.gg);
        }
    }
}

