/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.config.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.config.internal.AnalyticsUserProperty;
import com.google.android.gms.config.internal.CustomVariable;
import com.google.android.gms.config.internal.FetchConfigIpcRequest;
import com.google.android.gms.config.internal.FetchConfigIpcResponse;
import com.google.android.gms.config.internal.PackageConfigTable;
import com.google.android.gms.config.internal.zze;
import com.google.android.gms.config.internal.zzi;
import com.google.android.gms.config.internal.zzj;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzsj;
import com.google.android.gms.internal.zzsk;
import com.google.android.gms.internal.zzsl;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class zzc
implements zzsk {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern Fp = Pattern.compile("^(1|true|t|yes|y|on)$", 2);
    private static final Pattern Fq = Pattern.compile("^(0|false|f|no|n|off|)$", 2);

    @Override
    public PendingResult<zzsk.zzb> zza(GoogleApiClient googleApiClient, final zzsk.zza zza2) {
        if (googleApiClient == null || zza2 == null) {
            return null;
        }
        return googleApiClient.zzc((zzqc.zza)new zzc(googleApiClient){

            @Override
            protected void zza(Context context, zzj zzj2) throws RemoteException {
                String string;
                String string2;
                String string3;
                DataHolder dataHolder;
                block3: {
                    DataHolder.zza zza22 = com.google.android.gms.common.data.zzd.zzatd();
                    for (Map.Entry<String, String> object2 : zza2.zzayg().entrySet()) {
                        com.google.android.gms.common.data.zzd.zza((DataHolder.zza)zza22, (SafeParcelable)new CustomVariable(object2.getKey(), object2.getValue()));
                    }
                    dataHolder = zza22.zzgd(0);
                    string3 = zzqw.zzcb((Context)context) == Status.vY ? zzqw.zzasl() : null;
                    string2 = null;
                    string = null;
                    try {
                        string2 = com.google.firebase.iid.zzc.A().getId();
                        string = com.google.firebase.iid.zzc.A().getToken();
                    }
                    catch (IllegalStateException list) {
                        if (!Log.isLoggable((String)"ConfigApiImpl", (int)3)) break block3;
                        Log.d((String)"ConfigApiImpl", (String)"Cannot retrieve instanceId or instanceIdToken.", (Throwable)list);
                    }
                }
                List<AnalyticsUserProperty> list = com.google.android.gms.config.internal.zzb.zzct(context);
                FetchConfigIpcRequest fetchConfigIpcRequest = new FetchConfigIpcRequest(context.getPackageName(), zza2.zzayf(), dataHolder, string3, string2, string, null, zza2.zzayh(), list);
                zzj2.zza(this.Ft, fetchConfigIpcRequest);
                dataHolder.close();
            }

            protected zzsk.zzb zzaf(Status status) {
                return new zzd(status, new HashMap<String, TreeMap<String, byte[]>>());
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzaf(status);
            }
        });
    }

    private static Status zzho(int n) {
        return new Status(n, zzsl.getStatusCodeString(n));
    }

    private static HashMap<String, TreeMap<String, byte[]>> zza(FetchConfigIpcResponse fetchConfigIpcResponse) {
        if (fetchConfigIpcResponse == null) {
            return null;
        }
        DataHolder dataHolder = fetchConfigIpcResponse.zzayr();
        if (dataHolder == null) {
            return null;
        }
        com.google.android.gms.common.data.zzd zzd2 = new com.google.android.gms.common.data.zzd(dataHolder, (Parcelable.Creator)PackageConfigTable.CREATOR);
        PackageConfigTable packageConfigTable = (PackageConfigTable)((Object)zzd2.get(0));
        fetchConfigIpcResponse.zzays();
        HashMap<String, TreeMap<String, byte[]>> hashMap = new HashMap<String, TreeMap<String, byte[]>>();
        for (String string : packageConfigTable.zzayt().keySet()) {
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            hashMap.put(string, treeMap);
            Bundle bundle = packageConfigTable.zzayt().getBundle(string);
            for (String string2 : bundle.keySet()) {
                treeMap.put(string2, bundle.getByteArray(string2));
            }
        }
        return hashMap;
    }

    static abstract class zzc
    extends zzb<zzsk.zzb> {
        protected zzi Ft = new zza(){

            @Override
            public void zza(Status status, FetchConfigIpcResponse fetchConfigIpcResponse) {
                if (fetchConfigIpcResponse.getStatusCode() == 6502 || fetchConfigIpcResponse.getStatusCode() == 6507) {
                    zzc.this.zzc(new zzd(zzc.zzho(fetchConfigIpcResponse.getStatusCode()), zzc.zza(fetchConfigIpcResponse), fetchConfigIpcResponse.getThrottleEndTimeMillis()));
                } else {
                    zzc.this.zzc(new zzd(zzc.zzho(fetchConfigIpcResponse.getStatusCode()), zzc.zza(fetchConfigIpcResponse)));
                }
            }
        };

        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }
    }

    public static class zzd
    implements zzsk.zzb {
        private final Map<String, TreeMap<String, byte[]>> Fv;
        private final Status fp;
        private final long Fw;

        public zzd(Status status, Map<String, TreeMap<String, byte[]>> map) {
            this(status, map, -1L);
        }

        public zzd(Status status, Map<String, TreeMap<String, byte[]>> map, long l) {
            this.fp = status;
            this.Fv = map;
            this.Fw = l;
        }

        @Override
        public long getThrottleEndTimeMillis() {
            return this.Fw;
        }

        @Override
        public Status getStatus() {
            return this.fp;
        }

        @Override
        public byte[] zza(String string, byte[] byArray, String string2) {
            if (this.zzai(string, string2)) {
                return this.Fv.get(string2).get(string);
            }
            return byArray;
        }

        public boolean zzai(String string, String string2) {
            if (this.Fv == null || this.Fv.get(string2) == null) {
                return false;
            }
            return this.Fv.get(string2).get(string) != null;
        }

        @Override
        public Map<String, Set<String>> zzayj() {
            HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
            if (this.Fv != null) {
                for (String string : this.Fv.keySet()) {
                    Map map = this.Fv.get(string);
                    if (map == null) continue;
                    hashMap.put(string, map.keySet());
                }
            }
            return hashMap;
        }
    }

    static abstract class zzb<R extends Result>
    extends zzqc.zza<R, zze> {
        public zzb(GoogleApiClient googleApiClient) {
            super(zzsj.API, googleApiClient);
        }

        protected final void zza(zze zze2) throws RemoteException {
            this.zza(zze2.getContext(), (zzj)zze2.zzatx());
        }

        protected abstract void zza(Context var1, zzj var2) throws RemoteException;
    }

    static abstract class zza
    extends zzi.zza {
        zza() {
        }

        @Override
        public void zza(Status status, byte[] byArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zza(Status status, Map map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zzag(Status status) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zza(Status status, FetchConfigIpcResponse fetchConfigIpcResponse) {
            throw new UnsupportedOperationException();
        }
    }
}

