/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.stats.zzb;
import com.google.android.gms.internal.zzxs;
import com.google.android.gms.internal.zzxt;
import com.google.android.gms.internal.zzxv;
import com.google.android.gms.tagmanager.TagManagerService;

public class zzyn
implements ServiceConnection {
    private final Context mContext;
    private final zzb CC;
    private volatile boolean aHn = false;
    private volatile boolean aHo = false;
    private zzxt aHp;

    public zzyn(Context context) {
        this(context, zzb.zzawu());
    }

    zzyn(Context context, zzb zzb2) {
        this.mContext = context;
        this.CC = zzb2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public boolean zzciu() {
        if (this.aHn) {
            return true;
        }
        zzyn zzyn2 = this;
        synchronized (zzyn2) {
            if (this.aHn) {
                return true;
            }
            if (!this.aHo) {
                Intent intent = new Intent(this.mContext, TagManagerService.class);
                if (!this.CC.zza(this.mContext, intent, (ServiceConnection)this, 1)) {
                    return false;
                }
                this.aHo = true;
            }
            while (this.aHo) {
                try {
                    this.wait();
                    this.aHo = false;
                }
                catch (InterruptedException interruptedException) {
                    zzxv.zzd("Error connecting to TagManagerService", interruptedException);
                    this.aHo = false;
                }
            }
            return this.aHn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzyn zzyn2 = this;
        synchronized (zzyn2) {
            this.aHp = zzxt.zza.zzli((IBinder)iBinder);
            this.aHn = true;
            this.aHo = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public void onServiceDisconnected(ComponentName componentName) {
        zzyn zzyn2 = this;
        synchronized (zzyn2) {
            this.aHp = null;
            this.aHn = false;
            this.aHo = false;
        }
    }

    @WorkerThread
    public void zzb(String string2, @Nullable String string3, @Nullable String string4, @Nullable zzxs zzxs2) {
        if (this.zzciu()) {
            try {
                this.aHp.zza(string2, string3, string4, zzxs2);
            }
            catch (RemoteException remoteException) {
                zzxv.zzd("Error calling service to load container", remoteException);
                this.zza(zzxs2, string2);
            }
        } else {
            this.zza(zzxs2, string2);
        }
    }

    @WorkerThread
    public boolean zzciv() {
        if (this.zzciu()) {
            try {
                this.aHp.zzchv();
                return true;
            }
            catch (RemoteException remoteException) {
                zzxv.zzd("Error in resetting service", remoteException);
            }
        }
        return false;
    }

    @WorkerThread
    private void zza(@Nullable zzxs zzxs2, String string2) {
        if (zzxs2 != null) {
            try {
                zzxs2.zza(false, string2);
            }
            catch (RemoteException remoteException) {
                zzxv.zzb("Error - local callback should not throw RemoteException", remoteException);
            }
        }
    }

    @WorkerThread
    public void zza(String string2, Bundle bundle, String string3, long l, boolean bl) {
        if (this.zzciu()) {
            try {
                this.aHp.zza(string2, bundle, string3, l, bl);
            }
            catch (RemoteException remoteException) {
                zzxv.zzd("Error calling service to emit event", remoteException);
            }
        }
    }

    @WorkerThread
    public void dispatch() {
        if (this.zzciu()) {
            try {
                this.aHp.dispatch();
            }
            catch (RemoteException remoteException) {
                zzxv.zzd("Error calling service to dispatch pending events", remoteException);
            }
        }
    }
}

