/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Service;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Pair;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzxs;
import com.google.android.gms.internal.zzxv;
import com.google.android.gms.internal.zzya;
import com.google.android.gms.internal.zzym;
import com.google.android.gms.internal.zzyn;
import com.google.android.gms.tagmanager.TagManagerService;
import com.google.android.gms.tagmanager.zzay;
import com.google.android.gms.tagmanager.zzaz;
import com.google.android.gms.tagmanager.zzba;
import com.google.android.gms.tagmanager.zzbb;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class zzyk {
    private static final Pattern aGG = Pattern.compile("(gtm-[a-z0-9]{1,10})\\.json", 2);
    private static volatile zzyk aGH;
    private final Context mContext;
    private final zzbb aFp;
    private final zzay aFy;
    private final zzyn aGI;
    private final ExecutorService aFn;
    private final ScheduledExecutorService aFo;
    private final zzya aGJ;
    private final zza aGK;
    private final Object aGL = new Object();
    private String aAO;
    private String aGM;
    private int aGN = 1;
    private final Queue<Runnable> aGO = new LinkedList<Runnable>();
    private volatile boolean zzaom = false;
    private volatile boolean aGP = false;
    private static zzc aGQ;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzyk zza(Context context, zzbb zzbb2, zzay zzay2) {
        zzac.zzy((Object)context);
        zzac.zzy((Object)context);
        zzyk zzyk2 = aGH;
        if (zzyk2 != null) return zzyk2;
        Class<zzyk> clazz = zzyk.class;
        synchronized (zzyk.class) {
            zzyk2 = aGH;
            if (zzyk2 != null) return zzyk2;
            aGH = zzyk2 = aGQ.zzb(context, zzbb2, zzay2);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return zzyk2;
        }
    }

    zzyk(Context context, zzbb zzbb2, zzay zzay2, zzyn zzyn2, ExecutorService executorService, ScheduledExecutorService scheduledExecutorService, zzya zzya2, zza zza2) {
        zzac.zzy((Object)context);
        zzac.zzy((Object)zzbb2);
        this.mContext = context;
        this.aFp = zzbb2;
        this.aFy = zzay2;
        this.aGI = zzyn2;
        this.aFn = executorService;
        this.aFo = scheduledExecutorService;
        this.aGJ = zzya2;
        this.aGK = zza2;
    }

    @WorkerThread
    public void initialize() {
        this.zzi(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zzi(String[] stringArray) {
        zzxv.v("Initializing Tag Manager.");
        long l = System.currentTimeMillis();
        Object object = this.aGL;
        synchronized (object) {
            if (this.zzaom) {
                return;
            }
            try {
                if (!zzyk.zzb(this.mContext, TagManagerService.class)) {
                    zzxv.zzdf("Tag Manager fails to initialize (TagManagerService not enabled in the manifest)");
                    return;
                }
                Pair<String, String> pair = this.zzj(stringArray);
                String string2 = (String)pair.first;
                String string3 = (String)pair.second;
                if (string2 != null && string3 != null) {
                    String string4 = String.valueOf(string2);
                    zzxv.zzde(string4.length() != 0 ? "Loading container ".concat(string4) : new String("Loading container "));
                    this.zzbi(string2, string3);
                    if (!this.aGP) {
                        zzxv.zzde("Installing Tag Manager event handler.");
                        this.aGP = true;
                        this.zzcio();
                        this.zzcgy();
                        zzxv.zzde("Tag Manager event handler installed.");
                    }
                } else {
                    zzxv.zzdf("Tag Manager's event handler WILL NOT be installed (no container loaded)");
                }
            }
            finally {
                this.zzaom = true;
            }
        }
        long l2 = System.currentTimeMillis() - l;
        zzxv.zzde(new StringBuilder(53).append("Tag Manager initilization took ").append(l2).append("ms").toString());
    }

    private Pair<String, String> zzj(String[] stringArray) {
        Object object;
        String[] stringArray2;
        zzxv.v("Looking up container asset.");
        if (this.aAO != null && this.aGM != null) {
            return Pair.create((Object)this.aAO, (Object)this.aGM);
        }
        try {
            stringArray2 = stringArray != null ? stringArray : this.zzcin().zzqp("containers");
        }
        catch (IOException iOException) {
            zzxv.zzb(String.format("Failed to enumerate assets in folder %s", "containers"), iOException);
            return Pair.create(null, null);
        }
        boolean bl = false;
        for (int i = 0; i < stringArray2.length; ++i) {
            Matcher matcher = aGG.matcher(stringArray2[i]);
            if (matcher.matches()) {
                if (!bl) {
                    this.aAO = matcher.group(1);
                    object = String.valueOf("containers");
                    String string2 = String.valueOf(File.separator);
                    String string3 = String.valueOf(stringArray2[i]);
                    this.aGM = new StringBuilder(0 + String.valueOf(object).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append((String)object).append(string2).append(string3).toString();
                    bl = true;
                    String string4 = String.valueOf(this.aAO);
                    zzxv.v(string4.length() != 0 ? "Asset found for container ".concat(string4) : new String("Asset found for container "));
                    continue;
                }
                String string5 = String.valueOf(stringArray2[i]);
                zzxv.zzdf(string5.length() != 0 ? "Extra container asset found, will not be loaded: ".concat(string5) : new String("Extra container asset found, will not be loaded: "));
                continue;
            }
            zzxv.zzdf(String.format("Ignoring container asset %s (does not match %s)", stringArray2[i], aGG.pattern()));
        }
        if (!bl) {
            String[] stringArray3;
            zzxv.zzdf("No container asset found in /assets/containers. Checking top level /assets directory for container assets.");
            try {
                stringArray3 = this.zzcin().zzcip();
            }
            catch (IOException iOException) {
                zzxv.zzb("Failed to enumerate assets.", iOException);
                return Pair.create(null, null);
            }
            for (int i = 0; i < stringArray3.length; ++i) {
                object = aGG.matcher(stringArray3[i]);
                if (!((Matcher)object).matches()) continue;
                if (!bl) {
                    this.aAO = ((Matcher)object).group(1);
                    this.aGM = stringArray3[i];
                    String string6 = String.valueOf(this.aAO);
                    zzxv.v(string6.length() != 0 ? "Asset found for container ".concat(string6) : new String("Asset found for container "));
                    zzxv.zzdf("Loading container assets from top level /assets directory. Please move the container asset to /assets/containers");
                    bl = true;
                    continue;
                }
                String string7 = String.valueOf(stringArray3[i]);
                zzxv.zzdf(string7.length() != 0 ? "Extra container asset found, will not be loaded: ".concat(string7) : new String("Extra container asset found, will not be loaded: "));
            }
        }
        return Pair.create((Object)this.aAO, (Object)this.aGM);
    }

    private zza zzcin() {
        return this.aGK;
    }

    private static boolean zzb(Context context, Class<? extends Service> clazz) {
        try {
            ServiceInfo serviceInfo = context.getPackageManager().getServiceInfo(new ComponentName(context, clazz), 4);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    @WorkerThread
    private void zzcio() {
        try {
            this.aFp.zza((zzba)new zzba.zza(){

                public void zzb(final String string2, final String string3, final Bundle bundle, final long l) throws RemoteException {
                    final String string4 = new StringBuilder(4 + String.valueOf(string2).length()).append(string2).append("+").append("gtm").toString();
                    zzyk.this.aFn.submit(new Runnable(){
                        private boolean aGS = false;

                        @Override
                        public void run() {
                            if (zzyk.this.aGN == 3) {
                                zzyk.this.aGI.zza(string3, bundle, string4, l, true);
                            } else if (zzyk.this.aGN == 4) {
                                zzxv.v(String.format("Container failed to load: skipping  event interceptor by logging event back to Firebase directly: name = %s, origin = %s, params = %s.", string3, string4, bundle));
                                try {
                                    zzyk.this.aFp.zza(string4, string3, bundle, l);
                                }
                                catch (RemoteException remoteException) {
                                    String string22 = String.valueOf(remoteException.getMessage());
                                    zzxv.e(string22.length() != 0 ? "Error logging event on measurement proxy".concat(string22) : new String("Error logging event on measurement proxy"));
                                }
                            } else if (zzyk.this.aGN == 1 || zzyk.this.aGN == 2) {
                                if (!this.aGS) {
                                    zzxv.v(String.format("Container not loaded yet: deferring event interceptor by enqueuing the event: name = %s, origin = %s, params = %s.", string3, string2, bundle));
                                    this.aGS = true;
                                    zzyk.this.aGO.add(this);
                                } else {
                                    zzxv.zzdf("Invalid state - not expecting to see a deferred eventduring container loading.");
                                }
                            } else {
                                int n = zzyk.this.aGN;
                                zzxv.zzdf(new StringBuilder(28).append("Unexpected state:").append(n).toString());
                            }
                        }
                    });
                }
            });
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(remoteException.getMessage());
            zzxv.e(string2.length() != 0 ? "Error communicating with measurement proxy:".concat(string2) : new String("Error communicating with measurement proxy:"));
        }
        try {
            this.aFp.zza((zzaz)new zzaz.zza(){

                public void zzc(final String string2, final String string3, final Bundle bundle, final long l) {
                    if (!string2.endsWith("+gtm")) {
                        final String string4 = new StringBuilder(4 + String.valueOf(string2).length()).append(string2).append("+").append("gtm").toString();
                        zzyk.this.aFn.submit(new Runnable(){
                            private boolean aGS = false;

                            @Override
                            public void run() {
                                if (zzyk.this.aGN == 3) {
                                    zzyk.this.aGI.zza(string3, bundle, string4, l, false);
                                } else if (zzyk.this.aGN == 1 || zzyk.this.aGN == 2) {
                                    if (!this.aGS) {
                                        zzxv.v(String.format("Container not loaded yet: deferring event listener by enqueuing the event: name = %s, origin = %s, params = %s.", string3, string2, bundle));
                                        this.aGS = true;
                                        zzyk.this.aGO.add(this);
                                    } else {
                                        zzxv.zzdf("Invalid state - not expecting to see a deferred event during container loading.");
                                    }
                                } else if (zzyk.this.aGN == 4) {
                                    zzxv.v(String.format("Container failed to load: skipping event listener by ignoring the event: name = %s, origin = %s, params = %s.", string3, string2, bundle));
                                } else {
                                    int n = zzyk.this.aGN;
                                    zzxv.zzdf(new StringBuilder(28).append("Unexpected state:").append(n).toString());
                                }
                            }
                        });
                    }
                }
            });
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(remoteException.getMessage());
            zzxv.e(string3.length() != 0 ? "Error communicating with measurement proxy:".concat(string3) : new String("Error communicating with measurement proxy:"));
        }
    }

    @WorkerThread
    public void zzbi(String string2, @Nullable String string3) {
        this.zzn(string2, string3, null);
    }

    @WorkerThread
    public void zzn(final String string2, final @Nullable String string3, final @Nullable String string4) {
        this.aFn.submit(new Runnable(){

            @Override
            public void run() {
                String string22 = string2;
                zzxv.v(new StringBuilder(28 + String.valueOf(string22).length()).append("Starting to load container ").append(string22).append(".").toString());
                if (zzyk.this.aGN != 1) {
                    zzxv.zzdf("Unexpected state - container loading already initiated.");
                    return;
                }
                zzyk.this.aGN = 2;
                zzyk.this.aGI.zzb(string2, string3, string4, (zzxs)new zzb());
            }
        });
        this.aFo.schedule(new Runnable(){

            @Override
            public void run() {
                zzyk.this.aFn.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (zzyk.this.aGN == 1 || zzyk.this.aGN == 2) {
                            zzyk.this.aGN = 4;
                            zzxv.e("Container load timed out after 5000ms.");
                            while (!zzyk.this.aGO.isEmpty()) {
                                zzyk.this.aFn.submit((Runnable)zzyk.this.aGO.remove());
                            }
                        }
                    }
                });
            }
        }, 5000L, TimeUnit.MILLISECONDS);
    }

    @TargetApi(value=14)
    private void zzcgy() {
        if (Build.VERSION.SDK_INT >= 14) {
            this.mContext.registerComponentCallbacks((ComponentCallbacks)new ComponentCallbacks2(){

                public void onTrimMemory(int n) {
                    if (n == 20) {
                        zzyk.this.aFn.submit(new Runnable(){

                            @Override
                            public void run() {
                                zzxv.v("App's UI deactivated. Dispatching hits.");
                                zzyk.this.aGI.dispatch();
                            }
                        });
                    }
                }

                public void onConfigurationChanged(Configuration configuration) {
                }

                public void onLowMemory() {
                }
            });
        }
    }

    void zzw(final Uri uri) {
        this.aFn.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = String.valueOf(uri);
                zzxv.v(new StringBuilder(25 + String.valueOf(object).length()).append("Preview requested to uri ").append((String)object).toString());
                object = zzyk.this.aGL;
                synchronized (object) {
                    if (zzyk.this.aGN == 2) {
                        zzxv.v("Still initializing. Defer preview container loading.");
                        zzyk.this.aGO.add(this);
                        return;
                    }
                    String string2 = (String)((zzyk)zzyk.this).zzj(null).first;
                    if (string2 == null) {
                        zzxv.zzdf("Preview failed (no container found)");
                        return;
                    }
                    if (!zzyk.this.aGJ.zzc(string2, uri)) {
                        String string3 = String.valueOf(uri);
                        zzxv.zzdf(new StringBuilder(73 + String.valueOf(string3).length()).append("Cannot preview the app with the uri: ").append(string3).append(". Launching current version instead.").toString());
                        return;
                    }
                    if (!zzyk.this.zzaom) {
                        String string4 = String.valueOf(uri);
                        zzxv.v(new StringBuilder(84 + String.valueOf(string4).length()).append("Deferring container loading for preview uri: ").append(string4).append("(Tag Manager has not been initialized).").toString());
                        return;
                    }
                    String string5 = String.valueOf(uri);
                    zzxv.zzde(new StringBuilder(36 + String.valueOf(string5).length()).append("Starting to load preview container: ").append(string5).toString());
                    if (!zzyk.this.aGI.zzciv()) {
                        zzxv.zzdf("Failed to reset TagManager service for preview");
                        return;
                    }
                    zzyk.this.zzaom = false;
                    zzyk.this.aGN = 1;
                }
                zzyk.this.initialize();
            }
        });
    }

    static {
        aGQ = new zzc(){

            @Override
            public zzyk zzb(Context context, zzbb zzbb2, zzay zzay2) {
                return new zzyk(context, zzbb2, zzay2, new zzyn(context), zzym.zzciq(), zzym.zzcir(), zzya.zzcia(), new zza(context));
            }
        };
    }

    protected static class zza {
        private final Context mContext;

        public zza(Context context) {
            this.mContext = context;
        }

        public String[] zzqp(String string2) throws IOException {
            return this.mContext.getAssets().list(string2);
        }

        public String[] zzcip() throws IOException {
            return this.mContext.getAssets().list("");
        }
    }

    private class zzb
    extends zzxs.zza {
        private zzb() {
        }

        public void zza(final boolean bl, final String string2) throws RemoteException {
            zzyk.this.aFn.submit(new Runnable(){

                @Override
                public void run() {
                    if (zzyk.this.aGN == 2) {
                        if (bl) {
                            zzyk.this.aGN = 3;
                            String string22 = string2;
                            zzxv.v(new StringBuilder(18 + String.valueOf(string22).length()).append("Container ").append(string22).append(" loaded.").toString());
                        } else {
                            zzyk.this.aGN = 4;
                            String string3 = String.valueOf(string2);
                            zzxv.e(string3.length() != 0 ? "Error loading container:".concat(string3) : new String("Error loading container:"));
                        }
                        while (!zzyk.this.aGO.isEmpty()) {
                            zzyk.this.aFn.submit((Runnable)zzyk.this.aGO.remove());
                        }
                    } else {
                        zzxv.zzdf("Container load callback completed after timeout");
                    }
                }
            });
        }
    }

    public static interface zzc {
        public zzyk zzb(Context var1, zzbb var2, zzay var3);
    }
}

