/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.internal.zzxj;
import com.google.android.gms.internal.zzxm;
import com.google.android.gms.internal.zzxv;
import com.google.android.gms.internal.zzxx;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class zzyj
implements zzxj {
    private final String zzbnw;
    private final Context mContext;
    private final zzb aGE;
    private final zza aGF;

    zzyj(zzb zzb2, Context context, zza zza2) {
        this.aGE = zzb2;
        this.mContext = context.getApplicationContext();
        this.aGF = zza2;
        this.zzbnw = this.zza("GoogleTagManager", "5.01", Build.VERSION.RELEASE, zzyj.zzc(Locale.getDefault()), Build.MODEL, Build.ID);
    }

    zzyj(Context context, zza zza2) {
        this(new zzb(){

            @Override
            public HttpURLConnection zzd(URL uRL) throws IOException {
                return (HttpURLConnection)uRL.openConnection();
            }
        }, context, zza2);
    }

    @Override
    public boolean zzcex() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            zzxv.v("...no network connectivity");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void zzal(List<zzxm> list) {
        int n = Math.min(list.size(), 40);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            Object object;
            zzxm zzxm2 = list.get(i);
            URL uRL = this.zzd(zzxm2);
            String string2 = zzxm2.zzchs();
            Map<String, String> map = zzxm2.zzcht();
            String string3 = zzxm2.zzchu();
            if (uRL == null) {
                zzxv.zzdf("No destination: discarding hit.");
                this.aGF.zzb(zzxm2);
                continue;
            }
            HttpURLConnection httpURLConnection = null;
            InputStream inputStream = null;
            try {
                block26: {
                    block25: {
                        httpURLConnection = this.aGE.zzd(uRL);
                        if (bl) {
                            zzxx.zzej(this.mContext);
                            bl = false;
                        }
                        httpURLConnection.setRequestProperty("User-Agent", this.zzbnw);
                        if (map != null) {
                            for (Map.Entry<String, String> entry : map.entrySet()) {
                                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
                            }
                        }
                        if (string2 != null) break block25;
                        zzxv.zzdf(String.format("Hit %d retrieved from the store has null HTTP method.", zzxm2.zzcfh()));
                        this.aGF.zzb(zzxm2);
                        httpURLConnection.disconnect();
                        continue;
                    }
                    if (string2.equals("GET") || string2.equals("HEAD") || string2.equals("POST") || string2.equals("PUT")) break block26;
                    zzxv.zzdf(String.format("Unrecongnized HTTP method %s. Supported methods are GET, HEAD, PUT and/or POST", string2));
                    this.aGF.zzb(zzxm2);
                    httpURLConnection.disconnect();
                    continue;
                }
                try {
                    void var13_22;
                    String string4 = string2;
                    int n2 = -1;
                    switch (string4.hashCode()) {
                        case 70454: {
                            if (!string4.equals("GET")) break;
                            boolean bl2 = false;
                            break;
                        }
                        case 2213344: {
                            if (!string4.equals("HEAD")) break;
                            boolean bl3 = true;
                            break;
                        }
                        case 2461856: {
                            if (!string4.equals("POST")) break;
                            int n3 = 2;
                            break;
                        }
                        case 79599: {
                            if (!string4.equals("PUT")) break;
                            int n4 = 3;
                        }
                    }
                    switch (var13_22) {
                        case 0: 
                        case 1: {
                            if (string3 != null) {
                                zzxv.zzdf(String.format("Body of %s hit is ignored: %s.", string2, string3));
                            }
                            httpURLConnection.setRequestMethod(string2);
                            break;
                        }
                        case 2: 
                        case 3: {
                            httpURLConnection.setRequestMethod(string2);
                            if (string3 == null) break;
                            httpURLConnection.setDoOutput(true);
                            object = string3.getBytes(Charset.forName("UTF-8"));
                            httpURLConnection.setFixedLengthStreamingMode(((Object)object).length);
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
                            bufferedOutputStream.write((byte[])object);
                            bufferedOutputStream.flush();
                            bufferedOutputStream.close();
                        }
                    }
                    int n22 = httpURLConnection.getResponseCode();
                    inputStream = httpURLConnection.getInputStream();
                    if (n22 != 200) {
                        String string5 = String.valueOf(uRL);
                        zzxv.zzdf(new StringBuilder(39 + String.valueOf(string5).length()).append("Bad response received for ").append(string5).append(": ").append(n22).toString());
                        this.aGF.zzc(zzxm2);
                        continue;
                    }
                    String string6 = String.valueOf(uRL);
                    zzxv.v(new StringBuilder(23 + String.valueOf(string6).length() + String.valueOf(string2).length()).append("Hit sent to ").append(string6).append("(method = ").append(string2).append(")").toString());
                    this.aGF.zza(zzxm2);
                    continue;
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    httpURLConnection.disconnect();
                }
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(uRL);
                object = String.valueOf(iOException.getClass().getSimpleName());
                zzxv.zzdf(new StringBuilder(27 + String.valueOf(string7).length() + String.valueOf(object).length()).append("Exception sending hit to ").append(string7).append(": ").append((String)object).toString());
                zzxv.zzdf(iOException.getMessage());
                this.aGF.zzc(zzxm2);
            }
        }
    }

    String zza(String string2, String string3, String string4, String string5, String string6, String string7) {
        return String.format("%s/%s (Linux; U; Android %s; %s; %s Build/%s)", string2, string3, string4, string5, string6, string7);
    }

    static String zzc(Locale locale) {
        if (locale == null) {
            return null;
        }
        if (locale.getLanguage() == null || locale.getLanguage().length() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(locale.getLanguage().toLowerCase());
        if (locale.getCountry() != null && locale.getCountry().length() != 0) {
            stringBuilder.append("-").append(locale.getCountry().toLowerCase());
        }
        return stringBuilder.toString();
    }

    URL zzd(zzxm zzxm2) {
        String string2 = zzxm2.zzcfj();
        try {
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            zzxv.e("Error trying to parse the GTM url.");
            return null;
        }
    }

    static interface zzb {
        public HttpURLConnection zzd(URL var1) throws IOException;
    }

    public static interface zza {
        public void zza(zzxm var1);

        public void zzb(zzxm var1);

        public void zzc(zzxm var1);
    }
}

