/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzxj;
import com.google.android.gms.internal.zzxl;
import com.google.android.gms.internal.zzxm;
import com.google.android.gms.internal.zzxq;
import com.google.android.gms.internal.zzxr;
import com.google.android.gms.internal.zzxv;
import com.google.android.gms.internal.zzya;
import com.google.android.gms.internal.zzyh;
import com.google.android.gms.internal.zzyj;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class zzxy
implements zzxq {
    private static final String aFX = String.format("CREATE TABLE IF NOT EXISTS %s ('%s' TEXT UNIQUE);", "gtm_hit_unique_ids", "hit_unique_id");
    private static final String bo = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' TEXT UNIQUE, '%s' TEXT, '%s' TEXT);", "gtm_hits", "hit_id", "hit_time", "hit_url", "hit_first_send_time", "hit_method", "hit_unique_id", "hit_headers", "hit_body");
    private static final String aFY = String.format("CREATE TRIGGER IF NOT EXISTS %s DELETE ON %s FOR EACH ROW WHEN OLD.%s NOTNULL BEGIN     INSERT OR IGNORE INTO %s (%s) VALUES (OLD.%s); END;", "save_unique_on_delete", "gtm_hits", "hit_unique_id", "gtm_hit_unique_ids", "hit_unique_id", "hit_unique_id");
    private static final String aFZ = String.format("CREATE TRIGGER IF NOT EXISTS %s BEFORE INSERT ON %s FOR EACH ROW WHEN NEW.%s NOT NULL BEGIN     SELECT RAISE(ABORT, 'Duplicate unique ID.')     WHERE EXISTS (SELECT 1 FROM %s WHERE %s = NEW.%s); END;", "check_unique_on_insert", "gtm_hits", "hit_unique_id", "gtm_hit_unique_ids", "hit_unique_id", "hit_unique_id");
    private final zzb aGa;
    private volatile zzxj aGb;
    private final zzxr aGc;
    private final Context mContext;
    private final String aCS;
    private long aCT;
    private zze zzapy;
    private final int aCU;

    zzxy(zzxr zzxr2, Context context) {
        this(zzxr2, context, "gtm_urls.db", 2000);
    }

    zzxy(zzxr zzxr2, Context context, String string2, int n) {
        this.mContext = context.getApplicationContext();
        this.aCS = string2;
        this.aGc = zzxr2;
        this.zzapy = zzh.zzaxj();
        this.aGa = new zzb(this.mContext, this.aCS);
        this.aGb = new zzyj(this.mContext, new zza());
        this.aCT = 0L;
        this.aCU = n;
    }

    @Override
    public void zza(long l, String string2, @Nullable String string3, @Nullable String string4, @Nullable Map<String, String> map, @Nullable String string5) {
        this.zzabp();
        this.zzcfu();
        this.zzb(l, string2, string3, string4, map, string5);
        if (zzya.zzcia().isPreview()) {
            zzxv.v("Sending hits immediately under preview.");
            this.dispatch();
        }
    }

    private void zzcfu() {
        int n = this.zzcfv() - this.aCU + 1;
        if (n > 0) {
            List<String> list = this.zzaaq(n);
            int n2 = list.size();
            zzxv.v(new StringBuilder(51).append("Store full, deleting ").append(n2).append(" hits to make room.").toString());
            this.zzh(list.toArray(new String[0]));
        }
    }

    private void zzb(long l, String string2, @Nullable String string3, @Nullable String string4, @Nullable Map<String, String> map, @Nullable String string5) {
        SQLiteDatabase sQLiteDatabase = this.zzpg("Error opening database for putHit");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_time", Long.valueOf(l));
        contentValues.put("hit_url", string2);
        contentValues.put("hit_first_send_time", Integer.valueOf(0));
        contentValues.put("hit_method", string3 == null ? "GET" : string3);
        contentValues.put("hit_unique_id", string4);
        contentValues.put("hit_headers", map == null ? null : new JSONObject(map).toString());
        contentValues.put("hit_body", string5);
        try {
            sQLiteDatabase.insertOrThrow("gtm_hits", null, contentValues);
            zzxv.v(new StringBuilder(19 + String.valueOf(string2).length()).append("Hit stored (url = ").append(string2).append(")").toString());
            this.aGc.zzcl(false);
        }
        catch (SQLiteConstraintException sQLiteConstraintException) {
            String string6 = String.valueOf(string2);
            zzxv.v(string6.length() != 0 ? "Hit has already been sent: ".concat(string6) : new String("Hit has already been sent: "));
        }
        catch (SQLiteException sQLiteException) {
            String string7 = String.valueOf((Object)sQLiteException);
            zzxv.zzdf(new StringBuilder(18 + String.valueOf(string7).length()).append("Error storing hit ").append(string7).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> zzaaq(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n <= 0) {
            zzxv.zzdf("Invalid maxHits specified. Skipping");
            return arrayList;
        }
        SQLiteDatabase sQLiteDatabase = this.zzpg("Error opening database for peekHitIds.");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<zzxm> zzaar(int n) {
        ArrayList<zzxm> arrayList = new ArrayList<zzxm>();
        SQLiteDatabase sQLiteDatabase = this.zzpg("Error opening database for peekHits");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_time", "hit_first_send_time"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n));
            arrayList = new ArrayList();
            if (cursor.moveToFirst()) {
                do {
                    zzxm zzxm2 = new zzxm(cursor.getLong(0), cursor.getLong(1), cursor.getLong(2));
                    arrayList.add(zzxm2);
                } while (cursor.moveToNext());
            }
        }
        int n2 = 0;
        try {
            CursorWindow cursorWindow;
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_url", "hit_method", "hit_headers", "hit_body"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n));
            if (cursor.moveToFirst()) {
                do {
                    if ((cursorWindow = ((SQLiteCursor)cursor).getWindow()).getNumRows() > 0) {
                        HashMap<String, String> hashMap;
                        block25: {
                            ((zzxm)arrayList.get(n2)).zzpk(cursor.getString(1));
                            ((zzxm)arrayList.get(n2)).zzqg(cursor.getString(2));
                            ((zzxm)arrayList.get(n2)).zzqh(cursor.getString(4));
                            hashMap = null;
                            try {
                                String string2 = cursor.getString(3);
                                if (string2 == null) break block25;
                                JSONObject jSONObject = new JSONObject(string2);
                                JSONArray jSONArray = jSONObject.names();
                                hashMap = new HashMap<String, String>();
                                for (int i = 0; i < jSONArray.length(); ++i) {
                                    String string3 = jSONArray.getString(i);
                                    hashMap.put(string3, (String)jSONObject.opt(string3));
                                }
                            }
                            catch (JSONException jSONException) {
                                zzxv.zzdf(String.format("Failed to read headers for hitId %d: %s", ((zzxm)arrayList.get(n2)).zzcfh(), jSONException.getMessage()));
                                continue;
                            }
                        }
                        ((zzxm)arrayList.get(n2)).zzbk(hashMap);
                    } else {
                        zzxv.zzdf(String.format("HitString for hitId %d too large.  Hit will be deleted.", ((zzxm)arrayList.get(n2)).zzcfh()));
                    }
                    ++n2;
                } while (cursor.moveToNext());
            }
            cursorWindow = arrayList;
            return cursorWindow;
        }
        catch (SQLiteException sQLiteException) {
            String string4 = String.valueOf(sQLiteException.getMessage());
            zzxv.zzdf(string4.length() != 0 ? "Error in peekHits fetching hit url: ".concat(string4) : new String("Error in peekHits fetching hit url: "));
            ArrayList<zzxm> arrayList2 = new ArrayList<zzxm>();
            boolean bl = false;
            for (zzxm zzxm3 : arrayList) {
                if (TextUtils.isEmpty((CharSequence)zzxm3.zzcfj())) {
                    if (bl) break;
                    bl = true;
                }
                arrayList2.add(zzxm3);
            }
            ArrayList<zzxm> arrayList3 = arrayList2;
            return arrayList3;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    int zzabp() {
        long l = this.zzapy.currentTimeMillis();
        if (l <= this.aCT + 86400000L) {
            return 0;
        }
        this.aCT = l;
        SQLiteDatabase sQLiteDatabase = this.zzpg("Error opening database for deleteStaleHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        long l2 = this.zzapy.currentTimeMillis() - 2592000000L;
        int n = sQLiteDatabase.delete("gtm_hits", "HIT_TIME < ?", new String[]{Long.toString(l2)});
        zzxv.v(new StringBuilder(31).append("Removed ").append(n).append(" stale hits.").toString());
        this.aGc.zzcl(this.zzcfv() == 0);
        return n;
    }

    void zzh(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.zzpg("Error opening database for deleteHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        String string2 = String.format("HIT_ID in (%s)", TextUtils.join((CharSequence)",", Collections.nCopies(stringArray.length, "?")));
        try {
            sQLiteDatabase.delete("gtm_hits", string2, stringArray);
            this.aGc.zzcl(this.zzcfv() == 0);
        }
        catch (SQLiteException sQLiteException) {
            zzxv.zzdf("Error deleting hits");
        }
    }

    private void zzu(long l) {
        this.zzh(new String[]{String.valueOf(l)});
    }

    private void zzi(long l, long l2) {
        SQLiteDatabase sQLiteDatabase = this.zzpg("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_first_send_time", Long.valueOf(l2));
        try {
            sQLiteDatabase.update("gtm_hits", contentValues, "hit_id=?", new String[]{String.valueOf(l)});
        }
        catch (SQLiteException sQLiteException) {
            zzxv.zzdf(new StringBuilder(69).append("Error setting HIT_FIRST_DISPATCH_TIME for hitId: ").append(l).toString());
            this.zzu(l);
        }
    }

    int zzcfv() {
        return this.zzqi("gtm_hits");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int zzqi(String string2) {
        int n = 0;
        SQLiteDatabase sQLiteDatabase = this.zzpg("Error opening database for getNumRecords.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        try (Cursor cursor = null;){
            String string3 = String.valueOf(string2);
            cursor = sQLiteDatabase.rawQuery(string3.length() != 0 ? "SELECT COUNT(*) from ".concat(string3) : new String("SELECT COUNT(*) from "), null);
            if (cursor.moveToFirst()) {
                n = (int)cursor.getLong(0);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int zzcfw() {
        int n = 0;
        SQLiteDatabase sQLiteDatabase = this.zzpg("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_first_send_time"}, "hit_first_send_time=0", null, null, null, null);
            n = cursor.getCount();
        }
        return n;
    }

    @Override
    public void dispatch() {
        zzxv.v("GTM Dispatch running...");
        if (!this.aGb.zzcex()) {
            return;
        }
        List<zzxm> list = this.zzaar(40);
        if (list.isEmpty()) {
            zzxv.v("...nothing to dispatch");
            this.aGc.zzcl(true);
            return;
        }
        this.aGb.zzal(list);
        if (this.zzcfw() > 0) {
            zzyh.zzcil().dispatch();
        }
    }

    private SQLiteDatabase zzpg(String string2) {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.aGa.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            zzxv.zzdf(string2);
            return null;
        }
        return sQLiteDatabase;
    }

    class zzb
    extends SQLiteOpenHelper {
        private boolean aCW;
        private long aCX;

        zzb(Context context, String string2) {
            super(context, string2, null, 1);
            this.aCX = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(String string2, SQLiteDatabase sQLiteDatabase) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string2}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            if (this.aCW && this.aCX + 3600000L > zzxy.this.zzapy.currentTimeMillis()) {
                throw new SQLiteException("Database creation failed");
            }
            SQLiteDatabase sQLiteDatabase = null;
            this.aCW = true;
            this.aCX = zzxy.this.zzapy.currentTimeMillis();
            try {
                sQLiteDatabase = super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                zzxy.this.mContext.getDatabasePath(zzxy.this.aCS).delete();
            }
            if (sQLiteDatabase == null) {
                sQLiteDatabase = super.getWritableDatabase();
            }
            this.aCW = false;
            return sQLiteDatabase;
        }

        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            Object object;
            if (Build.VERSION.SDK_INT < 15) {
                object = sQLiteDatabase.rawQuery("PRAGMA journal_mode=memory", null);
                try {
                    object.moveToFirst();
                }
                finally {
                    object.close();
                }
            }
            if (!this.zza("gtm_hit_unique_ids", sQLiteDatabase)) {
                sQLiteDatabase.execSQL(aFX);
            } else {
                object = Arrays.asList("hit_unique_id");
                this.zza(sQLiteDatabase, "gtm_hit_unique_ids", (List<String>)object);
            }
            if (!this.zza("gtm_hits", sQLiteDatabase)) {
                sQLiteDatabase.execSQL(bo);
            } else {
                object = Arrays.asList("hit_id", "hit_url", "hit_time", "hit_first_send_time", "hit_method", "hit_unique_id", "hit_headers", "hit_body");
                this.zza(sQLiteDatabase, "gtm_hits", (List<String>)object);
            }
            sQLiteDatabase.execSQL(aFY);
            sQLiteDatabase.execSQL(aFZ);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zza(SQLiteDatabase sQLiteDatabase, String string2, List<String> list) {
            HashSet<String> hashSet = new HashSet<String>();
            try (Cursor cursor = sQLiteDatabase.rawQuery(new StringBuilder(22 + String.valueOf(string2).length()).append("SELECT * FROM ").append(string2).append(" WHERE 0").toString(), null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            }
            for (String string3 : list) {
                if (hashSet.remove(string3)) continue;
                throw new SQLiteException(String.format("Database column %s missing in table %s.", string3, string2));
            }
            if (!hashSet.isEmpty()) {
                throw new SQLiteException(String.format("Database has extra columns in table %s.", string2));
            }
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            zzxl.zzfa(sQLiteDatabase.getPath());
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        }
    }

    class zza
    implements zzyj.zza {
        zza() {
        }

        @Override
        public void zza(zzxm zzxm2) {
            zzxy.this.zzu(zzxm2.zzcfh());
        }

        @Override
        public void zzb(zzxm zzxm2) {
            zzxy.this.zzu(zzxm2.zzcfh());
            long l = zzxm2.zzcfh();
            zzxv.v(new StringBuilder(57).append("Permanent failure dispatching hitId: ").append(l).toString());
        }

        @Override
        public void zzc(zzxm zzxm2) {
            long l = zzxm2.zzcfi();
            if (l == 0L) {
                zzxy.this.zzi(zzxm2.zzcfh(), zzxy.this.zzapy.currentTimeMillis());
            } else if (l + 14400000L < zzxy.this.zzapy.currentTimeMillis()) {
                zzxy.this.zzu(zzxm2.zzcfh());
                long l2 = zzxm2.zzcfh();
                zzxv.v(new StringBuilder(47).append("Giving up on failed hitId: ").append(l2).toString());
            }
        }
    }
}

