/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Process;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzxv;
import java.io.IOException;

public class zzxc {
    private volatile long aAv = 900000L;
    private volatile long aAw = 30000L;
    private volatile boolean aFf = true;
    private volatile boolean mClosed = false;
    private volatile AdvertisingIdClient.Info av;
    private volatile long aAx;
    private volatile long aAy;
    private final Context mContext;
    private final zze zzapy;
    private final Thread zzcql;
    private final Object aAz = new Object();
    private zza aFg = new zza(){

        @Override
        public AdvertisingIdClient.Info zzcdr() {
            AdvertisingIdClient.Info info = null;
            try {
                info = AdvertisingIdClient.getAdvertisingIdInfo((Context)zzxc.this.mContext);
            }
            catch (IllegalStateException illegalStateException) {
                zzxv.zzd("IllegalStateException getting Advertising Id Info", illegalStateException);
            }
            catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
                zzxv.zzd("GooglePlayServicesRepairableException getting Advertising Id Info", googlePlayServicesRepairableException);
            }
            catch (IOException iOException) {
                zzxv.zzd("IOException getting Ad Id Info", iOException);
            }
            catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                zzxc.this.aFf = false;
                zzxv.zzd("GooglePlayServicesNotAvailableException getting Advertising Id Info", googlePlayServicesNotAvailableException);
            }
            catch (Exception exception) {
                zzxv.zzd("Unknown exception. Could not get the Advertising Id Info.", exception);
            }
            return info;
        }
    };
    private static Object aAB = new Object();
    private static zzxc aFh;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzxc zzek(Context context) {
        if (aFh == null) {
            Object object = aAB;
            synchronized (object) {
                if (aFh == null) {
                    aFh = new zzxc(context);
                    aFh.start();
                }
            }
        }
        return aFh;
    }

    private zzxc(Context context) {
        this(context, null, zzh.zzaxj());
    }

    public zzxc(Context context, zza zza2, zze zze2) {
        this.zzapy = zze2;
        this.mContext = context != null ? context.getApplicationContext() : context;
        if (zza2 != null) {
            this.aFg = zza2;
        }
        this.aAx = this.zzapy.currentTimeMillis();
        this.zzcql = new Thread(new Runnable(){

            @Override
            public void run() {
                zzxc.this.zzcdq();
            }
        });
    }

    public String zzcdm() {
        if (this.av == null) {
            this.zzcdn();
        } else {
            this.zzcdo();
        }
        this.zzcdp();
        return this.av == null ? null : this.av.getId();
    }

    public boolean isLimitAdTrackingEnabled() {
        if (this.av == null) {
            this.zzcdn();
        } else {
            this.zzcdo();
        }
        this.zzcdp();
        return this.av == null ? true : this.av.isLimitAdTrackingEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzcdn() {
        zzxc zzxc2 = this;
        synchronized (zzxc2) {
            try {
                this.zzcdo();
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzcdo() {
        if (this.zzapy.currentTimeMillis() - this.aAx > this.aAw) {
            Object object = this.aAz;
            synchronized (object) {
                this.aAz.notify();
            }
            this.aAx = this.zzapy.currentTimeMillis();
        }
    }

    private void zzcdp() {
        if (this.zzapy.currentTimeMillis() - this.aAy > 3600000L) {
            this.av = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzcdq() {
        Process.setThreadPriority((int)10);
        while (!this.mClosed) {
            AdvertisingIdClient.Info info = null;
            if (this.aFf) {
                info = this.aFg.zzcdr();
            }
            if (info != null) {
                this.av = info;
                this.aAy = this.zzapy.currentTimeMillis();
                zzxv.zzde("Obtained fresh AdvertisingId info from GmsCore.");
            }
            Object object = this;
            synchronized (object) {
                this.notifyAll();
            }
            try {
                object = this.aAz;
                synchronized (object) {
                    this.aAz.wait(this.aAv);
                }
            }
            catch (InterruptedException interruptedException) {
                zzxv.zzde("sleep interrupted in AdvertiserDataPoller thread; continuing");
            }
        }
    }

    public void start() {
        this.zzcql.start();
    }

    public static interface zza {
        public AdvertisingIdClient.Info zzcdr();
    }
}

