/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.internal.zzaeb;
import com.google.android.gms.internal.zzxv;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class zzaeh {
    private final Context mContext;
    private final zza aIo;
    private final ExecutorService aDx;

    public zzaeh(final Context context) {
        this(context, Executors.newSingleThreadExecutor(), new zza(){

            @Override
            public InputStream open(String string2) throws IOException {
                return context.getAssets().open(string2);
            }
        });
    }

    zzaeh(Context context, ExecutorService executorService, zza zza2) {
        this.mContext = context;
        this.aDx = executorService;
        this.aIo = zza2;
    }

    public void zza(final String string2, final zzaeb zzaeb2) {
        this.aDx.execute(new Runnable(){

            @Override
            public void run() {
                zzaeh.this.zzb(string2, zzaeb2);
            }
        });
    }

    void zzb(String string2, zzaeb zzaeb2) {
        zzxv.v("Starting to load a saved resource file from Disk.");
        try {
            FileInputStream fileInputStream = new FileInputStream(this.zzqx(string2));
            if (fileInputStream != null) {
                byte[] byArray = this.zzn(fileInputStream);
                zzaeb2.zzal(byArray);
            } else {
                zzaeb2.zzv(0, 1);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = String.valueOf(this.zzqy(string2));
            zzxv.e(string3.length() != 0 ? "Saved resource not found: ".concat(string3) : new String("Saved resource not found: "));
            zzaeb2.zzv(0, 1);
        }
    }

    public void zza(final String string2, final String string3, final zzaeb zzaeb2) {
        this.aDx.execute(new Runnable(){

            @Override
            public void run() {
                zzaeh.this.zzb(string2, string3, zzaeb2);
            }
        });
    }

    void zzb(String string2, String string3, zzaeb zzaeb2) {
        zzxv.v("Starting to load a default asset file from Disk.");
        if (string3 == null) {
            zzxv.v("Default asset file is not specified. Not proceeding with the loading");
            zzaeb2.zzv(0, 2);
            return;
        }
        try {
            InputStream inputStream = this.aIo.open(string3);
            if (inputStream != null) {
                byte[] byArray = this.zzn(inputStream);
                zzaeb2.zzal(byArray);
            } else {
                zzaeb2.zzv(0, 2);
            }
        }
        catch (IOException iOException) {
            zzxv.e(new StringBuilder(42 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Default asset file not found. ").append(string2).append(". Filename: ").append(string3).toString());
            zzaeb2.zzv(0, 2);
        }
    }

    public void zzg(final String string2, final byte[] byArray) {
        this.aDx.execute(new Runnable(){

            @Override
            public void run() {
                zzaeh.this.zzh(string2, byArray);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzh(String string2, byte[] byArray) {
        String string3;
        FileOutputStream fileOutputStream;
        File file = this.zzqx(string2);
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string4 = "Error opening resource file for writing";
            zzxv.e(string4);
            return;
        }
        try {
            fileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            string3 = "Error writing resource to disk. Removing resource from disk";
            zzxv.e(string3);
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
                zzxv.v(new StringBuilder(24 + String.valueOf(string2).length()).append("Resource ").append(string2).append(" saved on Disk.").toString());
            }
            catch (IOException iOException) {
                string3 = "Error closing stream for writing resource to disk";
                zzxv.e(string3);
            }
        }
    }

    public long zzqw(String string2) {
        File file = this.zzqx(string2);
        return file.exists() ? file.lastModified() : 0L;
    }

    File zzqx(String string2) {
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, this.zzqy(string2));
    }

    private String zzqy(String string2) {
        String string3 = String.valueOf("resource_");
        String string4 = String.valueOf(string2);
        return string4.length() != 0 ? string3.concat(string4) : new String(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] zzn(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            zzo.zza((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            zzxv.zzdf("Failed to read the resource from disk");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                zzxv.zzdf("Error closing stream for reading resource from disk");
                return null;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    static interface zza {
        public InputStream open(String var1) throws IOException;
    }
}

