/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzady;
import com.google.android.gms.internal.zzaeb;
import com.google.android.gms.internal.zzaed;
import com.google.android.gms.internal.zzaee;
import com.google.android.gms.internal.zzaef;
import com.google.android.gms.internal.zzaeg;
import com.google.android.gms.internal.zzaeh;
import com.google.android.gms.internal.zzaen;
import com.google.android.gms.internal.zzaep;
import com.google.android.gms.internal.zzxg;
import com.google.android.gms.internal.zzxv;
import com.google.android.gms.internal.zzya;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class zzaec {
    private final Context mContext;
    private final zzaeh aHY;
    private final zze zzapy;
    private String aBs = null;
    final Map<String, zzc<zzaep>> aHZ = new HashMap<String, zzc<zzaep>>();
    private final Map<String, zzaen> aIa;

    public zzaec(Context context) {
        this(context, new HashMap<String, zzaen>(), new zzaeh(context), zzh.zzaxj());
    }

    zzaec(Context context, Map<String, zzaen> map, zzaeh zzaeh2, zze zze2) {
        this.mContext = context.getApplicationContext();
        this.zzapy = zze2;
        this.aHY = zzaeh2;
        this.aIa = map;
    }

    public void zza(String string2, @Nullable String string3, @Nullable String string4, List<Integer> list, zza zza2, zzxg zzxg2) {
        zzac.zzbs((!list.isEmpty() ? 1 : 0) != 0);
        zzaef zzaef2 = new zzaef().zza(new zzady(string2, string3, string4, this.zzqv(string2), zzya.zzcia().zzcib()));
        this.zza(zzaef2, Collections.unmodifiableList(list), 0, zza2, zzxg2);
    }

    void zza(zzaef zzaef2, List<Integer> list, int n, zza zza2, @Nullable zzxg zzxg2) {
        if (n == 0) {
            zzxv.v("Starting to fetch a new resource");
        }
        if (n >= list.size()) {
            String string2 = String.valueOf(zzaef2.zzcjg().getContainerId());
            String string3 = string2.length() != 0 ? "There is no valid resource for the container: ".concat(string2) : new String("There is no valid resource for the container: ");
            zzxv.v(string3);
            zza2.zza(new zzaeg(new Status(16, string3), list.get(n - 1)));
            return;
        }
        switch (list.get(n)) {
            case 0: {
                this.zzb(zzaef2, list, n, zza2, zzxg2);
                break;
            }
            case 1: {
                this.zza(zzaef2, list, n, zza2);
                break;
            }
            case 2: {
                this.zzb(zzaef2, list, n, zza2);
                break;
            }
            default: {
                throw new UnsupportedOperationException(new StringBuilder(36).append("Unknown fetching source: ").append(n).toString());
            }
        }
    }

    private void zzb(zzaef zzaef2, List<Integer> list, int n, zza zza2, @Nullable zzxg zzxg2) {
        boolean bl = false;
        zzady zzady2 = zzaef2.zzcjg();
        zzc<zzaep> zzc2 = this.aHZ.get(zzady2.getContainerId());
        if (zzaef2.zzcjg().zzcjc()) {
            bl = true;
        } else {
            long l;
            long l2 = l = zzc2 != null ? zzc2.zzcjf() : this.aHY.zzqw(zzady2.getContainerId());
            if (l + 900000L < this.zzapy.currentTimeMillis()) {
                bl = true;
            }
        }
        if (bl) {
            zzaen zzaen2 = this.aIa.get(zzaef2.getId());
            if (zzaen2 == null) {
                zzaen2 = null == null ? new zzaen() : new zzaen(this.aBs);
                this.aIa.put(zzaef2.getId(), zzaen2);
            }
            String string2 = String.valueOf(zzady2.getContainerId());
            zzxv.v(new StringBuilder(43 + String.valueOf(string2).length()).append("Attempting to fetch container ").append(string2).append(" from network").toString());
            zzaen2.zza(this.mContext, zzaef2, 0L, new zzb(0, zzaef2, zzaee.aIg, list, n, zza2, zzxg2));
        } else {
            this.zza(zzaef2, list, n + 1, zza2, zzxg2);
        }
    }

    private void zza(zzaef zzaef2, List<Integer> list, int n, zza zza2) {
        zzady zzady2 = zzaef2.zzcjg();
        String string2 = String.valueOf(zzady2.getContainerId());
        zzxv.v(new StringBuilder(52 + String.valueOf(string2).length()).append("Attempting to fetch container ").append(string2).append(" from a saved resource").toString());
        this.aHY.zza(zzady2.zzcjb(), new zzb(1, zzaef2, zzaee.aIg, list, n, zza2, null));
    }

    private void zzb(zzaef zzaef2, List<Integer> list, int n, zza zza2) {
        zzady zzady2 = zzaef2.zzcjg();
        String string2 = String.valueOf(zzady2.getContainerId());
        zzxv.v(new StringBuilder(56 + String.valueOf(string2).length()).append("Attempting to fetch container ").append(string2).append(" from the default resource").toString());
        this.aHY.zza(zzady2.zzcjb(), zzady2.zzciz(), new zzb(2, zzaef2, zzaee.aIg, list, n, zza2, null));
    }

    void zza(Status status, zzaeg.zza zza2) {
        String string2 = zza2.zzcjl().getContainerId();
        zzaep zzaep2 = zza2.zzcjm();
        if (this.aHZ.containsKey(string2)) {
            zzc<zzaep> zzc2 = this.aHZ.get(string2);
            zzc2.zzbz(this.zzapy.currentTimeMillis());
            if (status == Status.vY) {
                zzc2.zzeg(status);
                zzc2.zzba(zzaep2);
            }
        } else {
            this.aHZ.put(string2, new zzc<zzaep>(status, zzaep2, this.zzapy.currentTimeMillis()));
        }
    }

    boolean zzqv(String string2) {
        zzya zzya2 = zzya.zzcia();
        return zzya2.isPreview() && string2.equals(zzya2.getContainerId());
    }

    static class zzc<T> {
        private Status fp;
        private T mData;
        private long aIf;

        public zzc(Status status, T t, long l) {
            this.fp = status;
            this.mData = t;
            this.aIf = l;
        }

        public void zzeg(Status status) {
            this.fp = status;
        }

        public long zzcjf() {
            return this.aIf;
        }

        public void zzbz(long l) {
            this.aIf = l;
        }

        public void zzba(T t) {
            this.mData = t;
        }
    }

    class zzb
    extends zzaeb {
        private final zza aIb;
        private final List<Integer> aIc;
        private final int aId;

        zzb(int n, zzaef zzaef2, zzaed zzaed2, List<Integer> list, int n2, zza zza2, @Nullable zzxg zzxg2) {
            super(n, zzaef2, zzaed2, zzxg2);
            this.aIb = zza2;
            this.aIc = list;
            this.aId = n2;
        }

        @Override
        protected void zza(zzaeg zzaeg2) {
            Object object;
            boolean bl = false;
            if (zzaeg2.getStatus() == Status.vY) {
                String string2 = String.valueOf(zzaeg2.zzcjj());
                zzxv.v(string2.length() != 0 ? "Container resource successfully loaded from ".concat(string2) : new String("Container resource successfully loaded from "));
                if (zzaeg2.getSource() == 0) {
                    object = zzaeg2.zzcjh();
                    if (((zzaeg.zza)object).zzcjl().zzcjc()) {
                        bl = true;
                    } else {
                        zzaec.this.zza(zzaeg2.getStatus(), (zzaeg.zza)object);
                        if (((zzaeg.zza)object).zzcjk() != null && ((zzaeg.zza)object).zzcjk().length > 0) {
                            zzaec.this.aHY.zzg(((zzaeg.zza)object).zzcjl().zzcjb(), ((zzaeg.zza)object).zzcjk());
                            bl = true;
                        }
                    }
                } else {
                    bl = true;
                }
            }
            if (bl) {
                this.aIb.zza(zzaeg2);
                return;
            }
            object = String.valueOf(zzaeg2.zzcjj());
            String string3 = zzaeg2.getStatus().isSuccess() ? "SUCCESS" : "FAILURE";
            zzxv.v(new StringBuilder(54 + String.valueOf(object).length() + String.valueOf(string3).length()).append("Cannot fetch a valid resource from ").append((String)object).append(". Response status: ").append(string3).toString());
            if (zzaeg2.getStatus().isSuccess()) {
                String string4 = String.valueOf(zzaeg2.zzcjj());
                zzxv.v(string4.length() != 0 ? "Response source: ".concat(string4) : new String("Response source: "));
                int n = zzaeg2.zzcjh().zzcjk().length;
                zzxv.v(new StringBuilder(26).append("Response size: ").append(n).toString());
            }
            zzaec.this.zza(this.aHW, this.aIc, this.aId + 1, this.aIb, this.aFq);
        }
    }

    public static interface zza {
        public void zza(zzaeg var1);
    }
}

