/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.internal.zzaeu;
import com.google.android.gms.internal.zzaev;
import com.google.android.gms.internal.zzaey;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzafa;
import com.google.android.gms.internal.zzafd;
import com.google.android.gms.internal.zzxv;
import com.google.android.gms.internal.zzyc;
import com.google.android.gms.internal.zzye;
import com.google.android.gms.internal.zzyo;
import com.google.android.gms.internal.zzys;
import com.google.android.gms.internal.zzyt;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class zzadx
extends zzyt {
    private static final String ID = zzaf.zzkj.toString();
    private static final List<String> aEY = Arrays.asList("detail", "checkout", "checkout_option", "click", "add", "remove", "purchase", "refund");
    private static final Pattern aEZ = Pattern.compile("dimension(\\d+)");
    private static final Pattern aFa = Pattern.compile("metric(\\d+)");
    private static final Set<String> aHO = zzf.zza((Object)"", (Object)"0", (Object)"false");
    private static final Map<String, String> aHP = zzf.zza((Object)"transactionId", (Object)"&ti", (Object)"transactionAffiliation", (Object)"&ta", (Object)"transactionTax", (Object)"&tt", (Object)"transactionShipping", (Object)"&ts", (Object)"transactionTotal", (Object)"&tr", (Object)"transactionCurrency", (Object)"&cu");
    private static final Map<String, String> aHQ = zzf.zza((Object)"name", (Object)"&in", (Object)"sku", (Object)"&ic", (Object)"category", (Object)"&iv", (Object)"price", (Object)"&ip", (Object)"quantity", (Object)"&iq", (Object)"currency", (Object)"&cu");
    private final zzyo aHR;
    private final zzyc.zzc aGr;
    private Map<String, Object> aHS;

    public zzadx(Context context, zzyc.zzc zzc2) {
        this(new zzyo(context), zzc2);
    }

    public zzadx(zzyo zzyo2, zzyc.zzc zzc2) {
        this.aGr = zzc2;
        this.aHR = zzyo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected zzaeu<?> zza(zzye zzye2, zzaeu<?> ... zzaeuArray) {
        zzac.zzbs((zzaeuArray != null ? 1 : 0) != 0);
        zzac.zzbs((zzaeuArray.length >= 1 ? 1 : 0) != 0);
        try {
            this.aHS = zzafd.zzao(this.aGr.zzcij().zzchp());
            zzaeu<?> zzaeu2 = zzaeuArray[0];
            zzaeu zzaeu3 = zzaeuArray.length > 1 ? zzaeuArray[1] : new zzaev(true);
            zzaeu zzaeu4 = zzaeuArray.length > 2 ? zzaeuArray[2] : new zzaev(false);
            zzaey zzaey2 = zzaeuArray.length > 3 ? zzaeuArray[3] : zzaey.aIX;
            zzaey zzaey3 = zzaeuArray.length > 4 ? zzaeuArray[4] : zzaey.aIX;
            zzaeu zzaeu5 = zzaeuArray.length > 5 ? zzaeuArray[5] : new zzaev(false);
            zzaeu zzaeu6 = zzaeuArray.length > 6 ? zzaeuArray[6] : new zzaev(false);
            zzaey zzaey4 = zzaeuArray.length > 7 ? zzaeuArray[7] : zzaey.aIX;
            zzaeu zzaeu7 = zzaeuArray.length > 8 ? zzaeuArray[8] : new zzaev(false);
            zzac.zzbs((boolean)(zzaeu2 instanceof zzafa));
            zzac.zzbs((zzaey2 == zzaey.aIX || zzaey2 instanceof zzafa ? 1 : 0) != 0);
            zzac.zzbs((zzaey3 == zzaey.aIX || zzaey3 instanceof zzafa ? 1 : 0) != 0);
            zzac.zzbs((zzaey4 == zzaey.aIX || zzaey4 instanceof zzafa ? 1 : 0) != 0);
            Tracker tracker = this.aHR.zzpv("_GTM_DEFAULT_TRACKER_");
            tracker.enableAdvertisingIdCollection(zzys.zza(zzaeu7));
            if (zzys.zza(zzaeu5)) {
                this.zzb(tracker, zzaeu2, zzaeu6, zzaey4);
            } else if (zzys.zza(zzaeu3)) {
                this.zza(tracker, zzaeu2);
            } else if (zzys.zza(zzaeu4)) {
                this.zza(tracker, zzaeu2, zzaey2, zzaey3);
            } else {
                zzxv.zzdf("Ignoring unknown tag.");
            }
        }
        finally {
            this.aHS = null;
        }
        return zzaey.aIX;
    }

    private List<Map<String, Object>> zzqr(String string2) {
        Object object = this.aHS.get(string2);
        if (object == null) {
            return null;
        }
        if (!(object instanceof List)) {
            throw new IllegalArgumentException("transactionProducts should be of type List.");
        }
        List list = (List)object;
        for (Object e : list) {
            if (e instanceof Map) continue;
            throw new IllegalArgumentException("Each element of transactionProducts should be of type Map.");
        }
        List list2 = list;
        return list2;
    }

    private void zza(Tracker tracker, zzaeu<?> zzaeu2) {
        Map<String, String> map = this.zzi(zzaeu2);
        tracker.send(map);
    }

    private void zza(Tracker tracker, zzaeu<?> zzaeu2, zzaeu<?> zzaeu3, zzaeu<?> zzaeu4) {
        String string2 = (String)this.aHS.get("transactionId");
        if (string2 == null) {
            zzxv.e("Cannot find transactionId in data layer.");
            return;
        }
        LinkedList<Map<String, String>> linkedList = new LinkedList<Map<String, String>>();
        try {
            Map<String, String> map = this.zzi(zzaeu2);
            map.put("&t", "transaction");
            Map<String, String> map2 = this.zzj(zzaeu3);
            for (Map.Entry<String, String> object2 : map2.entrySet()) {
                String string3 = (String)this.aHS.get(object2.getKey());
                if (string3 == null) continue;
                map.put(object2.getValue(), string3);
            }
            linkedList.add(map);
            List<Map<String, Object>> list = this.zzqr("transactionProducts");
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Map map3 = (Map)iterator.next();
                    if (map3.get("name") == null) {
                        zzxv.e("Unable to send transaction item hit due to missing 'name' field.");
                        return;
                    }
                    Map<String, String> map4 = this.zzi(zzaeu2);
                    map4.put("&t", "item");
                    map4.put("&ti", string2);
                    Map<String, String> map5 = this.zzk(zzaeu4);
                    for (Map.Entry<String, String> entry : map5.entrySet()) {
                        Object v = map3.get(entry.getKey());
                        if (v == null) continue;
                        map4.put(entry.getValue(), v.toString());
                    }
                    linkedList.add(map4);
                }
            }
            for (Map map6 : linkedList) {
                tracker.send(map6);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            zzxv.zzb("Unable to send transaction", illegalArgumentException);
        }
    }

    private void zzb(Tracker tracker, zzaeu<?> zzaeu2, zzaeu<?> zzaeu3, zzaeu<?> zzaeu4) {
        HitBuilders.ScreenViewBuilder screenViewBuilder = new HitBuilders.ScreenViewBuilder();
        Map<String, String> map = this.zzi(zzaeu2);
        screenViewBuilder.setAll(map);
        Map map2 = null;
        Object object = zzys.zza(zzaeu3) ? this.aHS.get("ecommerce") : zzafd.zzl(zzafd.zzm(zzaeu4));
        if (object instanceof Map) {
            Object object2;
            Object object3;
            List list;
            Object v;
            map2 = (Map)object;
            String string2 = map.get("&cu");
            if (string2 == null) {
                string2 = (String)map2.get("currencyCode");
            }
            if (string2 != null) {
                screenViewBuilder.set("&cu", string2);
            }
            if ((v = map2.get("impressions")) instanceof List) {
                list = (List)v;
                for (Iterator<String> iterator : list) {
                    try {
                        Product runtimeException = this.zzbo((Map<String, Object>)((Object)iterator));
                        screenViewBuilder.addImpression(runtimeException, (String)iterator.get("list"));
                    }
                    catch (RuntimeException runtimeException) {
                        String string3 = String.valueOf(runtimeException.getMessage());
                        zzxv.e(string3.length() != 0 ? "Failed to extract a product from event data. ".concat(string3) : new String("Failed to extract a product from event data. "));
                    }
                }
            }
            list = null;
            if (map2.containsKey("promoClick")) {
                object3 = (Map)map2.get("promoClick");
                list = (List)object3.get("promotions");
            } else if (map2.containsKey("promoView")) {
                object3 = (Map)map2.get("promoView");
                list = (List)object3.get("promotions");
            }
            boolean bl = true;
            if (list != null) {
                for (Map map3 : list) {
                    try {
                        object2 = this.zzbn(map3);
                        screenViewBuilder.addPromotion((Promotion)object2);
                    }
                    catch (RuntimeException runtimeException) {
                        String string4 = String.valueOf(runtimeException.getMessage());
                        zzxv.e(string4.length() != 0 ? "Failed to extract a promotion from event data. ".concat(string4) : new String("Failed to extract a promotion from event data. "));
                    }
                }
                if (map2.containsKey("promoClick")) {
                    screenViewBuilder.set("&promoa", "click");
                    bl = false;
                } else {
                    screenViewBuilder.set("&promoa", "view");
                }
            }
            if (bl) {
                for (String string5 : aEY) {
                    if (!map2.containsKey(string5)) continue;
                    object2 = (Map)map2.get(string5);
                    List list2 = (List)object2.get("products");
                    if (list2 != null) {
                        for (Map map4 : list2) {
                            try {
                                Product product = this.zzbo(map4);
                                screenViewBuilder.addProduct(product);
                            }
                            catch (RuntimeException runtimeException) {
                                String string6 = String.valueOf(runtimeException.getMessage());
                                zzxv.e(string6.length() != 0 ? "Failed to extract a product from event data. ".concat(string6) : new String("Failed to extract a product from event data. "));
                            }
                        }
                    }
                    try {
                        ProductAction productAction;
                        if (object2.containsKey("actionField")) {
                            Map map4;
                            map4 = (Map)object2.get("actionField");
                            productAction = this.zzk(string5, map4);
                        } else {
                            productAction = new ProductAction(string5);
                        }
                        screenViewBuilder.setProductAction(productAction);
                    }
                    catch (RuntimeException runtimeException) {
                        String string7 = String.valueOf(runtimeException.getMessage());
                        zzxv.e(string7.length() != 0 ? "Failed to extract a product action from event data. ".concat(string7) : new String("Failed to extract a product action from event data. "));
                    }
                    break;
                }
            }
        }
        tracker.send(screenViewBuilder.build());
    }

    private ProductAction zzk(String string2, Map<String, Object> map) {
        ProductAction productAction = new ProductAction(string2);
        Object object = map.get("id");
        if (object != null) {
            productAction.setTransactionId(String.valueOf(object));
        }
        if ((object = map.get("affiliation")) != null) {
            productAction.setTransactionAffiliation(String.valueOf(object));
        }
        if ((object = map.get("coupon")) != null) {
            productAction.setTransactionCouponCode(String.valueOf(object));
        }
        if ((object = map.get("list")) != null) {
            productAction.setProductActionList(String.valueOf(object));
        }
        if ((object = map.get("option")) != null) {
            productAction.setCheckoutOptions(String.valueOf(object));
        }
        if ((object = map.get("revenue")) != null) {
            productAction.setTransactionRevenue(this.zzax(object).doubleValue());
        }
        if ((object = map.get("tax")) != null) {
            productAction.setTransactionTax(this.zzax(object).doubleValue());
        }
        if ((object = map.get("shipping")) != null) {
            productAction.setTransactionShipping(this.zzax(object).doubleValue());
        }
        if ((object = map.get("step")) != null) {
            productAction.setCheckoutStep(this.zzay(object).intValue());
        }
        return productAction;
    }

    private Promotion zzbn(Map<String, String> map) {
        Promotion promotion = new Promotion();
        String string2 = map.get("id");
        if (string2 != null) {
            promotion.setId(String.valueOf(string2));
        }
        if ((string2 = map.get("name")) != null) {
            promotion.setName(String.valueOf(string2));
        }
        if ((string2 = map.get("creative")) != null) {
            promotion.setCreative(String.valueOf(string2));
        }
        if ((string2 = map.get("position")) != null) {
            promotion.setPosition(String.valueOf(string2));
        }
        return promotion;
    }

    private Product zzbo(Map<String, Object> map) {
        Product product = new Product();
        Object object = map.get("id");
        if (object != null) {
            product.setId(String.valueOf(object));
        }
        if ((object = map.get("name")) != null) {
            product.setName(String.valueOf(object));
        }
        if ((object = map.get("brand")) != null) {
            product.setBrand(String.valueOf(object));
        }
        if ((object = map.get("category")) != null) {
            product.setCategory(String.valueOf(object));
        }
        if ((object = map.get("variant")) != null) {
            product.setVariant(String.valueOf(object));
        }
        if ((object = map.get("coupon")) != null) {
            product.setCouponCode(String.valueOf(object));
        }
        if ((object = map.get("position")) != null) {
            product.setPosition(this.zzay(object).intValue());
        }
        if ((object = map.get("price")) != null) {
            product.setPrice(this.zzax(object).doubleValue());
        }
        if ((object = map.get("quantity")) != null) {
            product.setQuantity(this.zzay(object).intValue());
        }
        for (String string2 : map.keySet()) {
            Matcher matcher = aEZ.matcher(string2);
            if (matcher.matches()) {
                int n = 0;
                try {
                    n = Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    String string3 = String.valueOf(string2);
                    zzxv.zzdf(string3.length() != 0 ? "illegal number in custom dimension value: ".concat(string3) : new String("illegal number in custom dimension value: "));
                    continue;
                }
                product.setCustomDimension(n, String.valueOf(map.get(string2)));
                continue;
            }
            Matcher matcher2 = aFa.matcher(string2);
            if (!matcher2.matches()) continue;
            int n = 0;
            try {
                n = Integer.parseInt(matcher2.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = String.valueOf(string2);
                zzxv.zzdf(string4.length() != 0 ? "illegal number in custom metric value: ".concat(string4) : new String("illegal number in custom metric value: "));
                continue;
            }
            product.setCustomMetric(n, this.zzay(map.get(string2)).intValue());
        }
        return product;
    }

    private Map<String, String> zzh(zzaeu<?> zzaeu2) {
        zzac.zzy(zzaeu2);
        zzac.zzbs((boolean)(zzaeu2 instanceof zzafa));
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Object object = zzafd.zzl(zzafd.zzm(zzaeu2));
        zzac.zzbr((boolean)(object instanceof Map));
        Map map = (Map)object;
        for (Map.Entry entry : map.entrySet()) {
            linkedHashMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return linkedHashMap;
    }

    private Map<String, String> zzi(zzaeu<?> zzaeu2) {
        Map<String, String> map = this.zzh(zzaeu2);
        String string2 = map.get("&aip");
        if (string2 != null && aHO.contains(string2.toLowerCase())) {
            map.remove("&aip");
        }
        return map;
    }

    private Map<String, String> zzj(zzaeu<?> zzaeu2) {
        return zzaeu2 == zzaey.aIX ? aHP : this.zzh(zzaeu2);
    }

    private Map<String, String> zzk(zzaeu<?> zzaeu2) {
        return zzaeu2 == zzaey.aIX ? aHQ : this.zzh(zzaeu2);
    }

    private Double zzax(Object object) {
        if (object instanceof String) {
            try {
                return Double.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(numberFormatException.getMessage());
                throw new RuntimeException(string2.length() != 0 ? "Cannot convert the object to Double: ".concat(string2) : new String("Cannot convert the object to Double: "));
            }
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return n.doubleValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        String string3 = String.valueOf(object.toString());
        throw new RuntimeException(string3.length() != 0 ? "Cannot convert the object to Double: ".concat(string3) : new String("Cannot convert the object to Double: "));
    }

    private Integer zzay(Object object) {
        if (object instanceof String) {
            try {
                return Integer.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(numberFormatException.getMessage());
                throw new RuntimeException(string2.length() != 0 ? "Cannot convert the object to Integer: ".concat(string2) : new String("Cannot convert the object to Integer: "));
            }
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return d.intValue();
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        String string3 = String.valueOf(object.toString());
        throw new RuntimeException(string3.length() != 0 ? "Cannot convert the object to Integer: ".concat(string3) : new String("Cannot convert the object to Integer: "));
    }
}

