/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzsu;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.tagmanager.CustomTagProvider;
import com.google.android.gms.tagmanager.CustomVariableProvider;
import com.google.android.gms.tagmanager.zzay;
import com.google.android.gms.tagmanager.zzaz;
import com.google.android.gms.tagmanager.zzba;
import com.google.android.gms.tagmanager.zzbb;
import com.google.android.gms.tagmanager.zzbc;
import com.google.android.gms.tagmanager.zzbd;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

final class zzae {
    private static volatile zzsu aBS;
    private static volatile zzbc aBT;
    private static final Map<String, CustomTagProvider> aBU;
    private static final Map<String, CustomVariableProvider> aBV;

    private zzae() {
    }

    static IBinder zzec(Context context) {
        try {
            zzsu zzsu2 = zzae.zzef(context);
            IBinder iBinder = zzsu2.zzjd("com.google.android.gms.tagmanager.TagManagerServiceProviderImpl");
            zzbd zzbd2 = zzbd.zza.asInterface(iBinder);
            try {
                return zzbd2.getService(zze.zzac((Object)context), zzae.zzeg(context), zzae.zzcey()).asBinder();
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
        }
        catch (zzsu.zza zza2) {
            throw new RuntimeException(zza2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zzed(Context context) {
        zzbc zzbc2 = zzae.zzee(context);
        Class<zzae> clazz = zzae.class;
        synchronized (zzae.class) {
            try {
                zzbc2.initialize(zze.zzac((Object)context), zzae.zzeg(context), zzae.zzcey());
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Intent intent, Context context) {
        zzbc zzbc2 = zzae.zzee(context);
        Class<zzae> clazz = zzae.class;
        synchronized (zzae.class) {
            try {
                zzbc2.previewIntent(intent, zze.zzac((Object)context), zze.zzac((Object)aBS.zzbdy()), zzae.zzeg(context), zzae.zzcey());
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static zzbc zzee(Context context) {
        zzbc zzbc2 = aBT;
        if (zzbc2 != null) return zzbc2;
        Class<zzae> clazz = zzae.class;
        synchronized (zzae.class) {
            zzbc2 = aBT;
            if (zzbc2 != null) return zzbc2;
            try {
                zzsu zzsu2 = zzae.zzef(context);
                aBT = zzbc.zza.asInterface(zzsu2.zzjd("com.google.android.gms.tagmanager.TagManagerApiImpl"));
                return aBT;
            }
            catch (zzsu.zza zza2) {
                throw new RuntimeException(zza2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static zzsu zzef(Context context) throws zzsu.zza {
        zzsu zzsu2 = aBS;
        if (zzsu2 != null) return zzsu2;
        Class<zzae> clazz = zzae.class;
        synchronized (zzae.class) {
            zzsu2 = aBS;
            if (aBS != null) return zzsu2;
            aBS = zzsu.zza((Context)context, (zzsu.zzb)zzsu.OA, (String)"com.google.android.gms.tagmanager");
            return aBS;
        }
    }

    private static zzbb zzeg(Context context) {
        final AppMeasurement appMeasurement = AppMeasurement.getInstance((Context)context);
        return new zzbb.zza(){

            @Override
            public void zza(String string, String string2, Bundle bundle, long l) {
                appMeasurement.zza(string, string2, bundle, l);
            }

            @Override
            public Map<String, Object> zzcfa() {
                Map map = appMeasurement.zzce(true);
                return map;
            }

            @Override
            public void zza(final zzba zzba2) {
                appMeasurement.zza(new AppMeasurement.zzb(){

                    public void zzb(String string, String string2, Bundle bundle, long l) {
                        try {
                            zzba2.zzb(string, string2, bundle, l);
                        }
                        catch (RemoteException remoteException) {
                            throw new IllegalStateException(remoteException);
                        }
                    }
                });
            }

            @Override
            public void zza(final zzaz zzaz2) {
                appMeasurement.zza(new AppMeasurement.zzc(){

                    public void zzc(String string, String string2, Bundle bundle, long l) {
                        try {
                            zzaz2.zzc(string, string2, bundle, l);
                        }
                        catch (RemoteException remoteException) {
                            throw new IllegalStateException(remoteException);
                        }
                    }
                });
            }
        };
    }

    static zzay zzcey() {
        return new zzay.zza(){

            @Override
            public void zzg(String string, Map map) {
                CustomTagProvider customTagProvider = null;
                if (!aBU.containsKey(string)) {
                    customTagProvider = (CustomTagProvider)zzae.zzc(string, CustomTagProvider.class);
                    aBU.put(string, customTagProvider);
                } else {
                    customTagProvider = (CustomTagProvider)aBU.get(string);
                }
                if (customTagProvider != null) {
                    customTagProvider.execute(map);
                }
            }

            @Override
            public String zzh(String string, Map map) {
                CustomVariableProvider customVariableProvider = null;
                if (!aBV.containsKey(string)) {
                    customVariableProvider = (CustomVariableProvider)zzae.zzc(string, CustomVariableProvider.class);
                    aBV.put(string, customVariableProvider);
                } else {
                    customVariableProvider = (CustomVariableProvider)aBV.get(string);
                }
                if (customVariableProvider != null) {
                    return customVariableProvider.getValue(map);
                }
                return null;
            }
        };
    }

    private static Object zzc(String string, Class<?> clazz) {
        Object var2_2 = null;
        try {
            Object object;
            Class<?> clazz2 = Class.forName(string);
            Class<?>[] classArray = clazz2.getInterfaces();
            boolean bl = false;
            for (Class<?> clazz3 : classArray) {
                if (!clazz3.equals(clazz)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                object = String.valueOf(clazz.getCanonicalName());
                Log.e((String)"GoogleTagManagerAPI", (String)new StringBuilder(30 + String.valueOf(string).length() + String.valueOf(object).length()).append(string).append(" doesn't implement ").append((String)object).append(" interface.").toString());
            } else {
                try {
                    object = clazz2.getConstructor(new Class[0]);
                    var2_2 = ((Constructor)object).newInstance(new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Log.e((String)"GoogleTagManagerAPI", (String)String.valueOf(string).concat(" doesn't have a valid no-arg constructor"));
                }
                catch (SecurityException securityException) {
                    Log.e((String)"GoogleTagManagerAPI", (String)String.valueOf(string).concat(" doesn't have an accessible no-arg constructor"));
                }
                catch (InvocationTargetException invocationTargetException) {
                    Log.e((String)"GoogleTagManagerAPI", (String)String.valueOf(string).concat(" construction threw an exception."));
                }
                catch (InstantiationException instantiationException) {
                    Log.e((String)"GoogleTagManagerAPI", (String)String.valueOf(string).concat(" is an abstract class."));
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.e((String)"GoogleTagManagerAPI", (String)String.valueOf(string).concat(" doesn't have an accessible no-arg constructor"));
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.e((String)"GoogleTagManagerAPI", (String)String.valueOf(string).concat(" can't be found in the application."));
        }
        return var2_2;
    }

    static {
        aBU = new HashMap<String, CustomTagProvider>();
        aBV = new HashMap<String, CustomVariableProvider>();
    }
}

