/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.nearby.Nearby;
import com.google.android.gms.nearby.messages.Message;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.Messages;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.MessageWrapper;
import com.google.android.gms.nearby.messages.internal.Update;
import com.google.android.gms.nearby.messages.internal.zzo;
import com.google.android.gms.nearby.messages.internal.zzr;
import java.util.List;

public class zzs
implements Messages {
    public static final Api.zzf<zzr> fa = new Api.zzf();
    public static final Api.zza<zzr, MessagesOptions> fb = new Api.zza<zzr, MessagesOptions>(){

        public zzr zza(Context context, Looper looper, zzh zzh2, MessagesOptions messagesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzr(context, looper, connectionCallbacks, onConnectionFailedListener, zzh2, messagesOptions);
        }

        public int getPriority() {
            return Integer.MAX_VALUE;
        }
    };

    @Override
    public PendingResult<Status> publish(GoogleApiClient googleApiClient, final Message message, final PublishOptions publishOptions) {
        zzac.zzy((Object)((Object)message));
        zzac.zzy((Object)publishOptions);
        return googleApiClient.zzd((zzqc.zza)new zza(googleApiClient){

            protected void zza(zzr zzr2) throws RemoteException {
                MessageWrapper messageWrapper = MessageWrapper.zza(message);
                zzr2.zza((zzqc.zzb<Status>)this, messageWrapper, publishOptions);
            }
        });
    }

    @Override
    public PendingResult<Status> publish(GoogleApiClient googleApiClient, Message message) {
        return this.publish(googleApiClient, message, PublishOptions.DEFAULT);
    }

    @Override
    public PendingResult<Status> unpublish(GoogleApiClient googleApiClient, final Message message) {
        zzac.zzy((Object)((Object)message));
        return googleApiClient.zzd((zzqc.zza)new zza(googleApiClient){

            protected void zza(zzr zzr2) throws RemoteException {
                MessageWrapper messageWrapper = MessageWrapper.zza(message);
                zzr2.zza((zzqc.zzb<Status>)this, messageWrapper);
            }
        });
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, final MessageListener messageListener, final SubscribeOptions subscribeOptions) {
        zzac.zzy((Object)messageListener);
        zzac.zzy((Object)subscribeOptions);
        final zzrd<MessageListener> zzrd2 = ((zzr)googleApiClient.zza(fa)).zza(googleApiClient, messageListener);
        return googleApiClient.zzd((zzqc.zza)new zza(googleApiClient){

            protected void zza(zzr zzr2) throws RemoteException {
                zzr2.zza((zzqc.zzb<Status>)this, (zzrd<MessageListener>)zzrd2, messageListener, subscribeOptions, null);
            }
        });
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, MessageListener messageListener) {
        return this.subscribe(googleApiClient, messageListener, SubscribeOptions.DEFAULT);
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, final PendingIntent pendingIntent, final SubscribeOptions subscribeOptions) {
        zzac.zzy((Object)pendingIntent);
        zzac.zzy((Object)subscribeOptions);
        return googleApiClient.zzd((zzqc.zza)new zza(googleApiClient){

            protected void zza(zzr zzr2) throws RemoteException {
                zzr2.zza((zzqc.zzb<Status>)this, pendingIntent, subscribeOptions);
            }
        });
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, PendingIntent pendingIntent) {
        return this.subscribe(googleApiClient, pendingIntent, SubscribeOptions.DEFAULT);
    }

    @Override
    public PendingResult<Status> unsubscribe(GoogleApiClient googleApiClient, final MessageListener messageListener) {
        zzac.zzy((Object)messageListener);
        final zzrd<MessageListener> zzrd2 = ((zzr)googleApiClient.zza(fa)).zza(googleApiClient, messageListener);
        return googleApiClient.zzd((zzqc.zza)new zza(googleApiClient){

            protected void zza(zzr zzr2) throws RemoteException {
                zzr2.zza((zzqc.zzb<Status>)this, (zzrd<MessageListener>)zzrd2, messageListener);
            }
        });
    }

    @Override
    public PendingResult<Status> unsubscribe(GoogleApiClient googleApiClient, final PendingIntent pendingIntent) {
        zzac.zzy((Object)pendingIntent);
        return googleApiClient.zzd((zzqc.zza)new zza(googleApiClient){

            protected void zza(zzr zzr2) throws RemoteException {
                zzr2.zza((zzqc.zzb<Status>)this, pendingIntent);
            }
        });
    }

    @Override
    public void handleIntent(Intent intent, MessageListener messageListener) {
        zzs.zza(zzs.zzad(intent), messageListener);
    }

    static void zza(Iterable<Update> iterable, MessageListener messageListener) {
        for (Update update : iterable) {
            if (update.zzzg(1)) {
                messageListener.onFound(update.awv);
            }
            if (update.zzzg(2)) {
                messageListener.onLost(update.awv);
            }
            if (update.zzzg(4)) {
                messageListener.onDistanceChanged(update.awv, update.axf);
            }
            if (!update.zzzg(8)) continue;
            messageListener.onBleSignalChanged(update.awv, update.axg);
        }
    }

    private static List<Update> zzad(Intent intent) {
        return zzo.zzc(intent, "com.google.android.gms.nearby.messages.UPDATES");
    }

    @Override
    public PendingResult<Status> getPermissionStatus(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzqc.zza)new zza(googleApiClient){

            protected void zza(zzr zzr2) throws RemoteException {
                zzr2.zzt((zzqc.zzb<Status>)this);
            }
        });
    }

    @Override
    public PendingResult<Status> registerStatusCallback(GoogleApiClient googleApiClient, final StatusCallback statusCallback) {
        zzac.zzy((Object)statusCallback);
        final zzrd<StatusCallback> zzrd2 = ((zzr)googleApiClient.zza(fa)).zza(googleApiClient, statusCallback);
        return googleApiClient.zzd((zzqc.zza)new zza(googleApiClient){

            protected void zza(zzr zzr2) throws RemoteException {
                zzr2.zza((zzqc.zzb<Status>)this, (zzrd<StatusCallback>)zzrd2, statusCallback);
            }
        });
    }

    @Override
    public PendingResult<Status> unregisterStatusCallback(GoogleApiClient googleApiClient, final StatusCallback statusCallback) {
        final zzrd<StatusCallback> zzrd2 = ((zzr)googleApiClient.zza(fa)).zza(googleApiClient, statusCallback);
        return googleApiClient.zzd((zzqc.zza)new zza(googleApiClient){

            protected void zza(zzr zzr2) throws RemoteException {
                zzr2.zzb((zzqc.zzb<Status>)this, (zzrd<StatusCallback>)zzrd2, statusCallback);
            }
        });
    }

    static abstract class zza
    extends zzqc.zza<Status, zzr> {
        public zza(GoogleApiClient googleApiClient) {
            super(Nearby.MESSAGES_API, googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }
}

