/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishCallback;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.ClientAppContext;
import com.google.android.gms.nearby.messages.internal.GetPermissionStatusRequest;
import com.google.android.gms.nearby.messages.internal.HandleClientLifecycleEventRequest;
import com.google.android.gms.nearby.messages.internal.MessageWrapper;
import com.google.android.gms.nearby.messages.internal.PublishRequest;
import com.google.android.gms.nearby.messages.internal.RegisterStatusCallbackRequest;
import com.google.android.gms.nearby.messages.internal.SubscribeRequest;
import com.google.android.gms.nearby.messages.internal.UnpublishRequest;
import com.google.android.gms.nearby.messages.internal.UnsubscribeRequest;
import com.google.android.gms.nearby.messages.internal.Update;
import com.google.android.gms.nearby.messages.internal.zzi;
import com.google.android.gms.nearby.messages.internal.zzk;
import com.google.android.gms.nearby.messages.internal.zzl;
import com.google.android.gms.nearby.messages.internal.zzm;
import com.google.android.gms.nearby.messages.internal.zzn;
import com.google.android.gms.nearby.messages.internal.zzs;
import com.google.android.gms.nearby.messages.internal.zzu;
import java.util.List;

class zzr
extends zzl<zzk> {
    private final ClientAppContext aww;
    private final int avH;
    private final zzh<StatusCallback, zzf> awx = new zzh<StatusCallback, zzf>(){

        protected zzf zzf(zzrd<StatusCallback> zzrd2) {
            return new zzf(zzrd2);
        }

        @Override
        protected /* synthetic */ zza zzg(zzrd zzrd2) {
            return this.zzf((zzrd<StatusCallback>)zzrd2);
        }
    };
    private final zzh<MessageListener, zzc> awy = new zzh<MessageListener, zzc>(){

        protected zzc zzh(zzrd<MessageListener> zzrd2) {
            return new zzc(zzrd2);
        }

        @Override
        protected /* synthetic */ zza zzg(zzrd zzrd2) {
            return this.zzh((zzrd<MessageListener>)zzrd2);
        }
    };

    private static int zzdu(Context context) {
        if (context instanceof Activity) {
            return 1;
        }
        if (context instanceof Application) {
            return 2;
        }
        if (context instanceof Service) {
            return 3;
        }
        return 0;
    }

    @TargetApi(value=14)
    zzr(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, com.google.android.gms.common.internal.zzh zzh2, MessagesOptions messagesOptions) {
        super(context, looper, 62, zzh2, connectionCallbacks, onConnectionFailedListener);
        String string = zzh2.zzauj();
        int n = zzr.zzdu(context);
        if (messagesOptions != null) {
            this.aww = new ClientAppContext(string, messagesOptions.avD, messagesOptions.avE, messagesOptions.avG, n);
            this.avH = messagesOptions.avF;
        } else {
            this.aww = new ClientAppContext(string, null, false, null, n);
            this.avH = -1;
        }
        if (n == 1 && com.google.android.gms.common.util.zzs.zzaxn()) {
            Activity activity = (Activity)context;
            Log.v((String)"NearbyMessagesClient", (String)String.format("Registering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb(activity, this));
        }
    }

    @NonNull
    protected Bundle zzagl() {
        Bundle bundle = super.zzagl();
        bundle.putInt("NearbyPermissions", this.avH);
        bundle.putParcelable("ClientAppContext", (Parcelable)this.aww);
        return bundle;
    }

    @NonNull
    protected String zzix() {
        return "com.google.android.gms.nearby.messages.service.NearbyMessagesService.START";
    }

    @NonNull
    protected String zziy() {
        return "com.google.android.gms.nearby.messages.internal.INearbyMessagesService";
    }

    protected zzk zzkl(IBinder iBinder) {
        return zzk.zza.zzkh(iBinder);
    }

    public void disconnect() {
        try {
            this.zzza(2);
        }
        catch (RemoteException remoteException) {
            Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit CLIENT_DISCONNECTED from override of GmsClient#disconnect(): %s", new Object[]{remoteException}));
        }
        super.disconnect();
    }

    void zza(zzqc.zzb<Status> zzb2, MessageWrapper messageWrapper, PublishOptions publishOptions) throws RemoteException {
        PublishRequest publishRequest = new PublishRequest(messageWrapper, publishOptions.getStrategy(), (IBinder)zzu.zzu(zzb2), (IBinder)zze.zza(publishOptions.getCallback()));
        ((zzk)this.zzatx()).zza(publishRequest);
    }

    void zza(zzqc.zzb<Status> zzb2, MessageWrapper messageWrapper) throws RemoteException {
        UnpublishRequest unpublishRequest = new UnpublishRequest(messageWrapper, (IBinder)zzu.zzu(zzb2), this.aww);
        ((zzk)this.zzatx()).zza(unpublishRequest);
    }

    void zza(zzqc.zzb<Status> zzb2, zzrd<MessageListener> zzrd2, MessageListener messageListener, SubscribeOptions subscribeOptions, @Nullable byte[] byArray) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest((IBinder)this.awy.zza(zzrd2, messageListener), subscribeOptions.getStrategy(), (IBinder)zzu.zzu(zzb2), subscribeOptions.getFilter(), null, 0, byArray, (IBinder)zzg.zza(subscribeOptions.getCallback()), subscribeOptions.avW);
        ((zzk)this.zzatx()).zza(subscribeRequest);
    }

    void zza(zzqc.zzb<Status> zzb2, PendingIntent pendingIntent, SubscribeOptions subscribeOptions) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest(null, subscribeOptions.getStrategy(), (IBinder)zzu.zzu(zzb2), subscribeOptions.getFilter(), pendingIntent, 0, null, (IBinder)zzg.zza(subscribeOptions.getCallback()), subscribeOptions.avW);
        ((zzk)this.zzatx()).zza(subscribeRequest);
    }

    void zza(zzqc.zzb<Status> zzb2, zzrd<MessageListener> zzrd2, MessageListener messageListener) throws RemoteException {
        if (this.awy.zzaj(messageListener) == null) {
            return;
        }
        UnsubscribeRequest unsubscribeRequest = new UnsubscribeRequest((IBinder)this.awy.zza(zzrd2, messageListener), (IBinder)zzu.zzu(zzb2), null, 0);
        ((zzk)this.zzatx()).zza(unsubscribeRequest);
        this.awy.zzak(messageListener);
    }

    void zza(zzqc.zzb<Status> zzb2, PendingIntent pendingIntent) throws RemoteException {
        UnsubscribeRequest unsubscribeRequest = new UnsubscribeRequest(null, (IBinder)zzu.zzu(zzb2), pendingIntent, 0);
        ((zzk)this.zzatx()).zza(unsubscribeRequest);
    }

    void zzt(zzqc.zzb<Status> zzb2) throws RemoteException {
        GetPermissionStatusRequest getPermissionStatusRequest = new GetPermissionStatusRequest((IBinder)zzu.zzu(zzb2));
        ((zzk)this.zzatx()).zza(getPermissionStatusRequest);
    }

    void zza(zzqc.zzb<Status> zzb2, zzrd<StatusCallback> zzrd2, StatusCallback statusCallback) throws RemoteException {
        RegisterStatusCallbackRequest registerStatusCallbackRequest = new RegisterStatusCallbackRequest((IBinder)zzu.zzu(zzb2), (IBinder)this.awx.zza(zzrd2, statusCallback));
        registerStatusCallbackRequest.awX = true;
        ((zzk)this.zzatx()).zza(registerStatusCallbackRequest);
    }

    void zzb(zzqc.zzb<Status> zzb2, zzrd<StatusCallback> zzrd2, StatusCallback statusCallback) throws RemoteException {
        if (this.awx.zzaj(statusCallback) == null) {
            return;
        }
        RegisterStatusCallbackRequest registerStatusCallbackRequest = new RegisterStatusCallbackRequest((IBinder)zzu.zzu(zzb2), (IBinder)this.awx.zza(zzrd2, statusCallback));
        registerStatusCallbackRequest.awX = false;
        ((zzk)this.zzatx()).zza(registerStatusCallbackRequest);
        this.awx.zzak(statusCallback);
    }

    void zzza(int n) throws RemoteException {
        String string;
        switch (n) {
            case 1: {
                string = "ACTIVITY_STOPPED";
                break;
            }
            case 2: {
                string = "CLIENT_DISCONNECTED";
                break;
            }
            default: {
                Log.w((String)"NearbyMessagesClient", (String)String.format("Received unknown/unforeseen client lifecycle event %d, can't do anything with it.", n));
                return;
            }
        }
        if (this.isConnected()) {
            HandleClientLifecycleEventRequest handleClientLifecycleEventRequest = new HandleClientLifecycleEventRequest(n);
            Log.d((String)"NearbyMessagesClient", (String)String.format("Emitting client lifecycle event %s", string));
            ((zzk)this.zzatx()).zza(handleClientLifecycleEventRequest);
        } else {
            Log.d((String)"NearbyMessagesClient", (String)String.format("Failed to emit client lifecycle event %s due to GmsClient being disconnected", string));
        }
    }

    zzrd<MessageListener> zza(GoogleApiClient googleApiClient, MessageListener messageListener) {
        return zzr.zza(googleApiClient, messageListener, this.awy);
    }

    zzrd<StatusCallback> zza(GoogleApiClient googleApiClient, StatusCallback statusCallback) {
        return zzr.zza(googleApiClient, statusCallback, this.awx);
    }

    private static <C> zzrd<C> zza(GoogleApiClient googleApiClient, C c, zzh<C, ? extends zza<C>> zzh2) {
        zza<C> zza2 = zzh2.zzaj(c);
        if (zza2 != null) {
            return zza2.zzcbf();
        }
        return googleApiClient.zzs(c);
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzkl(iBinder);
    }

    private static abstract class zzh<C, W extends zza<C>> {
        private final SimpleArrayMap<C, W> Ex = new SimpleArrayMap(1);

        private zzh() {
        }

        @Nullable
        W zzaj(C c) {
            return (W)((zza)this.Ex.get(c));
        }

        W zza(zzrd<C> zzrd2, C c) {
            zza<Object> zza2 = (zza)this.Ex.get(c);
            if (zza2 != null) {
                zzrd2.clear();
                return (W)zza2;
            }
            zza2 = this.zzg(zzrd2);
            this.Ex.put(c, (Object)zza2);
            return (W)zza2;
        }

        @Nullable
        W zzak(C c) {
            zza zza2 = (zza)this.Ex.remove(c);
            if (zza2 != null) {
                zza2.zzcbf().clear();
            }
            return (W)zza2;
        }

        protected abstract W zzg(zzrd<C> var1);
    }

    @TargetApi(value=14)
    private static class zzb
    implements Application.ActivityLifecycleCallbacks {
        private final Activity awA;
        private final zzr awB;

        private zzb(Activity activity, zzr zzr2) {
            this.awA = activity;
            this.awB = zzr2;
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
            if (activity == this.awA) {
                try {
                    this.awB.zzza(1);
                }
                catch (RemoteException remoteException) {
                    Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit ACTIVITY_STOPPED from ClientLifecycleSafetyNet for Activity %s: %s", new Object[]{activity.getPackageName(), remoteException}));
                }
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
            if (activity == this.awA) {
                Log.v((String)"NearbyMessagesClient", (String)String.format("Unregistering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
                activity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            }
        }
    }

    private static class zze
    extends zzl.zza {
        private final PublishCallback awE;

        private zze(PublishCallback publishCallback) {
            this.awE = publishCallback;
        }

        @Nullable
        private static zze zza(@Nullable PublishCallback publishCallback) {
            return publishCallback == null ? null : new zze(publishCallback);
        }

        @Override
        public void onExpired() {
            this.awE.onExpired();
        }
    }

    private static class zzg
    extends zzn.zza {
        private final SubscribeCallback awI;

        private zzg(SubscribeCallback subscribeCallback) {
            this.awI = subscribeCallback;
        }

        @Nullable
        private static zzg zza(@Nullable SubscribeCallback subscribeCallback) {
            return subscribeCallback == null ? null : new zzg(subscribeCallback);
        }

        @Override
        public void onExpired() {
            this.awI.onExpired();
        }
    }

    private static class zzf
    extends zzm.zza
    implements zza<StatusCallback> {
        private final zzrd<StatusCallback> awF;

        private zzf(zzrd<StatusCallback> zzrd2) {
            this.awF = zzrd2;
        }

        @Override
        public void onPermissionChanged(final boolean bl) {
            this.awF.zza((zzrd.zzc)new zzd<StatusCallback>(){

                public void zza(StatusCallback statusCallback) {
                    statusCallback.onPermissionChanged(bl);
                }

                public /* synthetic */ void zzt(Object object) {
                    this.zza((StatusCallback)object);
                }
            });
        }

        @Override
        public zzrd<StatusCallback> zzcbf() {
            return this.awF;
        }
    }

    private static class zzc
    extends zzi.zza
    implements zza<MessageListener> {
        private final zzrd<MessageListener> auG;

        private zzc(zzrd<MessageListener> zzrd2) {
            this.auG = zzrd2;
        }

        @Override
        public void zza(MessageWrapper messageWrapper) {
        }

        @Override
        public void zzb(MessageWrapper messageWrapper) {
        }

        @Override
        public void zzah(final List<Update> list) throws RemoteException {
            this.auG.zza((zzrd.zzc)new zzd<MessageListener>(){

                public void zza(MessageListener messageListener) {
                    zzs.zza(list, messageListener);
                }

                public /* synthetic */ void zzt(Object object) {
                    this.zza((MessageListener)object);
                }
            });
        }

        @Override
        public zzrd<MessageListener> zzcbf() {
            return this.auG;
        }
    }

    private static abstract class zzd<T>
    implements zzrd.zzc<T> {
        private zzd() {
        }

        public void zzarg() {
        }
    }

    private static interface zza<C> {
        public zzrd<C> zzcbf();
    }
}

