/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.nearby.messages.devices.NearbyDeviceFilter;
import com.google.android.gms.nearby.messages.internal.MessageType;
import com.google.android.gms.nearby.messages.zzb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class MessageFilter
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<MessageFilter> CREATOR = new zzb();
    public static final MessageFilter INCLUDE_ALL_MY_TYPES = new Builder().includeAllMyTypes().build();
    final int mVersionCode;
    private final List<MessageType> avz;
    private final List<NearbyDeviceFilter> avA;
    private final boolean avB;

    MessageFilter(int n, List<MessageType> list, List<NearbyDeviceFilter> list2, boolean bl) {
        this.mVersionCode = n;
        this.avz = Collections.unmodifiableList((List)zzac.zzy(list));
        this.avB = bl;
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        this.avA = Collections.unmodifiableList(list2);
    }

    private MessageFilter(List<MessageType> list, List<NearbyDeviceFilter> list2, boolean bl) {
        this(1, list, list2, bl);
    }

    List<MessageType> zzcay() {
        return this.avz;
    }

    boolean zzcaz() {
        return this.avB;
    }

    List<NearbyDeviceFilter> zzcba() {
        return this.avA;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public String toString() {
        boolean bl = this.avB;
        String string = String.valueOf(this.avz);
        return new StringBuilder(53 + String.valueOf(string).length()).append("MessageFilter{includeAllMyTypes=").append(bl).append(", messageTypes=").append(string).append("}").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageFilter)) {
            return false;
        }
        MessageFilter messageFilter = (MessageFilter)((Object)object);
        return this.avB == messageFilter.avB && zzab.equal(this.avz, messageFilter.avz) && zzab.equal(this.avA, messageFilter.avA);
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.avz, this.avA, this.avB});
    }

    public static final class Builder {
        private final List<MessageType> avC = new ArrayList<MessageType>();
        private final List<NearbyDeviceFilter> avA = new ArrayList<NearbyDeviceFilter>();
        private boolean avB;

        public Builder includeAllMyTypes() {
            this.avB = true;
            return this;
        }

        public Builder includeNamespacedType(String string, String string2) {
            zzac.zzb((string != null && !string.isEmpty() && !string.contains("*") ? 1 : 0) != 0, (String)"namespace(%s) cannot be null, empty or contain (*).", (Object[])new Object[]{string});
            zzac.zzb((string2 != null && !string2.contains("*") ? 1 : 0) != 0, (String)"type(%s) cannot be null or contain (*).", (Object[])new Object[]{string2});
            return this.zzbd(string, string2);
        }

        public Builder includeFilter(MessageFilter messageFilter) {
            this.avC.addAll(messageFilter.zzcay());
            this.avA.addAll(messageFilter.zzcba());
            this.avB |= messageFilter.zzcaz();
            return this;
        }

        public Builder includeEddystoneUids(String string, @Nullable String string2) {
            this.zzbd("__reserved_namespace", "__eddystone_uid");
            this.avA.add(NearbyDeviceFilter.zzbe(string, string2));
            return this;
        }

        public Builder includeIBeaconIds(UUID uUID, @Nullable Short s, @Nullable Short s2) {
            this.zzbd("__reserved_namespace", "__i_beacon_id");
            this.avA.add(NearbyDeviceFilter.zza(uUID, s, s2));
            return this;
        }

        private Builder zzbd(String string, String string2) {
            this.avC.add(new MessageType(string, string2));
            return this;
        }

        public MessageFilter build() {
            zzac.zza((this.avB || !this.avC.isEmpty() ? 1 : 0) != 0, (Object)"At least one of the include methods must be called.");
            return new MessageFilter(this.avC, this.avA, this.avB);
        }
    }
}

