/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.util.Log;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.MessengerCompat;
import com.google.android.gms.iid.zzc;
import com.google.android.gms.iid.zzd;

public class InstanceIDListenerService
extends Service {
    static String ACTION = "action";
    MessengerCompat afZ = new MessengerCompat(new Handler(Looper.getMainLooper()){

        public void handleMessage(Message message) {
            InstanceIDListenerService.this.zza(message, MessengerCompat.zzc((Message)message));
        }
    });
    BroadcastReceiver aga = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                String string = intent.getStringExtra("registration_id");
                String string2 = String.valueOf(intent.getExtras());
                Log.d((String)"InstanceID", (String)new StringBuilder(46 + String.valueOf(string2).length()).append("Received GSF callback using dynamic receiver: ").append(string2).toString());
            }
            InstanceIDListenerService.this.zzn(intent);
            InstanceIDListenerService.this.stop();
        }
    };
    private static String agb = "google.com/iid";
    private static String agc = "CMD";
    private static String aeK = "gcm.googleapis.com/refresh";
    int agd;
    int age;

    public void zzn(Intent intent) {
        Object object;
        String string = intent.getStringExtra("subtype");
        InstanceID instanceID = null;
        if (string == null) {
            instanceID = InstanceID.getInstance((Context)this);
        } else {
            object = new Bundle();
            object.putString("subtype", string);
            instanceID = InstanceID.zza((Context)this, object);
        }
        object = intent.getStringExtra(agc);
        if (null != intent.getStringExtra("error") || null != intent.getStringExtra("registration_id")) {
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                String string2 = String.valueOf(string);
                Log.d((String)"InstanceID", (String)(string2.length() != 0 ? "Register result in service ".concat(string2) : new String("Register result in service ")));
            }
            instanceID.zzbos().zzv(intent);
            return;
        }
        if (Log.isLoggable((String)"InstanceID", (int)3)) {
            String string3 = String.valueOf(intent.getExtras());
            Log.d((String)"InstanceID", (String)new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(object).length() + String.valueOf(string3).length()).append("Service command ").append(string).append(" ").append((String)object).append(" ").append(string3).toString());
        }
        if (null != intent.getStringExtra("unregistered")) {
            instanceID.zzbor().zzku(string == null ? "" : string);
            instanceID.zzbos().zzv(intent);
            return;
        }
        if (aeK.equals(intent.getStringExtra("from"))) {
            instanceID.zzbor().zzku(string);
            this.zzcb(false);
            return;
        }
        if ("RST".equals(object)) {
            instanceID.zzboq();
            this.zzcb(true);
        } else if ("RST_FULL".equals(object)) {
            if (!instanceID.zzbor().isEmpty()) {
                instanceID.zzbor().zzbow();
                this.zzcb(true);
            }
        } else if ("SYNC".equals(object)) {
            instanceID.zzbor().zzku(string);
            this.zzcb(false);
        } else if ("PING".equals(object)) {
            // empty if block
        }
    }

    static void zza(Context context, zzd zzd2) {
        zzd2.zzbow();
        Intent intent = new Intent("com.google.android.gms.iid.InstanceID");
        intent.putExtra(agc, "RST");
        intent.setPackage(context.getPackageName());
        context.startService(intent);
    }

    static void zzdi(Context context) {
        Intent intent = new Intent("com.google.android.gms.iid.InstanceID");
        intent.setPackage(context.getPackageName());
        intent.putExtra(agc, "SYNC");
        context.startService(intent);
    }

    private void zza(Message message, int n) {
        zzc.zzdj((Context)this);
        PackageManager packageManager = this.getPackageManager();
        if (n != zzc.agl && n != zzc.agk) {
            int n2 = zzc.agk;
            int n3 = zzc.agl;
            Log.w((String)"InstanceID", (String)new StringBuilder(77).append("Message from unexpected caller ").append(n).append(" mine=").append(n2).append(" appid=").append(n3).toString());
            return;
        }
        this.zzn((Intent)message.obj);
    }

    public void onCreate() {
        IntentFilter intentFilter = new IntentFilter("com.google.android.c2dm.intent.REGISTRATION");
        intentFilter.addCategory(this.getPackageName());
        this.registerReceiver(this.aga, intentFilter, "com.google.android.c2dm.permission.RECEIVE", null);
    }

    public void onDestroy() {
        this.unregisterReceiver(this.aga);
    }

    public IBinder onBind(Intent intent) {
        if (intent != null && "com.google.android.gms.iid.InstanceID".equals(intent.getAction())) {
            return this.afZ.getBinder();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        InstanceIDListenerService instanceIDListenerService = this;
        synchronized (instanceIDListenerService) {
            --this.agd;
            if (this.agd == 0) {
                this.stopSelf(this.age);
            }
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                int n = this.agd;
                int n2 = this.age;
                Log.d((String)"InstanceID", (String)new StringBuilder(28).append("Stop ").append(n).append(" ").append(n2).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zztt(int n) {
        InstanceIDListenerService instanceIDListenerService = this;
        synchronized (instanceIDListenerService) {
            ++this.agd;
            if (n > this.age) {
                this.age = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onStartCommand(Intent intent, int n, int n2) {
        this.zztt(n2);
        if (intent == null) {
            this.stop();
            return 2;
        }
        try {
            String string = intent.getAction();
            if ("com.google.android.gms.iid.InstanceID".equals(string)) {
                Intent intent2;
                if (Build.VERSION.SDK_INT <= 18 && (intent2 = (Intent)intent.getParcelableExtra("GSF")) != null) {
                    this.startService(intent2);
                    boolean bl = true;
                    return 1;
                }
                this.zzn(intent);
            }
        }
        finally {
            this.stop();
        }
        if (intent.getStringExtra("from") != null) {
            WakefulBroadcastReceiver.completeWakefulIntent((Intent)intent);
        }
        return 2;
    }

    public void zzcb(boolean bl) {
        this.onTokenRefresh();
    }

    public void onTokenRefresh() {
    }
}

