/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Looper;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.iid.zzc;
import com.google.android.gms.iid.zzd;
import java.io.IOException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class InstanceID {
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_TIMEOUT = "TIMEOUT";
    public static final String ERROR_MISSING_INSTANCEID_SERVICE = "MISSING_INSTANCEID_SERVICE";
    public static final String ERROR_BACKOFF = "RETRY_LATER";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    static Map<String, InstanceID> afS = new HashMap<String, InstanceID>();
    Context mContext;
    private static zzd afT;
    private static zzc afU;
    KeyPair afV;
    String afW = "";
    long afX;
    static String afY;

    protected InstanceID(Context context, String string, Bundle bundle) {
        this.mContext = context.getApplicationContext();
        this.afW = string;
    }

    static int zzdg(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"InstanceID", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return 0;
        }
    }

    static String zzdh(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"InstanceID", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return null;
        }
    }

    public static InstanceID getInstance(Context context) {
        return InstanceID.zza(context, null);
    }

    public static synchronized InstanceID zza(Context context, Bundle bundle) {
        String string;
        String string2 = string = bundle == null ? "" : bundle.getString("subtype");
        if (string == null) {
            string = "";
        }
        context = context.getApplicationContext();
        if (afT == null) {
            afT = new zzd(context);
            afU = new zzc(context);
        }
        afY = Integer.toString(InstanceID.zzdg(context));
        InstanceID instanceID = afS.get(string);
        if (instanceID == null) {
            instanceID = new InstanceID(context, string, bundle);
            afS.put(string, instanceID);
        }
        return instanceID;
    }

    static String zzu(byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)11);
    }

    KeyPair zzbop() {
        if (this.afV == null) {
            this.afV = afT.zzks(this.afW);
        }
        if (this.afV == null) {
            this.afX = System.currentTimeMillis();
            this.afV = afT.zze(this.afW, this.afX);
        }
        return this.afV;
    }

    public String getId() {
        return InstanceID.zza(this.zzbop());
    }

    static String zza(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] byArray2 = messageDigest.digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)(n & 0xFF);
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"InstanceID", (String)"Unexpected error, device missing required alghorithms");
            return null;
        }
    }

    public long getCreationTime() {
        String string;
        if (this.afX == 0L && (string = afT.get(this.afW, "cre")) != null) {
            this.afX = Long.parseLong(string);
        }
        return this.afX;
    }

    public void deleteInstanceID() throws IOException {
        this.zzb("*", "*", null);
        this.zzboq();
    }

    public void zzboq() {
        this.afX = 0L;
        afT.zzkt(this.afW);
        this.afV = null;
    }

    public void deleteToken(String string, String string2) throws IOException {
        this.zzb(string, string2, null);
    }

    public void zzb(String string, String string2, Bundle bundle) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        afT.zzi(this.afW, string, string2);
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("sender", string);
        if (string2 != null) {
            bundle.putString("scope", string2);
        }
        bundle.putString("subscription", string);
        bundle.putString("delete", "1");
        bundle.putString("X-delete", "1");
        bundle.putString("subtype", "".equals(this.afW) ? string : this.afW);
        bundle.putString("X-subtype", "".equals(this.afW) ? string : this.afW);
        Intent intent = afU.zza(bundle, this.zzbop());
        afU.zzt(intent);
    }

    public zzd zzbor() {
        return afT;
    }

    public zzc zzbos() {
        return afU;
    }

    public String getToken(String string, String string2) throws IOException {
        return this.getToken(string, string2, null);
    }

    public String getToken(String string, String string2, Bundle bundle) throws IOException {
        String string3;
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        boolean bl = true;
        String string4 = string3 = this.zzbot() ? null : afT.zzh(this.afW, string, string2);
        if (string3 != null) {
            return string3;
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (bundle.getString("ttl") != null) {
            bl = false;
        }
        if ("jwt".equals(bundle.getString("type"))) {
            bl = false;
        }
        if ((string3 = this.zzc(string, string2, bundle)) != null && bl) {
            afT.zza(this.afW, string, string2, string3, afY);
        }
        return string3;
    }

    public String zzc(String string, String string2, Bundle bundle) throws IOException {
        String string3;
        if (string2 != null) {
            bundle.putString("scope", string2);
        }
        bundle.putString("sender", string);
        String string4 = string3 = "".equals(this.afW) ? string : this.afW;
        if (!bundle.containsKey("legacy.register")) {
            bundle.putString("subscription", string);
            bundle.putString("subtype", string3);
            bundle.putString("X-subscription", string);
            bundle.putString("X-subtype", string3);
        }
        Intent intent = afU.zza(bundle, this.zzbop());
        return afU.zzt(intent);
    }

    boolean zzbot() {
        String string = afT.get("appVersion");
        if (string == null || !string.equals(afY)) {
            return true;
        }
        String string2 = afT.get("lastToken");
        if (string2 == null) {
            return true;
        }
        Long l = Long.parseLong(string2);
        return System.currentTimeMillis() / 1000L - l > 604800L;
    }
}

