/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.internal.zzwp;
import com.google.android.gms.internal.zzwq;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class zzws {
    private static final String TAG = zzws.class.getSimpleName();
    private static final char[] azx = "0123456789ABCDEF".toCharArray();
    private static final Pattern azy = Pattern.compile("/\\.\\.");
    private static final Pattern azz = Pattern.compile("0[1-7][0-7]*");
    private static final Pattern azA = Pattern.compile("0x[0-9a-f]*", 2);
    private static final Pattern azB = Pattern.compile("^((?:0x[0-9a-f]+|[0-9\\\\.])+)$", 2);
    private final String zzae;
    private final String azC;
    private final String azD;
    private final int azE;
    private final String mPath;
    private final String zzapl;

    public zzws(String string) {
        String string2;
        String string3;
        if (!zzws.zzoj(string)) {
            this.zzae = null;
            this.azC = null;
            this.azD = null;
            this.azE = -1;
            this.mPath = null;
            this.zzapl = null;
            return;
        }
        string = string.replaceAll("^\\s+", "").replaceAll("\\s+$", "");
        int n = (string = string.replaceAll("[\\t\\n\\r]", "")).indexOf(35);
        zza zza2 = new zza(string = n != -1 ? string.substring(0, n) : string);
        if (!zza2.zzccu()) {
            this.zzae = null;
            this.azC = null;
            this.azD = null;
            this.azE = -1;
            this.mPath = null;
            this.zzapl = null;
            return;
        }
        this.azC = zza2.getScheme();
        this.azE = zza2.getPort();
        if (this.azC != null) {
            string3 = this.azC;
            string = string.replaceAll(new StringBuilder(2 + String.valueOf(string3).length()).append("^").append(string3).append(":").toString(), "");
        }
        string = string.replaceAll("^/+", "");
        string = zzws.zzol(string);
        string3 = null;
        int n2 = string.indexOf(63);
        if (n2 != -1) {
            int n3 = n2 + 1;
            string3 = n3 < string.length() ? string.substring(n3) : "";
            string = string.substring(0, n2);
        }
        if (TextUtils.isEmpty((CharSequence)(string2 = this.zzof(string)))) {
            this.zzae = null;
            this.azD = null;
            this.mPath = null;
            this.zzapl = null;
            return;
        }
        String string4 = this.zzoi(string);
        this.azD = zzws.zzok(string2);
        this.mPath = zzws.zzok(string4);
        this.zzapl = !TextUtils.isEmpty((CharSequence)string3) ? zzws.zzok(string3) : string3;
        this.zzae = string;
    }

    private String zzof(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = string;
        int n = string2.indexOf(47);
        string2 = n != -1 ? string2.substring(0, n) : string2;
        int n2 = string2.indexOf(64);
        String string3 = string2 = n2 != -1 ? string2.substring(n2 + 1) : string2;
        if (this.azE != -1) {
            int n3 = this.azE;
            string2 = string2.replaceAll(new StringBuilder(13).append(":").append(n3).append("$").toString(), "");
        }
        string2 = string2.replaceAll("^\\.*", "").replaceAll("\\.*$", "");
        String string4 = zzws.zzog(string2 = string2.replaceAll("\\.+", "."));
        if (string4 != null) {
            string2 = string4;
        }
        return string2.toLowerCase(Locale.getDefault());
    }

    private static String zzog(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = string.replaceAll("^\\[", "").replaceAll("\\]$", "");
        if (zzwq.zznx(string2)) {
            InetAddress inetAddress = zzwq.zzoe(string2);
            String string3 = zzwq.zza(inetAddress);
            return string3.contains(":") ? String.format("[%s]", string3) : string3;
        }
        if (TextUtils.isDigitsOnly((CharSequence)string)) {
            String string4 = zzws.zzoh(string);
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                return string4;
            }
        } else if (azB.matcher(string2).find()) {
            int n;
            Matcher matcher = azz.matcher(string2);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                n = Integer.parseInt(matcher.group(), 8);
                matcher.appendReplacement(stringBuffer, new StringBuilder(11).append(n).toString());
            }
            matcher.appendTail(stringBuffer);
            matcher = azA.matcher(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            while (matcher.find()) {
                n = Integer.parseInt(matcher.group().substring(2), 16);
                matcher.appendReplacement(stringBuffer, new StringBuilder(11).append(n).toString());
            }
            matcher.appendTail(stringBuffer);
            String string5 = stringBuffer.toString();
            return string5.contains(":") ? String.format("[%s]", string5) : string5;
        }
        return null;
    }

    private static String zzoh(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            byte[] byArray;
            BigInteger bigInteger = new BigInteger(string);
            byte[] byArray2 = bigInteger.toByteArray();
            if (byArray2.length < 4) {
                return null;
            }
            byte[] byArray3 = Arrays.copyOfRange(byArray2, byArray2.length - 4, byArray2.length);
            byte[] byArray4 = new byte[]{0, byArray3[0], byArray3[1], byArray3[2], byArray3[3]};
            BigInteger bigInteger2 = new BigInteger(byArray4);
            if (bigInteger.equals(bigInteger2)) {
                return Inet4Address.getByAddress(byArray3).getHostAddress();
            }
            if (byArray2.length >= 16) {
                byArray = Arrays.copyOfRange(byArray2, byArray2.length - 16, byArray2.length);
            } else {
                int n;
                byte[] byArray5 = new byte[16];
                int n2 = 0;
                int n3 = 16 - byArray2.length;
                for (n = 1; n <= n3; ++n) {
                    byArray5[n2++] = 0;
                }
                for (n = 0; n < byArray2.length; ++n) {
                    byArray5[n2++] = byArray2[n];
                }
                byArray = byArray5;
            }
            return String.format("[%s]", Inet6Address.getByAddress(byArray).getHostAddress());
        }
        catch (NumberFormatException numberFormatException) {
            zzws.zza(numberFormatException);
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            zzws.zza(arrayIndexOutOfBoundsException);
            return null;
        }
        catch (UnknownHostException unknownHostException) {
            zzws.zza(unknownHostException);
            return null;
        }
    }

    private String zzoi(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.indexOf(47);
        String string2 = n != -1 ? string.substring(n) : "/";
        string2 = string2.replaceAll("/\\./", "/");
        if (azy.matcher(string2 = string2.replaceAll("/\\.$", "/")).find()) {
            try {
                URI uRI = new URI(this.azC, "host", string2, null);
                string2 = uRI.normalize().getRawPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        string2 = string2.replaceAll("/+", "/");
        return string2;
    }

    public List<String> zzccp() {
        List<String> list;
        if (TextUtils.isEmpty((CharSequence)this.zzae)) {
            return null;
        }
        String string = zzws.zzog(this.azD);
        if (string != null) {
            list = new ArrayList<String>();
            list.add(string);
        } else {
            list = this.zzccr();
        }
        if (list == null || list.isEmpty()) {
            return null;
        }
        List<String> list2 = this.zzccs();
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : list) {
            for (String string3 : list2) {
                String string4 = String.valueOf(string2);
                String string5 = String.valueOf(string3);
                linkedList.add(string5.length() != 0 ? string4.concat(string5) : new String(string4));
            }
        }
        return !linkedList.isEmpty() ? linkedList : null;
    }

    public List<zzwp> zzccq() {
        List<String> list = this.zzccp();
        if (list == null || list.isEmpty()) {
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            zzws.zza(noSuchAlgorithmException);
        }
        if (messageDigest == null) {
            return null;
        }
        ArrayList<zzwp> arrayList = new ArrayList<zzwp>(list.size());
        for (String string : list) {
            if (TextUtils.isEmpty((CharSequence)string)) continue;
            try {
                byte[] byArray = messageDigest.digest(string.getBytes("UTF-8"));
                arrayList.add(new zzwp(byArray));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                zzws.zza(unsupportedEncodingException);
            }
            messageDigest.reset();
        }
        return !arrayList.isEmpty() ? arrayList : null;
    }

    private List<String> zzccr() {
        if (TextUtils.isEmpty((CharSequence)this.azD)) {
            return null;
        }
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = this.azD.toCharArray();
        for (int i = cArray.length - 2; i > 0 && arrayList.size() < 4; --i) {
            if (cArray[i] != '.') continue;
            if (bl) {
                arrayList.add(this.azD.substring(i + 1));
                continue;
            }
            bl = true;
        }
        arrayList.add(this.azD);
        return arrayList;
    }

    private List<String> zzccs() {
        if (TextUtils.isEmpty((CharSequence)this.mPath)) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = this.mPath.toCharArray();
        for (int i = 0; i < cArray.length && arrayList.size() < 4; ++i) {
            if (cArray[i] != '/') continue;
            arrayList.add(this.mPath.substring(0, i + 1));
        }
        if (!arrayList.isEmpty() && !((String)arrayList.get(arrayList.size() - 1)).equals(this.mPath)) {
            arrayList.add(this.mPath);
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzapl)) {
            String string = this.mPath;
            String string2 = this.zzapl;
            arrayList.add(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?").append(string2).toString());
        }
        return arrayList;
    }

    private static boolean zzoj(String string) {
        return !TextUtils.isEmpty((CharSequence)string);
    }

    private static String zzok(String string) {
        byte[] byArray;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            char c = (char)(byArray[i] & 0xFF);
            if (c <= ' ' || c > '~' || c == '#' || c == '%') {
                stringBuilder.append("%");
                stringBuilder.append(azx[c >>> 4]);
                stringBuilder.append(azx[c & 0xF]);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static String zzol(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = string;
        String string3 = null;
        int n = 1024;
        for (int i = 0; !string2.equals(string3) && i < 1024; ++i) {
            string3 = string2;
            string2 = zzws.zzom(string3);
        }
        return string2;
    }

    private static String zzom(String string) {
        byte[] byArray;
        Object object;
        try {
            object = string.replace("\\x", "%");
            byArray = ((String)object).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        object = new ByteArrayOutputStream(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            char c = (char)(by & 0xFF);
            if (c >= '\u0080') {
                ((ByteArrayOutputStream)object).write(by);
                continue;
            }
            Byte by2 = zzws.zzc(byArray, i);
            if (by2 != null) {
                ((ByteArrayOutputStream)object).write(by2.byteValue());
                i += 2;
                continue;
            }
            ((ByteArrayOutputStream)object).write(by);
        }
        try {
            return new String(((ByteArrayOutputStream)object).toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private static Byte zzc(byte[] byArray, int n) {
        if (n + 2 >= byArray.length) {
            return null;
        }
        char c = (char)(byArray[n] & 0xFF);
        if (c != '%') {
            return null;
        }
        char c2 = (char)(byArray[n + 1] & 0xFF);
        char c3 = (char)(byArray[n + 2] & 0xFF);
        if (zzws.isHexDigit(c2) && zzws.isHexDigit(c3)) {
            byte by = (byte)(Integer.parseInt(new StringBuilder(1).append(c2).toString(), 16) * 16 + Integer.parseInt(new StringBuilder(1).append(c3).toString(), 16));
            return by;
        }
        return null;
    }

    private static final void zza(Exception exception) {
    }

    private static class zza {
        private static final String[] azF = new String[]{"http", "https", "ftp"};
        private final String ef;
        private final Uri azG;
        private final URI azH;
        private final String azC;
        private final Boolean azI;
        private final Integer azJ;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private zza(String string) {
            this.ef = string;
            this.azG = Uri.parse((String)this.ef);
            try {
                URI uRI = new URI(this.ef);
            }
            catch (URISyntaxException uRISyntaxException) {
                Object var2_3 = null;
            }
            finally {
                this.azH = null;
            }
            this.azC = this.getScheme();
            this.azI = this.zzccu();
            this.azJ = this.zzcct();
        }

        private String getScheme() {
            if (this.azC != null) {
                return this.azC;
            }
            String string = null;
            if (this.azG != null) {
                string = this.azG.getScheme();
            }
            if (TextUtils.isEmpty(string)) {
            }
            if (TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)this.ef)) {
                String string2;
                int n = this.ef.indexOf(":");
                if (n != -1 && zza.zzon(string2 = this.ef.substring(0, n).toLowerCase(Locale.US))) {
                    string = string2;
                }
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = this.ef.startsWith("www.") ? "http" : "http";
                }
            }
            return string != null ? string.toLowerCase(Locale.US) : null;
        }

        private int getPort() {
            return this.azJ;
        }

        private int zzcct() {
            if (this.azJ != null) {
                return this.azJ;
            }
            int n = -1;
            if (this.azG != null && (n = this.azG.getPort()) != -1) {
                return n;
            }
            return -1;
        }

        private boolean zzccu() {
            if (this.azI != null) {
                return this.azI;
            }
            return zza.zzon(this.azC);
        }

        private static boolean zzon(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return false;
            }
            for (int i = 0; i < azF.length; ++i) {
                if (!azF[i].equals(string)) continue;
                return true;
            }
            return false;
        }
    }
}

