/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.SparseArray;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzwi;
import com.google.android.gms.internal.zzwj;
import com.google.android.gms.internal.zzwk;
import com.google.android.gms.internal.zzwn;
import com.google.android.gms.internal.zzwp;
import com.google.android.gms.internal.zzwr;
import com.google.android.gms.internal.zzws;
import com.google.android.gms.internal.zzwt;
import com.google.android.gms.safetynet.AttestationData;
import com.google.android.gms.safetynet.HarmfulAppsData;
import com.google.android.gms.safetynet.SafeBrowsingData;
import com.google.android.gms.safetynet.SafeBrowsingThreat;
import com.google.android.gms.safetynet.SafetyNetApi;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzwm
implements SafetyNetApi {
    private static final String TAG = zzwm.class.getSimpleName();
    protected static SparseArray<zzwr> azd;
    protected static long aze;

    @Override
    public PendingResult<SafetyNetApi.AttestationResult> attest(GoogleApiClient googleApiClient, final byte[] byArray) {
        return googleApiClient.zzc((zzqc.zza)new zzb(googleApiClient){

            protected void zza(zzwn zzwn2) throws RemoteException {
                zzwn2.zza(this.azm, byArray);
            }
        });
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, List<Integer> list, String string) {
        return this.zza(googleApiClient, list, string, null);
    }

    public PendingResult<SafetyNetApi.SafeBrowsingResult> zza(GoogleApiClient googleApiClient, final List<Integer> list, final String string, final String string2) {
        if (list == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient.zzc((zzqc.zza)new zze(googleApiClient){

            protected void zza(zzwn zzwn2) throws RemoteException {
                zzwn2.zza(this.azm, list, 2, string, string2);
            }
        });
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, final String string, final int ... nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient.zzc((zzqc.zza)new zze(googleApiClient){

            protected void zza(zzwn zzwn2) throws RemoteException {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int n : nArray) {
                    arrayList.add(n);
                }
                zzwn2.zza(this.azm, arrayList, 1, string, null);
            }
        });
    }

    @Override
    public boolean lookupUriInLocalBlacklist(String string, int ... nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        if (azd == null || aze == 0L || SystemClock.elapsedRealtime() - aze >= 1200000L) {
            return true;
        }
        if (azd != null && azd.size() != 0) {
            List<zzwp> list = new zzws(string).zzccq();
            if (list == null || list.isEmpty()) {
                return true;
            }
            for (zzwp zzwp2 : list) {
                for (int n : nArray) {
                    zzwr zzwr2 = (zzwr)azd.get(n);
                    if (zzwr2 != null) {
                        if (!zzwr2.zzag(zzwp2.zzaab(4).getBytes())) continue;
                        return true;
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isVerifyAppsEnabled(Context context) {
        return new zzwt(context).zzccv();
    }

    @Override
    public PendingResult<SafetyNetApi.zzb> enableVerifyApps(GoogleApiClient googleApiClient) {
        return googleApiClient.zzc((zzqc.zza)new zzc(googleApiClient){

            protected void zza(zzwn zzwn2) throws RemoteException {
                zzwn2.zzb(this.azm);
            }
        });
    }

    @Override
    public PendingResult<SafetyNetApi.zza> listHarmfulApps(GoogleApiClient googleApiClient) {
        return googleApiClient.zzc((zzqc.zza)new zzd(googleApiClient){

            protected void zza(zzwn zzwn2) throws RemoteException {
                zzwn2.zzc(this.azm);
            }
        });
    }

    static abstract class zzd
    extends zzwj<SafetyNetApi.zza> {
        protected final zzwk azm = new zzwi(){

            @Override
            public void zza(Status status, List<HarmfulAppsData> list) {
                zzd.this.zzc(new zzf(status, list));
            }
        };

        public zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.zza zzdz(Status status) {
            return new zzf(status, new ArrayList<HarmfulAppsData>());
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzdz(status);
        }
    }

    static class zzf
    implements SafetyNetApi.zza {
        private final Status fp;
        private final List<HarmfulAppsData> azr;

        public zzf(Status status, List<HarmfulAppsData> list) {
            this.fp = status;
            this.azr = list;
        }

        public Status getStatus() {
            return this.fp;
        }
    }

    static abstract class zzc
    extends zzwj<SafetyNetApi.zzb> {
        protected zzwk azm = new zzwi(){

            @Override
            public void zzb(Status status, boolean bl) {
                zzc.this.zzc(new zzh(status, bl));
            }
        };

        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.zzb zzdy(Status status) {
            return new zzh(status, false);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzdy(status);
        }
    }

    static class zzh
    implements SafetyNetApi.zzb {
        private final Status fp;
        private final boolean zzctg;

        public zzh(Status status, boolean bl) {
            this.fp = status;
            this.zzctg = bl;
        }

        public Status getStatus() {
            return this.fp;
        }
    }

    static class zzg
    implements SafetyNetApi.SafeBrowsingResult {
        private Status fp;
        private final SafeBrowsingData azs;
        private String ayZ;

        public zzg(Status status, SafeBrowsingData safeBrowsingData) {
            this.fp = status;
            this.azs = safeBrowsingData;
            this.ayZ = null;
            if (this.azs != null) {
                this.ayZ = this.azs.getMetadata();
            } else if (this.fp.isSuccess()) {
                this.fp = new Status(8);
            }
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public String getMetadata() {
            return this.ayZ;
        }

        @Override
        public List<SafeBrowsingThreat> getDetectedThreats() {
            ArrayList<SafeBrowsingThreat> arrayList = new ArrayList<SafeBrowsingThreat>();
            if (this.ayZ == null) {
                return arrayList;
            }
            JSONArray jSONArray = null;
            try {
                JSONObject jSONObject = new JSONObject(this.ayZ);
                jSONArray = jSONObject.getJSONArray("matches");
            }
            catch (JSONException jSONException) {
                return arrayList;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    JSONObject jSONObject = jSONArray.getJSONObject(i);
                    int n = Integer.parseInt(jSONObject.getString("threat_type"));
                    SafeBrowsingThreat safeBrowsingThreat = new SafeBrowsingThreat(n);
                    arrayList.add(safeBrowsingThreat);
                    continue;
                }
                catch (JSONException jSONException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return arrayList;
        }
    }

    static abstract class zze
    extends zzwj<SafetyNetApi.SafeBrowsingResult> {
        protected zzwk azm = new zzwi(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zza(Status status, SafeBrowsingData safeBrowsingData) {
                DataHolder dataHolder = safeBrowsingData.getBlacklistsDataHolder();
                if (dataHolder != null) {
                    try {
                        int n = dataHolder.getCount();
                        if (n != 0) {
                            if (azd != null) {
                                azd.clear();
                            }
                            azd = new SparseArray();
                            for (int i = 0; i < n; ++i) {
                                zzwr zzwr2 = new zzwr(dataHolder, i);
                                azd.put(zzwr2.getThreatType(), (Object)zzwr2);
                            }
                            aze = SystemClock.elapsedRealtime();
                        }
                    }
                    finally {
                        if (!dataHolder.isClosed()) {
                            dataHolder.close();
                        }
                    }
                }
                zze.this.zzc(new zzg(status, safeBrowsingData));
            }
        };

        public zze(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.SafeBrowsingResult zzea(Status status) {
            return new zzg(status, null);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzea(status);
        }
    }

    static class zza
    implements SafetyNetApi.AttestationResult {
        private final Status fp;
        private final AttestationData azl;

        public zza(Status status, AttestationData attestationData) {
            this.fp = status;
            this.azl = attestationData;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public String getJwsResult() {
            if (this.azl == null) {
                return null;
            }
            return this.azl.getJwsResult();
        }
    }

    static abstract class zzb
    extends zzwj<SafetyNetApi.AttestationResult> {
        protected zzwk azm = new zzwi(){

            @Override
            public void zza(Status status, AttestationData attestationData) {
                zzb.this.zzc(new zza(status, attestationData));
            }
        };

        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.AttestationResult zzdx(Status status) {
            return new zza(status, null);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzdx(status);
        }
    }
}

