/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.IntentFilter;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.zzb;
import com.google.android.gms.wearable.internal.zzbn;
import com.google.android.gms.wearable.internal.zzbp;
import com.google.android.gms.wearable.internal.zzi;
import java.io.IOException;
import java.io.InputStream;

public final class zzx
implements DataApi {
    @Override
    public PendingResult<DataApi.DataItemResult> putDataItem(GoogleApiClient googleApiClient, final PutDataRequest putDataRequest) {
        return googleApiClient.zzc((zzqc.zza)new zzi<DataApi.DataItemResult>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zza((zzqc.zzb<DataApi.DataItemResult>)this, putDataRequest);
            }

            public DataApi.DataItemResult zzeo(Status status) {
                return new zza(status, null);
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzeo(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.DataItemResult> getDataItem(GoogleApiClient googleApiClient, final Uri uri) {
        return googleApiClient.zzc((zzqc.zza)new zzi<DataApi.DataItemResult>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zza((zzqc.zzb<DataApi.DataItemResult>)this, uri);
            }

            protected DataApi.DataItemResult zzeo(Status status) {
                return new zza(status, null);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzeo(status);
            }
        });
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient googleApiClient) {
        return googleApiClient.zzc((zzqc.zza)new zzi<DataItemBuffer>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zzx((zzqc.zzb<DataItemBuffer>)this);
            }

            protected DataItemBuffer zzep(Status status) {
                return new DataItemBuffer(DataHolder.zzgc((int)status.getStatusCode()));
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzep(status);
            }
        });
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient googleApiClient, Uri uri) {
        return this.getDataItems(googleApiClient, uri, 0);
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient googleApiClient, final Uri uri, final int n) {
        zzac.zzb((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        zzac.zzb((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"invalid filter type");
        return googleApiClient.zzc((zzqc.zza)new zzi<DataItemBuffer>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zza((zzqc.zzb<DataItemBuffer>)this, uri, n);
            }

            protected DataItemBuffer zzep(Status status) {
                return new DataItemBuffer(DataHolder.zzgc((int)status.getStatusCode()));
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzep(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.DeleteDataItemsResult> deleteDataItems(GoogleApiClient googleApiClient, Uri uri) {
        return this.deleteDataItems(googleApiClient, uri, 0);
    }

    @Override
    public PendingResult<DataApi.DeleteDataItemsResult> deleteDataItems(GoogleApiClient googleApiClient, final Uri uri, final int n) {
        zzac.zzb((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        zzac.zzb((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"invalid filter type");
        return googleApiClient.zzc((zzqc.zza)new zzi<DataApi.DeleteDataItemsResult>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zzb((zzqc.zzb<DataApi.DeleteDataItemsResult>)this, uri, n);
            }

            protected DataApi.DeleteDataItemsResult zzeq(Status status) {
                return new zzb(status, 0);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzeq(status);
            }
        });
    }

    private void zza(Asset asset) {
        if (asset == null) {
            throw new IllegalArgumentException("asset is null");
        }
        if (asset.getDigest() == null) {
            throw new IllegalArgumentException("invalid asset");
        }
        if (asset.getData() != null) {
            throw new IllegalArgumentException("invalid asset");
        }
    }

    @Override
    public PendingResult<DataApi.GetFdForAssetResult> getFdForAsset(GoogleApiClient googleApiClient, final Asset asset) {
        this.zza(asset);
        return googleApiClient.zzc((zzqc.zza)new zzi<DataApi.GetFdForAssetResult>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zza((zzqc.zzb<DataApi.GetFdForAssetResult>)this, asset);
            }

            protected DataApi.GetFdForAssetResult zzer(Status status) {
                return new zzc(status, null);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzer(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.GetFdForAssetResult> getFdForAsset(GoogleApiClient googleApiClient, final DataItemAsset dataItemAsset) {
        return googleApiClient.zzc((zzqc.zza)new zzi<DataApi.GetFdForAssetResult>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zza((zzqc.zzb<DataApi.GetFdForAssetResult>)this, dataItemAsset);
            }

            protected DataApi.GetFdForAssetResult zzer(Status status) {
                return new zzc(status, null);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzer(status);
            }
        });
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient googleApiClient, DataApi.DataListener dataListener) {
        IntentFilter[] intentFilterArray = new IntentFilter[]{zzbn.zzrq("com.google.android.gms.wearable.DATA_CHANGED")};
        return this.zza(googleApiClient, dataListener, intentFilterArray);
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient googleApiClient, DataApi.DataListener dataListener, Uri uri, int n) {
        zzac.zzb((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        zzac.zzb((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"invalid filter type");
        IntentFilter intentFilter = zzbn.zza("com.google.android.gms.wearable.DATA_CHANGED", uri, n);
        return this.zza(googleApiClient, dataListener, new IntentFilter[]{intentFilter});
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, DataApi.DataListener dataListener, IntentFilter[] intentFilterArray) {
        return com.google.android.gms.wearable.internal.zzb.zza(googleApiClient, zzx.zza(intentFilterArray), dataListener);
    }

    private static zzb.zza<DataApi.DataListener> zza(final IntentFilter[] intentFilterArray) {
        return new zzb.zza<DataApi.DataListener>(){

            @Override
            public void zza(zzbp zzbp2, zzqc.zzb<Status> zzb2, DataApi.DataListener dataListener, zzrd<DataApi.DataListener> zzrd2) throws RemoteException {
                zzbp2.zza(zzb2, dataListener, zzrd2, intentFilterArray);
            }
        };
    }

    @Override
    public PendingResult<Status> removeListener(GoogleApiClient googleApiClient, final DataApi.DataListener dataListener) {
        return googleApiClient.zzc((zzqc.zza)new zzi<Status>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zza((zzqc.zzb<Status>)this, dataListener);
            }

            public Status zzb(Status status) {
                return status;
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    public static class zzc
    implements DataApi.GetFdForAssetResult {
        private final Status fp;
        private volatile ParcelFileDescriptor aQy;
        private volatile InputStream aQi;
        private volatile boolean mClosed = false;

        public zzc(Status status, ParcelFileDescriptor parcelFileDescriptor) {
            this.fp = status;
            this.aQy = parcelFileDescriptor;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public ParcelFileDescriptor getFd() {
            if (this.mClosed) {
                throw new IllegalStateException("Cannot access the file descriptor after release().");
            }
            return this.aQy;
        }

        @Override
        public InputStream getInputStream() {
            if (this.mClosed) {
                throw new IllegalStateException("Cannot access the input stream after release().");
            }
            if (this.aQy == null) {
                return null;
            }
            if (this.aQi == null) {
                this.aQi = new ParcelFileDescriptor.AutoCloseInputStream(this.aQy);
            }
            return this.aQi;
        }

        public void release() {
            if (this.aQy == null) {
                return;
            }
            if (this.mClosed) {
                throw new IllegalStateException("releasing an already released result.");
            }
            try {
                if (this.aQi != null) {
                    this.aQi.close();
                } else {
                    this.aQy.close();
                }
                this.mClosed = true;
                this.aQy = null;
                this.aQi = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class zzb
    implements DataApi.DeleteDataItemsResult {
        private final Status fp;
        private final int aQx;

        public zzb(Status status, int n) {
            this.fp = status;
            this.aQx = n;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public int getNumDeleted() {
            return this.aQx;
        }
    }

    public static class zza
    implements DataApi.DataItemResult {
        private final Status fp;
        private final DataItem aQw;

        public zza(Status status, DataItem dataItem) {
            this.fp = status;
            this.aQw = dataItem;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public DataItem getDataItem() {
            return this.aQw;
        }
    }
}

