/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.IntentFilter;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.internal.zzb;
import com.google.android.gms.wearable.internal.zzbn;
import com.google.android.gms.wearable.internal.zzbp;
import com.google.android.gms.wearable.internal.zzi;
import com.google.android.gms.wearable.internal.zzl;
import com.google.android.gms.wearable.internal.zzo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ChannelImpl
extends AbstractSafeParcelable
implements Channel {
    public static final Parcelable.Creator<ChannelImpl> CREATOR = new zzo();
    final int mVersionCode;
    private final String fG;
    private final String aOY;
    private final String mPath;

    ChannelImpl(int n, String string, String string2, String string3) {
        this.mVersionCode = n;
        this.fG = (String)zzac.zzy((Object)string);
        this.aOY = (String)zzac.zzy((Object)string2);
        this.mPath = (String)zzac.zzy((Object)string3);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzo.zza(this, parcel, n);
    }

    public String toString() {
        int n = this.mVersionCode;
        String string = this.fG;
        String string2 = this.aOY;
        String string3 = this.mPath;
        return new StringBuilder(66 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("ChannelImpl{versionCode=").append(n).append(", token='").append(string).append("'").append(", nodeId='").append(string2).append("'").append(", path='").append(string3).append("'").append("}").toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ChannelImpl)) {
            return false;
        }
        ChannelImpl channelImpl = (ChannelImpl)object;
        return this.fG.equals(channelImpl.fG) && zzab.equal((Object)channelImpl.aOY, (Object)this.aOY) && zzab.equal((Object)channelImpl.mPath, (Object)this.mPath) && channelImpl.mVersionCode == this.mVersionCode;
    }

    public int hashCode() {
        return this.fG.hashCode();
    }

    @Override
    public String getNodeId() {
        return this.aOY;
    }

    @Override
    public String getPath() {
        return this.mPath;
    }

    public String getToken() {
        return this.fG;
    }

    @Override
    public PendingResult<Status> close(GoogleApiClient googleApiClient) {
        return googleApiClient.zzc((zzqc.zza)new zzi<Status>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zzx((zzqc.zzb<Status>)this, ChannelImpl.this.fG);
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Status> close(GoogleApiClient googleApiClient, final int n) {
        return googleApiClient.zzc((zzqc.zza)new zzi<Status>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zzi((zzqc.zzb<Status>)this, ChannelImpl.this.fG, n);
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Channel.GetInputStreamResult> getInputStream(GoogleApiClient googleApiClient) {
        return googleApiClient.zzc((zzqc.zza)new zzi<Channel.GetInputStreamResult>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zzy((zzqc.zzb<Channel.GetInputStreamResult>)this, ChannelImpl.this.fG);
            }

            public Channel.GetInputStreamResult zzem(Status status) {
                return new zza(status, null);
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzem(status);
            }
        });
    }

    @Override
    public PendingResult<Channel.GetOutputStreamResult> getOutputStream(GoogleApiClient googleApiClient) {
        return googleApiClient.zzc((zzqc.zza)new zzi<Channel.GetOutputStreamResult>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zzz((zzqc.zzb<Channel.GetOutputStreamResult>)this, ChannelImpl.this.fG);
            }

            public Channel.GetOutputStreamResult zzen(Status status) {
                return new zzb(status, null);
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzen(status);
            }
        });
    }

    @Override
    public PendingResult<Status> receiveFile(GoogleApiClient googleApiClient, final Uri uri, final boolean bl) {
        zzac.zzb((Object)googleApiClient, (Object)"client is null");
        zzac.zzb((Object)uri, (Object)"uri is null");
        return googleApiClient.zzc((zzqc.zza)new zzi<Status>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zza((zzqc.zzb<Status>)this, ChannelImpl.this.fG, uri, bl);
            }

            public Status zzb(Status status) {
                return status;
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Status> sendFile(GoogleApiClient googleApiClient, Uri uri) {
        return this.sendFile(googleApiClient, uri, 0L, -1L);
    }

    @Override
    public PendingResult<Status> sendFile(GoogleApiClient googleApiClient, final Uri uri, final long l, final long l2) {
        zzac.zzb((Object)googleApiClient, (Object)"client is null");
        zzac.zzb((Object)this.fG, (Object)"token is null");
        zzac.zzb((Object)uri, (Object)"uri is null");
        zzac.zzb((l >= 0L ? 1 : 0) != 0, (String)"startOffset is negative: %s", (Object[])new Object[]{l});
        zzac.zzb((l2 >= 0L || l2 == -1L ? 1 : 0) != 0, (String)"invalid length: %s", (Object[])new Object[]{l2});
        return googleApiClient.zzc((zzqc.zza)new zzi<Status>(googleApiClient){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zza((zzqc.zzb<Status>)this, ChannelImpl.this.fG, uri, l, l2);
            }

            public Status zzb(Status status) {
                return status;
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient googleApiClient, ChannelApi.ChannelListener channelListener) {
        IntentFilter[] intentFilterArray = new IntentFilter[]{zzbn.zzrq("com.google.android.gms.wearable.CHANNEL_EVENT")};
        return com.google.android.gms.wearable.internal.zzb.zza(googleApiClient, ChannelImpl.zza(this.fG, intentFilterArray), channelListener);
    }

    @Override
    public PendingResult<Status> removeListener(GoogleApiClient googleApiClient, ChannelApi.ChannelListener channelListener) {
        zzac.zzb((Object)googleApiClient, (Object)"client is null");
        zzac.zzb((Object)channelListener, (Object)"listener is null");
        return googleApiClient.zzc((zzqc.zza)new zzl.zzb(googleApiClient, channelListener, this.fG));
    }

    private static zzb.zza<ChannelApi.ChannelListener> zza(final String string, final IntentFilter[] intentFilterArray) {
        return new zzb.zza<ChannelApi.ChannelListener>(){

            @Override
            public void zza(zzbp zzbp2, zzqc.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, zzrd<ChannelApi.ChannelListener> zzrd2) throws RemoteException {
                zzbp2.zza(zzb2, channelListener, zzrd2, string, intentFilterArray);
            }
        };
    }

    static final class zzb
    implements Channel.GetOutputStreamResult {
        private final Status fp;
        private final OutputStream aQj;

        zzb(Status status, OutputStream outputStream) {
            this.fp = (Status)zzac.zzy((Object)status);
            this.aQj = outputStream;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.aQj;
        }

        public void release() {
            if (this.aQj != null) {
                try {
                    this.aQj.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static final class zza
    implements Channel.GetInputStreamResult {
        private final Status fp;
        private final InputStream aQi;

        zza(Status status, InputStream inputStream) {
            this.fp = (Status)zzac.zzy((Object)status);
            this.aQi = inputStream;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public InputStream getInputStream() {
            return this.aQi;
        }

        public void release() {
            if (this.aQi != null) {
                try {
                    this.aQi.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

