/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.internal.ChannelImpl;
import com.google.android.gms.wearable.internal.zzn;

public final class ChannelEventParcelable
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<ChannelEventParcelable> CREATOR = new zzn();
    final int mVersionCode;
    final ChannelImpl aQd;
    final int type;
    final int aQb;
    final int aQc;

    ChannelEventParcelable(int n, ChannelImpl channelImpl, int n2, int n3, int n4) {
        this.mVersionCode = n;
        this.aQd = channelImpl;
        this.type = n2;
        this.aQb = n3;
        this.aQc = n4;
    }

    public void zza(ChannelApi.ChannelListener channelListener) {
        switch (this.type) {
            case 1: {
                channelListener.onChannelOpened(this.aQd);
                break;
            }
            case 2: {
                channelListener.onChannelClosed(this.aQd, this.aQb, this.aQc);
                break;
            }
            case 3: {
                channelListener.onInputClosed(this.aQd, this.aQb, this.aQc);
                break;
            }
            case 4: {
                channelListener.onOutputClosed(this.aQd, this.aQb, this.aQc);
                break;
            }
            default: {
                int n = this.type;
                Log.w((String)"ChannelEventParcelable", (String)new StringBuilder(25).append("Unknown type: ").append(n).toString());
            }
        }
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzn.zza(this, parcel, n);
    }

    public String toString() {
        int n = this.mVersionCode;
        String string = String.valueOf(this.aQd);
        String string2 = String.valueOf(ChannelEventParcelable.zzaeb(this.type));
        String string3 = String.valueOf(ChannelEventParcelable.zzaec(this.aQb));
        int n2 = this.aQc;
        return new StringBuilder(104 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("ChannelEventParcelable[versionCode=").append(n).append(", channel=").append(string).append(", type=").append(string2).append(", closeReason=").append(string3).append(", appErrorCode=").append(n2).append("]").toString();
    }

    private static String zzaeb(int n) {
        switch (n) {
            case 1: {
                return "CHANNEL_OPENED";
            }
            case 2: {
                return "CHANNEL_CLOSED";
            }
            case 4: {
                return "OUTPUT_CLOSED";
            }
            case 3: {
                return "INPUT_CLOSED";
            }
        }
        return Integer.toString(n);
    }

    private static String zzaec(int n) {
        switch (n) {
            case 1: {
                return "CLOSE_REASON_DISCONNECTED";
            }
            case 2: {
                return "CLOSE_REASON_REMOTE_CLOSE";
            }
            case 3: {
                return "CLOSE_REASON_LOCAL_CLOSE";
            }
            case 0: {
                return "CLOSE_REASON_NORMAL";
            }
        }
        return Integer.toString(n);
    }
}

