/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.util.zzy;
import com.google.android.gms.common.zzf;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.CapabilityInfo;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataEventBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.MessageEvent;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.internal.AmsEntityUpdateParcelable;
import com.google.android.gms.wearable.internal.AncsNotificationParcelable;
import com.google.android.gms.wearable.internal.CapabilityInfoParcelable;
import com.google.android.gms.wearable.internal.ChannelEventParcelable;
import com.google.android.gms.wearable.internal.MessageEventParcelable;
import com.google.android.gms.wearable.internal.NodeParcelable;
import com.google.android.gms.wearable.internal.zzaw;
import com.google.android.gms.wearable.zzd;
import java.util.List;

public abstract class WearableListenerService
extends Service
implements CapabilityApi.CapabilityListener,
ChannelApi.ChannelListener,
DataApi.DataListener,
MessageApi.MessageListener,
NodeApi.NodeListener {
    public static final String BIND_LISTENER_INTENT_ACTION = "com.google.android.gms.wearable.BIND_LISTENER";
    private ComponentName aPk;
    private zzb aPl;
    private IBinder Bz;
    private Intent aPm;
    private final Object aPn = new Object();
    private boolean aPo;

    public void onCreate() {
        String string;
        super.onCreate();
        this.aPk = new ComponentName((Context)this, this.getClass().getName());
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            string = String.valueOf(this.aPk);
            Log.d((String)"WearableLS", (String)new StringBuilder(10 + String.valueOf(string).length()).append("onCreate: ").append(string).toString());
        }
        string = new HandlerThread("WearableListenerService");
        string.start();
        this.aPl = new zzb(string.getLooper());
        this.aPm = new Intent(BIND_LISTENER_INTENT_ACTION);
        this.aPm.setComponent(this.aPk);
        this.Bz = new zzc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        Object object;
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            object = String.valueOf(this.aPk);
            Log.d((String)"WearableLS", (String)new StringBuilder(11 + String.valueOf(object).length()).append("onDestroy: ").append((String)object).toString());
        }
        object = this.aPn;
        synchronized (object) {
            this.aPo = true;
            if (this.aPl == null) {
                String string = String.valueOf(this.aPk);
                throw new IllegalStateException(new StringBuilder(111 + String.valueOf(string).length()).append("onDestroy: mServiceHandler not set, did you override onCreate() but forget to call super.onCreate()? component=").append(string).toString());
            }
            this.aPl.getLooper().quit();
        }
        super.onDestroy();
    }

    public final IBinder onBind(Intent intent) {
        if (BIND_LISTENER_INTENT_ACTION.equals(intent.getAction())) {
            return this.Bz;
        }
        return null;
    }

    @Override
    public void onDataChanged(DataEventBuffer dataEventBuffer) {
    }

    @Override
    public void onMessageReceived(MessageEvent messageEvent) {
    }

    @Override
    public void onPeerConnected(Node node) {
    }

    @Override
    public void onPeerDisconnected(Node node) {
    }

    public void onConnectedNodes(List<Node> list) {
    }

    @Override
    public void onCapabilityChanged(CapabilityInfo capabilityInfo) {
    }

    @Override
    public void onChannelOpened(Channel channel) {
    }

    @Override
    public void onChannelClosed(Channel channel, int n, int n2) {
    }

    @Override
    public void onInputClosed(Channel channel, int n, int n2) {
    }

    @Override
    public void onOutputClosed(Channel channel, int n, int n2) {
    }

    public void onNotificationReceived(zzd zzd2) {
    }

    public void onEntityUpdate(com.google.android.gms.wearable.zzb zzb2) {
    }

    private final class zzc
    extends zzaw.zza {
        private volatile int aPr = -1;

        private zzc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzbq(final DataHolder dataHolder) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DataEventBuffer dataEventBuffer = new DataEventBuffer(dataHolder);
                    try {
                        WearableListenerService.this.onDataChanged(dataEventBuffer);
                    }
                    finally {
                        dataEventBuffer.release();
                    }
                }
            };
            boolean bl = false;
            try {
                String string = String.valueOf(dataHolder);
                int n = dataHolder.getCount();
                bl = this.zza(runnable, "onDataItemChanged", new StringBuilder(18 + String.valueOf(string).length()).append(string).append(", rows=").append(n).toString());
            }
            finally {
                if (!bl) {
                    dataHolder.close();
                }
            }
        }

        @Override
        public void zza(final MessageEventParcelable messageEventParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onMessageReceived(messageEventParcelable);
                }
            };
            this.zza(runnable, "onMessageReceived", messageEventParcelable);
        }

        @Override
        public void zza(final NodeParcelable nodeParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onPeerConnected(nodeParcelable);
                }
            };
            this.zza(runnable, "onPeerConnected", nodeParcelable);
        }

        @Override
        public void zzb(final NodeParcelable nodeParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onPeerDisconnected(nodeParcelable);
                }
            };
            this.zza(runnable, "onPeerDisconnected", nodeParcelable);
        }

        @Override
        public void onConnectedNodes(final List<NodeParcelable> list) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onConnectedNodes(list);
                }
            };
            this.zza(runnable, "onConnectedNodes", list);
        }

        @Override
        public void zza(final CapabilityInfoParcelable capabilityInfoParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onCapabilityChanged(capabilityInfoParcelable);
                }
            };
            this.zza(runnable, "onConnectedCapabilityChanged", capabilityInfoParcelable);
        }

        @Override
        public void zza(final AncsNotificationParcelable ancsNotificationParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onNotificationReceived(ancsNotificationParcelable);
                }
            };
            this.zza(runnable, "onNotificationReceived", ancsNotificationParcelable);
        }

        @Override
        public void zza(final AmsEntityUpdateParcelable amsEntityUpdateParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onEntityUpdate(amsEntityUpdateParcelable);
                }
            };
            this.zza(runnable, "onEntityUpdate", amsEntityUpdateParcelable);
        }

        @Override
        public void zza(final ChannelEventParcelable channelEventParcelable) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    channelEventParcelable.zza(WearableListenerService.this);
                }
            };
            this.zza(runnable, "onChannelEvent", (Object)channelEventParcelable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(Runnable runnable, String string, Object object) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)String.format("%s: %s %s", string, WearableListenerService.this.aPk.toString(), object));
            }
            this.zzcmj();
            Object object2 = WearableListenerService.this.aPn;
            synchronized (object2) {
                if (WearableListenerService.this.aPo) {
                    return false;
                }
                WearableListenerService.this.aPl.post(runnable);
            }
            return true;
        }

        private void zzcmj() throws SecurityException {
            int n = Binder.getCallingUid();
            if (n == this.aPr) {
                return;
            }
            if (GooglePlayServicesUtil.zzb((Context)WearableListenerService.this, (int)n, (String)"com.google.android.wearable.app.cn")) {
                if (zzf.zzbz((Context)WearableListenerService.this).zzb(WearableListenerService.this.getPackageManager(), "com.google.android.wearable.app.cn")) {
                    this.aPr = n;
                    return;
                }
                throw new SecurityException("Caller is not Android Wear.");
            }
            if (zzy.zzf((Context)WearableListenerService.this, (int)n)) {
                this.aPr = n;
                return;
            }
            throw new SecurityException("Caller is not GooglePlayServices");
        }
    }

    private final class zzb
    extends Handler {
        private boolean started;
        private zza aPq;

        zzb(Looper looper) {
            super(looper);
            this.aPq = new zza();
        }

        @SuppressLint(value={"UntrackedBindService"})
        public void dispatchMessage(Message message) {
            String string;
            if (!this.started) {
                string = String.valueOf(WearableListenerService.this.aPk);
                Log.v((String)"WearableLS", (String)new StringBuilder(13 + String.valueOf(string).length()).append("bindService: ").append(string).toString());
                WearableListenerService.this.bindService(WearableListenerService.this.aPm, this.aPq, 1);
                this.started = true;
            }
            try {
                super.dispatchMessage(message);
            }
            finally {
                if (!this.hasMessages(0)) {
                    string = String.valueOf(WearableListenerService.this.aPk);
                    Log.v((String)"WearableLS", (String)new StringBuilder(15 + String.valueOf(string).length()).append("unbindService: ").append(string).toString());
                    try {
                        WearableListenerService.this.unbindService(this.aPq);
                    }
                    catch (RuntimeException runtimeException) {
                        Log.e((String)"WearableLS", (String)"Exception when unbinding from local service", (Throwable)runtimeException);
                    }
                    this.started = false;
                }
            }
        }
    }

    private class zza
    implements ServiceConnection {
        private zza() {
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        }

        public void onServiceDisconnected(ComponentName componentName) {
        }
    }
}

