/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.util.Log;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.PutDataRequest;

public class PutDataMapRequest {
    private final PutDataRequest aPa;
    private final DataMap aOZ;

    private PutDataMapRequest(PutDataRequest putDataRequest, DataMap dataMap) {
        this.aPa = putDataRequest;
        this.aOZ = new DataMap();
        if (dataMap != null) {
            this.aOZ.putAll(dataMap);
        }
    }

    public static PutDataMapRequest createFromDataMapItem(DataMapItem dataMapItem) {
        return new PutDataMapRequest(PutDataRequest.zzx(dataMapItem.getUri()), dataMapItem.getDataMap());
    }

    public static PutDataMapRequest createWithAutoAppendedId(String string) {
        return new PutDataMapRequest(PutDataRequest.createWithAutoAppendedId(string), null);
    }

    public static PutDataMapRequest create(String string) {
        return new PutDataMapRequest(PutDataRequest.create(string), null);
    }

    public Uri getUri() {
        return this.aPa.getUri();
    }

    public DataMap getDataMap() {
        return this.aOZ;
    }

    public PutDataMapRequest setUrgent() {
        this.aPa.setUrgent();
        return this;
    }

    public boolean isUrgent() {
        return this.aPa.isUrgent();
    }

    public PutDataRequest asPutDataRequest() {
        zzafx.zza zza2 = zzafx.zza(this.aOZ);
        this.aPa.setData(zzark.zzf((zzark)zza2.aRy));
        int n = zza2.aRz.size();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = Integer.toString(i);
            Asset asset = zza2.aRz.get(i);
            if (string2 == null) {
                string = String.valueOf((Object)asset);
                throw new IllegalStateException(new StringBuilder(26 + String.valueOf(string).length()).append("asset key cannot be null: ").append(string).toString());
            }
            if (asset == null) {
                String string3 = String.valueOf(string2);
                throw new IllegalStateException(string3.length() != 0 ? "asset cannot be null: key=".concat(string3) : new String("asset cannot be null: key="));
            }
            if (Log.isLoggable((String)"DataMap", (int)3)) {
                string = String.valueOf((Object)asset);
                Log.d((String)"DataMap", (String)new StringBuilder(33 + String.valueOf(string2).length() + String.valueOf(string).length()).append("asPutDataRequest: adding asset: ").append(string2).append(" ").append(string).toString());
            }
            this.aPa.putAsset(string2, asset);
        }
        return this.aPa;
    }
}

