/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.wearable.zze;
import java.util.Arrays;

public class Asset
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<Asset> CREATOR = new zze();
    final int mVersionCode;
    private byte[] adb;
    private String aOR;
    public ParcelFileDescriptor aOS;
    public Uri uri;

    Asset(int n, byte[] byArray, String string, ParcelFileDescriptor parcelFileDescriptor, Uri uri) {
        this.mVersionCode = n;
        this.adb = byArray;
        this.aOR = string;
        this.aOS = parcelFileDescriptor;
        this.uri = uri;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n | 1);
    }

    public static Asset createFromRef(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Asset digest cannot be null");
        }
        return new Asset(1, null, string, null, null);
    }

    public static Asset createFromBytes(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Asset data cannot be null");
        }
        return new Asset(1, byArray, null, null, null);
    }

    public static Asset createFromFd(ParcelFileDescriptor parcelFileDescriptor) {
        if (parcelFileDescriptor == null) {
            throw new IllegalArgumentException("Asset fd cannot be null");
        }
        return new Asset(1, null, null, parcelFileDescriptor, null);
    }

    public static Asset createFromUri(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Asset uri cannot be null");
        }
        return new Asset(1, null, null, null, uri);
    }

    public byte[] getData() {
        return this.adb;
    }

    public String getDigest() {
        return this.aOR;
    }

    public ParcelFileDescriptor getFd() {
        return this.aOS;
    }

    public Uri getUri() {
        return this.uri;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.adb, this.aOR, this.aOS, this.uri});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Asset)) {
            return false;
        }
        Asset asset = (Asset)((Object)object);
        return Arrays.equals(this.adb, asset.adb) && zzab.equal((Object)this.aOR, (Object)asset.aOR) && zzab.equal((Object)this.aOS, (Object)asset.aOS) && zzab.equal((Object)this.uri, (Object)asset.uri);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Asset[@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        if (this.aOR == null) {
            stringBuilder.append(", nodigest");
        } else {
            stringBuilder.append(", ");
            stringBuilder.append(this.aOR);
        }
        if (this.adb != null) {
            stringBuilder.append(", size=");
            stringBuilder.append(this.adb.length);
        }
        if (this.aOS != null) {
            stringBuilder.append(", fd=");
            stringBuilder.append(this.aOS);
        }
        if (this.uri != null) {
            stringBuilder.append(", uri=");
            stringBuilder.append(this.uri);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

