/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzog;

public class zzon
extends UIController {
    private final ImageView qk;
    private final Context zzcbt;
    private final int ql;
    private final Bitmap qr;
    private final View qs;
    private final ImagePicker oG;
    private zzog qn;
    private Uri qo;
    private Bitmap mBitmap;

    public zzon(ImageView imageView, Context context, int n, int n2) {
        this.qk = imageView;
        this.zzcbt = context.getApplicationContext();
        this.ql = n;
        this.qr = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n2);
        this.qs = null;
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.oG = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
    }

    public zzon(ImageView imageView, Context context, int n, View view) {
        this.qk = imageView;
        this.zzcbt = context.getApplicationContext();
        this.ql = n;
        this.qs = view;
        this.qr = null;
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.oG = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
    }

    @Override
    public void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzanb();
        this.zzana();
    }

    @Override
    public void onSessionEnded() {
        this.qo = null;
        if (this.qn != null) {
            this.qn.cancel(true);
            this.qn = null;
        }
        this.zzanb();
        super.onSessionEnded();
    }

    @Override
    public void onMediaStatusUpdated() {
        this.zzana();
    }

    private void zzana() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.qo = null;
            this.zzanb();
            return;
        }
        final Uri uri = this.zzc(remoteMediaClient.getMediaInfo());
        if (uri == null) {
            this.qo = null;
            this.zzanb();
        } else if (!zzf.zza((Object)this.qo, (Object)uri)) {
            this.qo = uri;
            this.zzanb();
            this.qn = new zzog(this.zzcbt){

                protected void onPostExecute(Bitmap bitmap) {
                    if (bitmap != null && zzf.zza((Object)zzon.this.qo, (Object)uri)) {
                        if (zzon.this.qs != null) {
                            zzon.this.qs.setVisibility(4);
                        }
                        zzon.this.qk.setVisibility(0);
                        zzon.this.qk.setImageBitmap(bitmap);
                        if (zzon.this.mBitmap != null) {
                            zzon.this.mBitmap.recycle();
                        }
                        zzon.this.mBitmap = bitmap;
                    }
                }
            };
            this.qn.zzo(uri);
        }
    }

    private Uri zzc(MediaInfo mediaInfo) {
        WebImage webImage;
        if (mediaInfo == null) {
            return null;
        }
        if (this.oG != null && (webImage = this.oG.onPickImage(mediaInfo.getMetadata(), this.ql)) != null && webImage.getUrl() != null) {
            return webImage.getUrl();
        }
        return MediaUtils.getImageUri(mediaInfo, 0);
    }

    private void zzanb() {
        if (this.qs != null) {
            this.qs.setVisibility(0);
            this.qk.setVisibility(4);
        }
        if (this.qr != null) {
            this.qk.setImageBitmap(this.qr);
        }
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
    }
}

