/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TabHost;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.zze;
import java.util.ArrayList;
import java.util.List;

public class TracksChooserDialogFragment
extends DialogFragment {
    private List<MediaTrack> pG;
    private List<MediaTrack> pH;
    private long[] lw;
    private Dialog mDialog;

    public static TracksChooserDialogFragment newInstance(MediaInfo mediaInfo, long[] lArray) {
        if (mediaInfo == null) {
            return null;
        }
        List list = mediaInfo.getMediaTracks();
        if (list == null) {
            return null;
        }
        ArrayList<MediaTrack> arrayList = TracksChooserDialogFragment.zza(list, 2);
        ArrayList<MediaTrack> arrayList2 = TracksChooserDialogFragment.zza(list, 1);
        if (arrayList.isEmpty() && arrayList2.isEmpty()) {
            return null;
        }
        TracksChooserDialogFragment tracksChooserDialogFragment = new TracksChooserDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("extra_tracks_type_audio", arrayList);
        bundle.putParcelableArrayList("extra_tracks_type_text", arrayList2);
        bundle.putLongArray("extra_active_track_ids", lArray);
        tracksChooserDialogFragment.setArguments(bundle);
        return tracksChooserDialogFragment;
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setRetainInstance(true);
        this.pG = this.getArguments().getParcelableArrayList("extra_tracks_type_text");
        this.pG.add(0, this.zzamp());
        this.pH = this.getArguments().getParcelableArrayList("extra_tracks_type_audio");
        this.lw = this.getArguments().getLongArray("extra_active_track_ids");
    }

    @NonNull
    public Dialog onCreateDialog(Bundle bundle) {
        int n = TracksChooserDialogFragment.zza(this.pG, this.lw, 0);
        int n2 = TracksChooserDialogFragment.zza(this.pH, this.lw, -1);
        final zze zze2 = new zze((Context)this.getActivity(), this.pG, n);
        final zze zze3 = new zze((Context)this.getActivity(), this.pH, n2);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        LayoutInflater layoutInflater = this.getActivity().getLayoutInflater();
        View view = layoutInflater.inflate(R.layout.cast_tracks_chooser_dialog_layout, null);
        this.zza(view, zze2, zze3);
        builder.setView(view).setPositiveButton((CharSequence)this.getActivity().getString(R.string.cast_tracks_chooser_dialog_ok), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                TracksChooserDialogFragment.this.zza(zze2, zze3);
            }
        }).setNegativeButton(R.string.cast_tracks_chooser_dialog_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                if (TracksChooserDialogFragment.this.mDialog != null) {
                    TracksChooserDialogFragment.this.mDialog.cancel();
                    TracksChooserDialogFragment.this.mDialog = null;
                }
            }
        });
        if (this.mDialog != null) {
            this.mDialog.cancel();
            this.mDialog = null;
        }
        this.mDialog = builder.create();
        return this.mDialog;
    }

    private void zza(zze zze2, zze zze3) {
        RemoteMediaClient remoteMediaClient;
        CastSession castSession;
        MediaTrack mediaTrack;
        ArrayList<MediaTrack> arrayList = new ArrayList<MediaTrack>();
        MediaTrack mediaTrack2 = zze2.zzamq();
        if (mediaTrack2.getId() != -1L) {
            arrayList.add(mediaTrack2);
        }
        if ((mediaTrack = zze3.zzamq()) != null) {
            arrayList.add(mediaTrack);
        }
        if ((castSession = CastContext.getSharedInstance(this.getContext()).getSessionManager().getCurrentCastSession()) != null && castSession.isConnected() && (remoteMediaClient = castSession.getRemoteMediaClient()) != null) {
            long[] lArray = new long[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                lArray[i] = ((MediaTrack)arrayList.get(i)).getId();
            }
            remoteMediaClient.setActiveMediaTracks(lArray);
        }
        if (this.mDialog != null) {
            this.mDialog.cancel();
            this.mDialog = null;
        }
    }

    public void onDestroyView() {
        if (this.getDialog() != null && this.getRetainInstance()) {
            this.getDialog().setDismissMessage(null);
        }
        super.onDestroyView();
    }

    private void zza(View view, zze zze2, zze zze3) {
        ListView listView = (ListView)view.findViewById(R.id.text_list_view);
        ListView listView2 = (ListView)view.findViewById(R.id.audio_list_view);
        TextView textView = (TextView)view.findViewById(R.id.text_empty_message);
        TextView textView2 = (TextView)view.findViewById(R.id.audio_empty_message);
        listView.setAdapter((ListAdapter)zze2);
        listView2.setAdapter((ListAdapter)zze3);
        TabHost tabHost = (TabHost)view.findViewById(R.id.tab_host);
        tabHost.setup();
        TabHost.TabSpec tabSpec = tabHost.newTabSpec("textTab");
        if (zze2.getCount() == 0) {
            listView.setVisibility(4);
            tabSpec.setContent(R.id.text_empty_message);
        } else {
            textView.setVisibility(4);
            tabSpec.setContent(R.id.text_list_view);
        }
        tabSpec.setIndicator((CharSequence)this.getActivity().getString(R.string.cast_tracks_chooser_dialog_subtitles));
        tabHost.addTab(tabSpec);
        TabHost.TabSpec tabSpec2 = tabHost.newTabSpec("audioTab");
        if (zze3.getCount() == 0) {
            listView2.setVisibility(4);
            tabSpec2.setContent(R.id.audio_empty_message);
        } else {
            textView2.setVisibility(4);
            tabSpec2.setContent(R.id.audio_list_view);
        }
        tabSpec2.setIndicator((CharSequence)this.getActivity().getString(R.string.cast_tracks_chooser_dialog_audio));
        tabHost.addTab(tabSpec2);
    }

    @NonNull
    private static ArrayList<MediaTrack> zza(List<MediaTrack> list, int n) {
        ArrayList<MediaTrack> arrayList = new ArrayList<MediaTrack>();
        if (list != null) {
            for (MediaTrack mediaTrack : list) {
                if (mediaTrack.getType() != n) continue;
                arrayList.add(mediaTrack);
            }
        }
        return arrayList;
    }

    private static int zza(List<MediaTrack> list, long[] lArray, int n) {
        if (lArray == null || list == null) {
            return n;
        }
        for (int i = 0; i < list.size(); ++i) {
            for (long l : lArray) {
                if (l != list.get(i).getId()) continue;
                return i;
            }
        }
        return n;
    }

    private MediaTrack zzamp() {
        return new MediaTrack.Builder(-1L, 1).setName(this.getActivity().getString(R.string.cast_tracks_chooser_dialog_none)).setSubtype(2).setContentId("").build();
    }
}

