/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.media.zzd;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class NotificationOptions
extends AbstractSafeParcelable {
    public static final long SKIP_STEP_TEN_SECONDS_IN_MS = 10000L;
    public static final long SKIP_STEP_THIRTY_SECONDS_IN_MS = 30000L;
    private static final List<String> oK = Arrays.asList("com.google.android.gms.cast.framework.action.TOGGLE_PLAYBACK", "com.google.android.gms.cast.framework.action.STOP_CASTING");
    private static final int[] oL = new int[]{0, 1};
    public static final Parcelable.Creator<NotificationOptions> CREATOR = new zzd();
    private final int mVersionCode;
    private final List<String> oM;
    private final int[] oN;
    private final long oO;
    private final String oP;
    private final int oQ;
    private final int oR;
    private final int oS;
    private final int oT;
    private final int oU;
    private final int oV;
    private final int oW;
    private final int oX;
    private final int oY;
    private final int oZ;
    private final int pa;
    private final int pb;
    private final int pc;
    private final int pd;
    private final int pe;
    private final int pf;
    private final int pg;
    private final int ph;
    private final int pi;
    private final int pj;
    private final int pk;
    private final int pl;
    private final int pm;
    private final int pn;
    private final int po;
    private final int pp;
    private final int pq;

    public NotificationOptions(int n, List<String> list, int[] nArray, long l, String string2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, int n19, int n20, int n21, int n22, int n23, int n24, int n25, int n26, int n27, int n28) {
        this.mVersionCode = n;
        this.oM = list != null ? new ArrayList<String>(list) : null;
        this.oN = (int[])(nArray != null ? Arrays.copyOf(nArray, nArray.length) : null);
        this.oO = l;
        this.oP = string2;
        this.oQ = n2;
        this.oR = n3;
        this.oS = n4;
        this.oT = n5;
        this.oU = n6;
        this.oV = n7;
        this.oW = n8;
        this.oX = n9;
        this.oY = n10;
        this.oZ = n11;
        this.pa = n12;
        this.pb = n13;
        this.pc = n14;
        this.pd = n15;
        this.pe = n16;
        this.pf = n17;
        this.pg = n18;
        this.ph = n19;
        this.pi = n20;
        this.pj = n21;
        this.pk = n22;
        this.pl = n23;
        this.pm = n24;
        this.pn = n25;
        this.po = n26;
        this.pp = n27;
        this.pq = n28;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public List<String> getActions() {
        return this.oM;
    }

    public int[] getCompatActionIndices() {
        return Arrays.copyOf(this.oN, this.oN.length);
    }

    public long getSkipStepMs() {
        return this.oO;
    }

    public String getTargetActivityClassName() {
        return this.oP;
    }

    public int getSmallIconDrawableResId() {
        return this.oQ;
    }

    public int getStopLiveStreamDrawableResId() {
        return this.oR;
    }

    public int getPauseDrawableResId() {
        return this.oS;
    }

    public int getPlayDrawableResId() {
        return this.oT;
    }

    public int getSkipNextDrawableResId() {
        return this.oU;
    }

    public int getSkipPrevDrawableResId() {
        return this.oV;
    }

    public int getForwardDrawableResId() {
        return this.oW;
    }

    public int getForward10DrawableResId() {
        return this.oX;
    }

    public int getForward30DrawableResId() {
        return this.oY;
    }

    public int getRewindDrawableResId() {
        return this.oZ;
    }

    public int getRewind10DrawableResId() {
        return this.pa;
    }

    public int getRewind30DrawableResId() {
        return this.pb;
    }

    public int getDisconnectDrawableResId() {
        return this.pc;
    }

    public int zzalu() {
        return this.pd;
    }

    public int zzalv() {
        return this.pe;
    }

    public int zzalw() {
        return this.pf;
    }

    public int zzalx() {
        return this.pg;
    }

    public int zzaly() {
        return this.ph;
    }

    public int zzalz() {
        return this.pi;
    }

    public int zzama() {
        return this.pj;
    }

    public int zzamb() {
        return this.pk;
    }

    public int zzamc() {
        return this.pl;
    }

    public int zzamd() {
        return this.pm;
    }

    public int zzame() {
        return this.pn;
    }

    public int zzamf() {
        return this.po;
    }

    public int zzamg() {
        return this.pp;
    }

    public int zzamh() {
        return this.pq;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public String toString() {
        return String.format(Locale.ROOT, "NotificationOptions(actions=%s, compatActionIndices=%s, skipStepMs=%s, targetActivityClassName=%s)", this.oM, Arrays.toString(this.oN), this.oO, this.oP);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NotificationOptions)) {
            return false;
        }
        NotificationOptions notificationOptions = (NotificationOptions)((Object)object);
        return zzf.zza(this.oM, notificationOptions.oM) && Arrays.equals(this.oN, notificationOptions.oN) && this.oO == notificationOptions.oO && zzf.zza((Object)this.oP, (Object)notificationOptions.oP);
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.oM, Arrays.hashCode(this.oN), this.oO, this.oP});
    }

    public static final class Builder {
        private String oP;
        private List<String> oM = NotificationOptions.zzami();
        private int[] oN = NotificationOptions.zzamj();
        private long oO = 10000L;

        public Builder setActions(List<String> list, int[] nArray) {
            if (list == null && nArray != null) {
                throw new IllegalArgumentException("When setting actions to null, you must also set compatActionIndices to null.");
            }
            if (list != null && nArray == null) {
                throw new IllegalArgumentException("When setting compatActionIndices to null, you must also set actions to null.");
            }
            if (list != null && nArray != null) {
                int n = list.size();
                if (nArray.length > n) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid number of compat actions: %d > %d.", nArray.length, n));
                }
                for (int n2 : nArray) {
                    if (n2 >= 0 && n2 < n) continue;
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Index %d in compatActionIndices out of range: [0, %d]", n2, n - 1));
                }
                this.oM = new ArrayList<String>(list);
                this.oN = Arrays.copyOf(nArray, nArray.length);
            } else {
                this.oM = oK;
                this.oN = oL;
            }
            return this;
        }

        public Builder setSkipStepMs(long l) {
            zzac.zzb((l > 0L ? 1 : 0) != 0, (Object)"skipStepMs must be positive.");
            this.oO = l;
            return this;
        }

        public Builder setTargetActivityClassName(String string2) {
            this.oP = string2;
            return this;
        }

        public NotificationOptions build() {
            return new NotificationOptions(1, this.oM, this.oN, this.oO, this.oP, R.drawable.cast_ic_notification_small_icon, R.drawable.cast_ic_notification_stop_live_stream, R.drawable.cast_ic_notification_pause, R.drawable.cast_ic_notification_play, R.drawable.cast_ic_notification_skip_next, R.drawable.cast_ic_notification_skip_prev, R.drawable.cast_ic_notification_forward, R.drawable.cast_ic_notification_forward10, R.drawable.cast_ic_notification_forward30, R.drawable.cast_ic_notification_rewind, R.drawable.cast_ic_notification_rewind10, R.drawable.cast_ic_notification_rewind30, R.drawable.cast_ic_notification_disconnect, R.dimen.cast_notification_image_size, R.string.cast_casting_to_device, R.string.cast_stop_live_stream, R.string.cast_pause, R.string.cast_play, R.string.cast_skip_next, R.string.cast_skip_prev, R.string.cast_forward, R.string.cast_forward_10, R.string.cast_forward_30, R.string.cast_rewind, R.string.cast_rewind_10, R.string.cast_rewind_30, R.string.cast_disconnect);
        }
    }
}

