/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.zzf;
import com.google.android.gms.cast.framework.zzh;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.cast.internal.zzn;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zznw;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoj;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class CastSession
extends Session {
    private static final zzm mL = new zzm("CastSession");
    private final Context zzcbt;
    private final Set<Cast.Listener> na = new HashSet<Cast.Listener>();
    private final zzh nb;
    private final Cast.CastApi nc;
    private final zzny nd;
    private final zzoj ne;
    private GoogleApiClient kv;
    private RemoteMediaClient nf;
    private CastDevice ng;
    private Cast.ApplicationConnectionResult nh;

    public CastSession(Context context, String string2, String string3, CastOptions castOptions, Cast.CastApi castApi, zzny zzny2, zzoj zzoj2) {
        super(context, string2, string3);
        this.zzcbt = context.getApplicationContext();
        this.nc = castApi;
        this.nd = zzny2;
        this.ne = zzoj2;
        this.nb = zznw.zza(context, castOptions, this.zzakp(), new zzb());
    }

    @Override
    protected void start(Bundle bundle) {
        this.zzk(bundle);
    }

    @Override
    protected void resume(Bundle bundle) {
        this.zzk(bundle);
    }

    @Override
    protected void end(boolean bl) {
        try {
            this.nb.zzb(bl, 0);
        }
        catch (RemoteException remoteException) {
            mL.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"disconnectFromDevice", zzh.class.getSimpleName()});
        }
        this.notifySessionEnded(0);
    }

    public RemoteMediaClient getRemoteMediaClient() {
        return this.nf;
    }

    public CastDevice getCastDevice() {
        return this.ng;
    }

    public void requestStatus() throws IOException, IllegalStateException {
        if (this.kv != null) {
            this.nc.requestStatus(this.kv);
        }
    }

    public int getActiveInputState() throws IllegalStateException {
        return this.kv != null ? this.nc.getActiveInputState(this.kv) : -1;
    }

    public int getStandbyState() throws IllegalStateException {
        return this.kv != null ? this.nc.getStandbyState(this.kv) : -1;
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        return this.kv != null ? this.nc.getApplicationMetadata(this.kv) : null;
    }

    public String getApplicationStatus() throws IllegalStateException {
        return this.kv != null ? this.nc.getApplicationStatus(this.kv) : null;
    }

    public void setVolume(double d) throws IOException {
        if (this.kv != null) {
            this.nc.setVolume(this.kv, d);
        }
    }

    public double getVolume() throws IllegalStateException {
        return this.kv != null ? this.nc.getVolume(this.kv) : 0.0;
    }

    public void setMute(boolean bl) throws IOException, IllegalStateException {
        if (this.kv != null) {
            this.nc.setMute(this.kv, bl);
        }
    }

    public boolean isMute() throws IllegalStateException {
        return this.kv != null ? this.nc.isMute(this.kv) : false;
    }

    public Cast.ApplicationConnectionResult getApplicationConnectionResult() {
        return this.nh;
    }

    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
        if (this.kv != null) {
            this.nc.setMessageReceivedCallbacks(this.kv, string2, messageReceivedCallback);
        }
    }

    public void removeMessageReceivedCallbacks(String string2) throws IOException, IllegalArgumentException {
        if (this.kv != null) {
            this.nc.removeMessageReceivedCallbacks(this.kv, string2);
        }
    }

    public PendingResult<Status> sendMessage(String string2, String string3) {
        return this.kv != null ? this.nc.sendMessage(this.kv, string2, string3) : null;
    }

    public void addCastListener(Cast.Listener listener) {
        if (listener != null) {
            this.na.add(listener);
        }
    }

    public void removeCastListener(Cast.Listener listener) {
        if (listener != null) {
            this.na.remove(listener);
        }
    }

    private void zzk(Bundle bundle) {
        this.ng = CastDevice.getFromBundle((Bundle)bundle);
        if (this.ng == null) {
            if (this.isResuming()) {
                this.notifyFailedToResumeSession(8);
            } else {
                this.notifyFailedToStartSession(8);
            }
            return;
        }
        if (this.kv != null) {
            this.kv.disconnect();
            this.kv = null;
        }
        mL.zzb("Acquiring a connection to Google Play Services for %s", new Object[]{this.ng});
        zzd zzd2 = new zzd();
        this.kv = this.nd.zza(this.zzcbt, this.ng, new zzc(), zzd2, zzd2);
        this.kv.connect();
    }

    private void zzep(int n) {
        this.ne.zzeu(n);
        if (this.kv != null) {
            this.kv.disconnect();
            this.kv = null;
        }
        this.ng = null;
        if (this.nf != null) {
            try {
                this.nf.zzd(null);
            }
            catch (IOException iOException) {
                mL.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
            }
            this.nf = null;
        }
        this.nh = null;
    }

    @Override
    public long getSessionRemainingTimeMs() {
        if (this.nf == null) {
            return 0L;
        }
        return this.nf.getStreamDuration() - this.nf.getApproximateStreamPosition();
    }

    private class zzb
    extends zzf.zza {
        private zzb() {
        }

        @Override
        public int zzakc() {
            return 9683208;
        }

        @Override
        public void zzz(String string, String string2) {
            CastSession.this.nc.joinApplication(CastSession.this.kv, string, string2).setResultCallback((ResultCallback)new zza("joinApplication"));
        }

        @Override
        public void zza(String string, LaunchOptions launchOptions) {
            CastSession.this.nc.launchApplication(CastSession.this.kv, string, launchOptions).setResultCallback((ResultCallback)new zza("launchApplication"));
        }

        @Override
        public void zzgl(String string) {
            CastSession.this.nc.stopApplication(CastSession.this.kv, string);
        }

        @Override
        public void zzep(int n) {
            CastSession.this.zzep(n);
        }
    }

    private class zza
    implements ResultCallback<Cast.ApplicationConnectionResult> {
        String ni;

        zza(String string) {
            this.ni = string;
        }

        public void zza(@NonNull Cast.ApplicationConnectionResult applicationConnectionResult) {
            block5: {
                CastSession.this.nh = applicationConnectionResult;
                try {
                    if (applicationConnectionResult.getStatus().isSuccess()) {
                        mL.zzb("%s() -> success result", new Object[]{this.ni});
                        CastSession.this.nf = new RemoteMediaClient(new zzn(null), CastSession.this.nc);
                        try {
                            CastSession.this.nf.zzd(CastSession.this.kv);
                            CastSession.this.nf.requestStatus();
                            CastSession.this.ne.zza(CastSession.this.nf, CastSession.this.getCastDevice());
                        }
                        catch (IOException iOException) {
                            mL.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                            CastSession.this.nf = null;
                        }
                        CastSession.this.nb.zza(applicationConnectionResult.getApplicationMetadata(), applicationConnectionResult.getApplicationStatus(), applicationConnectionResult.getSessionId(), applicationConnectionResult.getWasLaunched());
                        break block5;
                    }
                    mL.zzb("%s() -> failure result", new Object[]{this.ni});
                    CastSession.this.nb.zzeq(applicationConnectionResult.getStatus().getStatusCode());
                }
                catch (RemoteException remoteException) {
                    mL.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"methods", zzh.class.getSimpleName()});
                }
            }
        }

        public /* synthetic */ void onResult(@NonNull Result result) {
            this.zza((Cast.ApplicationConnectionResult)result);
        }
    }

    private class zzc
    extends Cast.Listener {
        private zzc() {
        }

        public void onApplicationDisconnected(int n) {
            CastSession.this.zzep(n);
            CastSession.this.notifySessionEnded(n);
            HashSet hashSet = new HashSet(CastSession.this.na);
            for (Cast.Listener listener : hashSet) {
                listener.onApplicationDisconnected(n);
            }
        }

        public void onApplicationStatusChanged() {
            HashSet hashSet = new HashSet(CastSession.this.na);
            for (Cast.Listener listener : hashSet) {
                listener.onApplicationStatusChanged();
            }
        }

        public void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
            HashSet hashSet = new HashSet(CastSession.this.na);
            for (Cast.Listener listener : hashSet) {
                listener.onApplicationMetadataChanged(applicationMetadata);
            }
        }

        public void onActiveInputStateChanged(int n) {
            HashSet hashSet = new HashSet(CastSession.this.na);
            for (Cast.Listener listener : hashSet) {
                listener.onActiveInputStateChanged(n);
            }
        }

        public void onStandbyStateChanged(int n) {
            HashSet hashSet = new HashSet(CastSession.this.na);
            for (Cast.Listener listener : hashSet) {
                listener.onStandbyStateChanged(n);
            }
        }

        public void onVolumeChanged() {
            HashSet hashSet = new HashSet(CastSession.this.na);
            for (Cast.Listener listener : hashSet) {
                listener.onVolumeChanged();
            }
        }
    }

    private class zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zzd() {
        }

        public void onConnected(Bundle bundle) {
            try {
                CastSession.this.nb.onConnected(bundle);
            }
            catch (RemoteException remoteException) {
                mL.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnected", zzh.class.getSimpleName()});
            }
        }

        public void onConnectionSuspended(int n) {
            try {
                CastSession.this.nb.onConnectionSuspended(n);
            }
            catch (RemoteException remoteException) {
                mL.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionSuspended", zzh.class.getSimpleName()});
            }
        }

        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            try {
                CastSession.this.nb.onConnectionFailed(connectionResult);
            }
            catch (RemoteException remoteException) {
                mL.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionFailed", zzh.class.getSimpleName()});
            }
        }
    }
}

