/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.plus.internal.zzg;

public final class PlusOneButton
extends FrameLayout {
    public static final int SIZE_SMALL = 0;
    public static final int SIZE_MEDIUM = 1;
    public static final int SIZE_TALL = 2;
    public static final int SIZE_STANDARD = 3;
    public static final int ANNOTATION_NONE = 0;
    public static final int ANNOTATION_BUBBLE = 1;
    public static final int ANNOTATION_INLINE = 2;
    public static final int DEFAULT_ACTIVITY_REQUEST_CODE = -1;
    private View axG;
    private int mSize;
    private int axH;
    private String zzae;
    private int axI;
    private OnPlusOneClickListener axJ;

    public PlusOneButton(Context context) {
        this(context, null);
    }

    public PlusOneButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mSize = PlusOneButton.getSize(context, attributeSet);
        this.axH = PlusOneButton.getAnnotation(context, attributeSet);
        this.axI = -1;
        this.zzca(this.getContext());
        if (this.isInEditMode()) {
            return;
        }
    }

    protected static int getSize(Context context, AttributeSet attributeSet) {
        String string = zzal.zza((String)"http://schemas.android.com/apk/lib/com.google.android.gms.plus", (String)"size", (Context)context, (AttributeSet)attributeSet, (boolean)true, (boolean)false, (String)"PlusOneButton");
        return "SMALL".equalsIgnoreCase(string) ? 0 : ("MEDIUM".equalsIgnoreCase(string) ? 1 : ("TALL".equalsIgnoreCase(string) ? 2 : 3));
    }

    protected static int getAnnotation(Context context, AttributeSet attributeSet) {
        String string = zzal.zza((String)"http://schemas.android.com/apk/lib/com.google.android.gms.plus", (String)"annotation", (Context)context, (AttributeSet)attributeSet, (boolean)true, (boolean)false, (String)"PlusOneButton");
        return "INLINE".equalsIgnoreCase(string) ? 2 : ("NONE".equalsIgnoreCase(string) ? 0 : 1);
    }

    private void zzca(Context context) {
        if (this.axG != null) {
            this.removeView(this.axG);
        }
        this.axG = zzg.zza(context, this.mSize, this.axH, this.zzae, this.axI);
        this.setOnPlusOneClickListener(this.axJ);
        this.addView(this.axG);
    }

    public void initialize(String string, int n) {
        zzac.zza((boolean)(this.getContext() instanceof Activity), (Object)"To use this method, the PlusOneButton must be placed in an Activity. Use initialize(String, OnPlusOneClickListener).");
        this.zzae = string;
        this.axI = n;
        this.zzca(this.getContext());
    }

    public void initialize(String string, OnPlusOneClickListener onPlusOneClickListener) {
        this.zzae = string;
        this.axI = 0;
        this.zzca(this.getContext());
        this.setOnPlusOneClickListener(onPlusOneClickListener);
    }

    public void setOnPlusOneClickListener(OnPlusOneClickListener onPlusOneClickListener) {
        this.axJ = onPlusOneClickListener;
        this.axG.setOnClickListener((View.OnClickListener)new DefaultOnPlusOneClickListener(onPlusOneClickListener));
    }

    public void setAnnotation(int n) {
        this.axH = n;
        this.zzca(this.getContext());
    }

    public void setSize(int n) {
        this.mSize = n;
        this.zzca(this.getContext());
    }

    protected void onMeasure(int n, int n2) {
        View view = this.axG;
        this.measureChild(view, n, n2);
        this.setMeasuredDimension(view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.axG.layout(0, 0, n3 - n, n4 - n2);
    }

    public void plusOneClick() {
        this.axG.performClick();
    }

    public void setIntent(Intent intent) {
        this.axG.setTag((Object)intent);
    }

    protected class DefaultOnPlusOneClickListener
    implements View.OnClickListener,
    OnPlusOneClickListener {
        private final OnPlusOneClickListener axK;

        public DefaultOnPlusOneClickListener(OnPlusOneClickListener onPlusOneClickListener) {
            this.axK = onPlusOneClickListener;
        }

        public void onClick(View view) {
            Intent intent = (Intent)PlusOneButton.this.axG.getTag();
            if (this.axK != null) {
                this.axK.onPlusOneClick(intent);
            } else {
                this.onPlusOneClick(intent);
            }
        }

        @Override
        public void onPlusOneClick(Intent intent) {
            Context context = PlusOneButton.this.getContext();
            if (context instanceof Activity && intent != null) {
                ((Activity)context).startActivityForResult(intent, PlusOneButton.this.axI);
            }
        }
    }

    public static interface OnPlusOneClickListener {
        public void onPlusOneClick(Intent var1);
    }
}

