/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.MediaRouterThemeHelper;
import android.support.v7.mediarouter.R;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageButton;

class MediaRouteExpandCollapseButton
extends ImageButton {
    private final AnimationDrawable mExpandAnimationDrawable;
    private final AnimationDrawable mCollapseAnimationDrawable;
    private final String mExpandGroupDescription;
    private final String mCollapseGroupDescription;
    private boolean mIsGroupExpanded;
    private View.OnClickListener mListener;

    public MediaRouteExpandCollapseButton(Context context) {
        this(context, null);
    }

    public MediaRouteExpandCollapseButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MediaRouteExpandCollapseButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mExpandAnimationDrawable = (AnimationDrawable)ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_expand);
        this.mCollapseAnimationDrawable = (AnimationDrawable)ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_collapse);
        PorterDuffColorFilter filter = new PorterDuffColorFilter(MediaRouterThemeHelper.getControllerColor(context, defStyleAttr), PorterDuff.Mode.SRC_IN);
        this.mExpandAnimationDrawable.setColorFilter((ColorFilter)filter);
        this.mCollapseAnimationDrawable.setColorFilter((ColorFilter)filter);
        this.mExpandGroupDescription = context.getString(R.string.mr_controller_expand_group);
        this.mCollapseGroupDescription = context.getString(R.string.mr_controller_collapse_group);
        this.setImageDrawable(this.mExpandAnimationDrawable.getFrame(0));
        this.setContentDescription(this.mExpandGroupDescription);
        super.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MediaRouteExpandCollapseButton.this.mIsGroupExpanded = !MediaRouteExpandCollapseButton.this.mIsGroupExpanded;
                if (MediaRouteExpandCollapseButton.this.mIsGroupExpanded) {
                    MediaRouteExpandCollapseButton.this.setImageDrawable((Drawable)MediaRouteExpandCollapseButton.this.mExpandAnimationDrawable);
                    MediaRouteExpandCollapseButton.this.mExpandAnimationDrawable.start();
                    MediaRouteExpandCollapseButton.this.setContentDescription(MediaRouteExpandCollapseButton.this.mCollapseGroupDescription);
                } else {
                    MediaRouteExpandCollapseButton.this.setImageDrawable((Drawable)MediaRouteExpandCollapseButton.this.mCollapseAnimationDrawable);
                    MediaRouteExpandCollapseButton.this.mCollapseAnimationDrawable.start();
                    MediaRouteExpandCollapseButton.this.setContentDescription(MediaRouteExpandCollapseButton.this.mExpandGroupDescription);
                }
                if (MediaRouteExpandCollapseButton.this.mListener != null) {
                    MediaRouteExpandCollapseButton.this.mListener.onClick(view);
                }
            }
        });
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.mListener = listener;
    }
}

