/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face.internal.client;

import android.content.Context;
import android.graphics.PointF;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.internal.zzsu;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.Landmark;
import com.google.android.gms.vision.face.internal.client.FaceParcel;
import com.google.android.gms.vision.face.internal.client.FaceSettingsParcel;
import com.google.android.gms.vision.face.internal.client.LandmarkParcel;
import com.google.android.gms.vision.face.internal.client.zzd;
import com.google.android.gms.vision.face.internal.client.zze;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import java.nio.ByteBuffer;

public class zza
extends com.google.android.gms.vision.internal.client.zza<zzd> {
    private final FaceSettingsParcel aLf;

    public zza(Context context, FaceSettingsParcel faceSettingsParcel) {
        super(context, "FaceNativeHandle");
        this.aLf = faceSettingsParcel;
        this.zzclt();
    }

    public Face[] zzb(ByteBuffer byteBuffer, FrameMetadataParcel frameMetadataParcel) {
        FaceParcel[] faceParcelArray;
        Face[] faceArray;
        if (!this.isOperational()) {
            return new Face[0];
        }
        try {
            faceArray = com.google.android.gms.dynamic.zze.zzac((Object)byteBuffer);
            faceParcelArray = ((zzd)this.zzclt()).zzc((com.google.android.gms.dynamic.zzd)faceArray, frameMetadataParcel);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return new Face[0];
        }
        faceArray = new Face[faceParcelArray.length];
        for (int i = 0; i < faceParcelArray.length; ++i) {
            faceArray[i] = this.zza(faceParcelArray[i]);
        }
        return faceArray;
    }

    public boolean zzabr(int n) {
        if (!this.isOperational()) {
            return false;
        }
        try {
            return ((zzd)this.zzclt()).zzabr(n);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return false;
        }
    }

    protected zzd zzc(zzsu zzsu2, Context context) throws RemoteException, zzsu.zza {
        zze zze2 = zze.zza.zzlm(zzsu2.zzjd("com.google.android.gms.vision.face.ChimeraNativeFaceDetectorCreator"));
        com.google.android.gms.dynamic.zzd zzd2 = com.google.android.gms.dynamic.zze.zzac((Object)context);
        return zze2.zza(zzd2, this.aLf);
    }

    @Override
    protected void zzclq() throws RemoteException {
        ((zzd)this.zzclt()).zzclr();
    }

    private Face zza(FaceParcel faceParcel) {
        return new Face(faceParcel.id, new PointF(faceParcel.centerX, faceParcel.centerY), faceParcel.width, faceParcel.height, faceParcel.aLg, faceParcel.aLh, this.zzb(faceParcel), faceParcel.aLj, faceParcel.aLk, faceParcel.aLl);
    }

    private Landmark[] zzb(FaceParcel faceParcel) {
        Landmark[] landmarkArray;
        LandmarkParcel[] landmarkParcelArray = faceParcel.aLi;
        if (landmarkParcelArray == null) {
            landmarkArray = new Landmark[]{};
        } else {
            landmarkArray = new Landmark[landmarkParcelArray.length];
            for (int i = 0; i < landmarkParcelArray.length; ++i) {
                landmarkArray[i] = this.zza(landmarkParcelArray[i]);
            }
        }
        return landmarkArray;
    }

    private Landmark zza(LandmarkParcel landmarkParcel) {
        return new Landmark(new PointF(landmarkParcel.x, landmarkParcel.y), landmarkParcel.type);
    }

    @Override
    protected /* synthetic */ Object zzb(zzsu zzsu2, Context context) throws RemoteException, zzsu.zza {
        return this.zzc(zzsu2, context);
    }
}

