/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.content.Context;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.internal.client.FaceSettingsParcel;
import com.google.android.gms.vision.face.internal.client.zza;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import java.nio.ByteBuffer;
import java.util.HashSet;

public final class FaceDetector
extends Detector<Face> {
    public static final int NO_LANDMARKS = 0;
    public static final int ALL_LANDMARKS = 1;
    public static final int NO_CLASSIFICATIONS = 0;
    public static final int ALL_CLASSIFICATIONS = 1;
    public static final int FAST_MODE = 0;
    public static final int ACCURATE_MODE = 1;
    private final com.google.android.gms.vision.zza aKW = new com.google.android.gms.vision.zza();
    private final zza aKX;
    private final Object zzakd = new Object();
    private boolean aKY = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        super.release();
        Object object = this.zzakd;
        synchronized (object) {
            if (!this.aKY) {
                return;
            }
            this.aKX.zzcls();
            this.aKY = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Object object = this.zzakd;
            synchronized (object) {
                if (this.aKY) {
                    Log.w((String)"FaceDetector", (String)"FaceDetector was not released with FaceDetector.release()");
                    this.release();
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SparseArray<Face> detect(Frame frame) {
        Face[] faceArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        ByteBuffer byteBuffer = frame.getGrayscaleImageData();
        Object object = this.zzakd;
        synchronized (object) {
            if (!this.aKY) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            faceArray = this.aKX.zzb(byteBuffer, FrameMetadataParcel.zzc(frame));
        }
        int n = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        SparseArray sparseArray = new SparseArray(faceArray.length);
        for (Face face : faceArray) {
            int n2 = face.getId();
            n = Math.max(n, n2);
            if (hashSet.contains(n2)) {
                n2 = ++n;
            }
            hashSet.add(n2);
            int n3 = this.aKW.zzabb(n2);
            sparseArray.append(n3, (Object)face);
        }
        return sparseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setFocus(int n) {
        int n2 = this.aKW.zzabc(n);
        Object object = this.zzakd;
        synchronized (object) {
            if (!this.aKY) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            return this.aKX.zzabr(n2);
        }
    }

    @Override
    public boolean isOperational() {
        return this.aKX.isOperational();
    }

    private FaceDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private FaceDetector(zza zza2) {
        this.aKX = zza2;
    }

    public static class Builder {
        private final Context mContext;
        private int aKZ = 0;
        private boolean aLa = false;
        private int aLb = 0;
        private boolean aLc = true;
        private int Hh = 0;
        private float aLd = -1.0f;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setLandmarkType(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(34).append("Invalid landmark type: ").append(n).toString());
            }
            this.aKZ = n;
            return this;
        }

        public Builder setProminentFaceOnly(boolean bl) {
            this.aLa = bl;
            return this;
        }

        public Builder setClassificationType(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(40).append("Invalid classification type: ").append(n).toString());
            }
            this.aLb = n;
            return this;
        }

        public Builder setTrackingEnabled(boolean bl) {
            this.aLc = bl;
            return this;
        }

        public Builder setMode(int n) {
            switch (n) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(25).append("Invalid mode: ").append(n).toString());
                }
            }
            this.Hh = n;
            return this;
        }

        public Builder setMinFaceSize(float f) {
            if (f < 0.0f || f > 1.0f) {
                throw new IllegalArgumentException(new StringBuilder(47).append("Invalid proportional face size: ").append(f).toString());
            }
            this.aLd = f;
            return this;
        }

        public FaceDetector build() {
            FaceSettingsParcel faceSettingsParcel = new FaceSettingsParcel();
            faceSettingsParcel.mode = this.Hh;
            faceSettingsParcel.aLm = this.aKZ;
            faceSettingsParcel.aLn = this.aLb;
            faceSettingsParcel.aLo = this.aLa;
            faceSettingsParcel.aLp = this.aLc;
            faceSettingsParcel.aLq = this.aLd;
            zza zza2 = new zza(this.mContext, faceSettingsParcel);
            return new FaceDetector(zza2);
        }
    }
}

