/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.graphics.PointF;
import com.google.android.gms.vision.face.Landmark;
import java.util.Arrays;
import java.util.List;

public class Face {
    public static final float UNCOMPUTED_PROBABILITY = -1.0f;
    private int mId;
    private PointF aKP;
    private float amJ;
    private float amK;
    private float aKQ;
    private float aKR;
    private List<Landmark> aKS;
    private float aKT;
    private float aKU;
    private float aKV;

    public PointF getPosition() {
        return new PointF(this.aKP.x - this.amJ / 2.0f, this.aKP.y - this.amK / 2.0f);
    }

    public float getWidth() {
        return this.amJ;
    }

    public float getHeight() {
        return this.amK;
    }

    public float getEulerY() {
        return this.aKQ;
    }

    public float getEulerZ() {
        return this.aKR;
    }

    public List<Landmark> getLandmarks() {
        return this.aKS;
    }

    public float getIsLeftEyeOpenProbability() {
        return this.aKT;
    }

    public float getIsRightEyeOpenProbability() {
        return this.aKU;
    }

    public float getIsSmilingProbability() {
        return this.aKV;
    }

    public int getId() {
        return this.mId;
    }

    public Face(int n, PointF pointF, float f, float f2, float f3, float f4, Landmark[] landmarkArray, float f5, float f6, float f7) {
        this.mId = n;
        this.aKP = pointF;
        this.amJ = f;
        this.amK = f2;
        this.aKQ = f3;
        this.aKR = f4;
        this.aKS = Arrays.asList(landmarkArray);
        this.aKT = f5 >= 0.0f && f5 <= 1.0f ? f5 : -1.0f;
        this.aKU = f6 >= 0.0f && f6 <= 1.0f ? f6 : -1.0f;
        this.aKV = f7 >= 0.0f && f7 <= 1.0f ? f7 : -1.0f;
    }
}

