/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;

public abstract class FocusingProcessor<T>
implements Detector.Processor<T> {
    private Detector<T> aKf;
    private Tracker<T> aKv;
    private int aKw = 3;
    private boolean aKx = false;
    private int aKy;
    private int aKz = 0;

    public FocusingProcessor(Detector<T> detector, Tracker<T> tracker) {
        this.aKf = detector;
        this.aKv = tracker;
    }

    @Override
    public void release() {
        this.aKv.onDone();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        int n;
        Object object;
        SparseArray<T> sparseArray = detections.getDetectedItems();
        if (sparseArray.size() == 0) {
            if (this.aKz == this.aKw) {
                this.aKv.onDone();
                this.aKx = false;
            } else {
                this.aKv.onMissing(detections);
            }
            ++this.aKz;
            return;
        }
        this.aKz = 0;
        if (this.aKx) {
            Object object2 = sparseArray.get(this.aKy);
            if (object2 != null) {
                this.aKv.onUpdate(detections, object2);
                return;
            }
            this.aKv.onDone();
            this.aKx = false;
        }
        if ((object = sparseArray.get(n = this.selectFocus(detections))) == null) {
            Log.w((String)"FocusingProcessor", (String)new StringBuilder(35).append("Invalid focus selected: ").append(n).toString());
            return;
        }
        this.aKx = true;
        this.aKy = n;
        this.aKf.setFocus(this.aKy);
        this.aKv.onNewItem(this.aKy, object);
        this.aKv.onUpdate(detections, object);
    }

    public abstract int selectFocus(Detector.Detections<T> var1);

    protected void zzaba(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Invalid max gap: ").append(n).toString());
        }
        this.aKw = n;
    }
}

