/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzag;
import com.google.android.gms.internal.zzai;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzbo;
import com.google.android.gms.tagmanager.zzdj;
import com.google.android.gms.tagmanager.zzdk;
import com.google.android.gms.tagmanager.zzdm;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class zzdn
extends zzdk {
    private static final String ID = zzaf.zzkj.toString();
    private static final String aEP = zzag.zzls.toString();
    private static final String aEQ = zzag.zzmd.toString();
    private static final String aER = zzag.zzpc.toString();
    private static final String aES = zzag.zzov.toString();
    private static final String aET = zzag.zzou.toString();
    private static final String aEU = zzag.zzmc.toString();
    private static final String aEV = zzag.zzuk.toString();
    private static final String aEW = zzag.zzun.toString();
    private static final String aEX = zzag.zzup.toString();
    private static final List<String> aEY = Arrays.asList("detail", "checkout", "checkout_option", "click", "add", "remove", "purchase", "refund");
    private static final Pattern aEZ = Pattern.compile("dimension(\\d+)");
    private static final Pattern aFa = Pattern.compile("metric(\\d+)");
    private static Map<String, String> aFb;
    private static Map<String, String> aFc;
    private final Set<String> aFd;
    private final zzdj aFe;
    private final DataLayer aAP;

    public zzdn(Context context, DataLayer dataLayer) {
        this(context, dataLayer, new zzdj(context));
    }

    zzdn(Context context, DataLayer dataLayer, zzdj zzdj2) {
        super(ID, new String[0]);
        this.aAP = dataLayer;
        this.aFe = zzdj2;
        this.aFd = new HashSet<String>();
        this.aFd.add("");
        this.aFd.add("0");
        this.aFd.add("false");
    }

    private boolean zzj(Map<String, zzai.zza> map, String string) {
        zzai.zza zza2 = map.get(string);
        return zza2 == null ? false : zzdm.zzk(zza2);
    }

    @Override
    public void zzay(Map<String, zzai.zza> map) {
        Tracker tracker = this.aFe.zzpv("_GTM_DEFAULT_TRACKER_");
        tracker.enableAdvertisingIdCollection(this.zzj(map, "collect_adid"));
        if (this.zzj(map, aER)) {
            this.zzb(tracker, map);
        } else if (this.zzj(map, aEQ)) {
            tracker.send(this.zzm(map.get(aEU)));
        } else if (this.zzj(map, aEV)) {
            this.zza(tracker, map);
        } else {
            zzbo.zzdf("Ignoring unknown tag.");
        }
    }

    private String zzqd(String string) {
        Object object = this.aAP.get(string);
        return object == null ? null : object.toString();
    }

    private List<Map<String, String>> zzqe(String string) {
        Object object = this.aAP.get(string);
        if (object == null) {
            return null;
        }
        if (!(object instanceof List)) {
            throw new IllegalArgumentException("transactionProducts should be of type List.");
        }
        List list = (List)object;
        for (Object e : list) {
            if (e instanceof Map) continue;
            throw new IllegalArgumentException("Each element of transactionProducts should be of type Map.");
        }
        List list2 = (List)object;
        return list2;
    }

    private void zze(Map<String, String> map, String string, String string2) {
        if (string2 != null) {
            map.put(string, string2);
        }
    }

    private void zza(Tracker tracker, Map<String, zzai.zza> map) {
        String string = this.zzqd("transactionId");
        if (string == null) {
            zzbo.e("Cannot find transactionId in data layer.");
            return;
        }
        LinkedList<Map<String, String>> linkedList = new LinkedList<Map<String, String>>();
        try {
            Map<String, String> map2 = this.zzm(map.get(aEU));
            map2.put("&t", "transaction");
            Map<String, String> map3 = this.zzbi(map);
            for (Map.Entry<String, String> iterator : map3.entrySet()) {
                this.zze(map2, iterator.getValue(), this.zzqd(iterator.getKey()));
            }
            linkedList.add(map2);
            List<Map<String, String>> list = this.zzqe("transactionProducts");
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Map map4 = (Map)iterator.next();
                    if (map4.get("name") == null) {
                        zzbo.e("Unable to send transaction item hit due to missing 'name' field.");
                        return;
                    }
                    Map<String, String> map5 = this.zzm(map.get(aEU));
                    map5.put("&t", "item");
                    map5.put("&ti", string);
                    Map<String, String> map6 = this.zzbj(map);
                    for (Map.Entry<String, String> entry : map6.entrySet()) {
                        this.zze(map5, entry.getValue(), (String)map4.get(entry.getKey()));
                    }
                    linkedList.add(map5);
                }
            }
            for (Map map7 : linkedList) {
                tracker.send(map7);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            zzbo.zzb("Unable to send transaction", illegalArgumentException);
            return;
        }
    }

    private void zzb(Tracker tracker, Map<String, zzai.zza> map) {
        Object object;
        HitBuilders.ScreenViewBuilder screenViewBuilder = new HitBuilders.ScreenViewBuilder();
        Map<String, String> map2 = this.zzm(map.get(aEU));
        screenViewBuilder.setAll(map2);
        Map map3 = null;
        if (this.zzj(map, aES)) {
            object = this.aAP.get("ecommerce");
            if (object instanceof Map) {
                map3 = (Map)object;
            }
        } else {
            object = zzdm.zzl(map.get(aET));
            if (object instanceof Map) {
                map3 = (Map)object;
            }
        }
        if (map3 != null) {
            Object object2;
            Object object3;
            List list;
            Object v;
            object = map2.get("&cu");
            if (object == null) {
                object = (String)map3.get("currencyCode");
            }
            if (object != null) {
                screenViewBuilder.set("&cu", (String)object);
            }
            if ((v = map3.get("impressions")) instanceof List) {
                list = (List)v;
                for (Iterator<String> iterator : list) {
                    try {
                        Product runtimeException = this.zzbh((Map<String, Object>)((Object)iterator));
                        screenViewBuilder.addImpression(runtimeException, (String)iterator.get("list"));
                    }
                    catch (RuntimeException runtimeException) {
                        String string = String.valueOf(runtimeException.getMessage());
                        zzbo.e(string.length() != 0 ? "Failed to extract a product from DataLayer. ".concat(string) : new String("Failed to extract a product from DataLayer. "));
                    }
                }
            }
            list = null;
            if (map3.containsKey("promoClick")) {
                object3 = (Map)map3.get("promoClick");
                list = (List)object3.get("promotions");
            } else if (map3.containsKey("promoView")) {
                object3 = (Map)map3.get("promoView");
                list = (List)object3.get("promotions");
            }
            boolean bl = true;
            if (list != null) {
                for (Map map4 : list) {
                    try {
                        object2 = this.zzbg(map4);
                        screenViewBuilder.addPromotion((Promotion)object2);
                    }
                    catch (RuntimeException runtimeException) {
                        String string = String.valueOf(runtimeException.getMessage());
                        zzbo.e(string.length() != 0 ? "Failed to extract a promotion from DataLayer. ".concat(string) : new String("Failed to extract a promotion from DataLayer. "));
                    }
                }
                if (map3.containsKey("promoClick")) {
                    screenViewBuilder.set("&promoa", "click");
                    bl = false;
                } else {
                    screenViewBuilder.set("&promoa", "view");
                }
            }
            if (bl) {
                for (String string : aEY) {
                    if (!map3.containsKey(string)) continue;
                    object2 = (Map)map3.get(string);
                    List list2 = (List)object2.get("products");
                    if (list2 != null) {
                        for (Map map5 : list2) {
                            try {
                                Product product = this.zzbh(map5);
                                screenViewBuilder.addProduct(product);
                            }
                            catch (RuntimeException runtimeException) {
                                String string2 = String.valueOf(runtimeException.getMessage());
                                zzbo.e(string2.length() != 0 ? "Failed to extract a product from DataLayer. ".concat(string2) : new String("Failed to extract a product from DataLayer. "));
                            }
                        }
                    }
                    try {
                        Object object4;
                        if (object2.containsKey("actionField")) {
                            Map map5;
                            map5 = (Map)object2.get("actionField");
                            object4 = this.zzi(string, map5);
                        } else {
                            object4 = new ProductAction(string);
                        }
                        screenViewBuilder.setProductAction((ProductAction)object4);
                    }
                    catch (RuntimeException runtimeException) {
                        String string3 = String.valueOf(runtimeException.getMessage());
                        zzbo.e(string3.length() != 0 ? "Failed to extract a product action from DataLayer. ".concat(string3) : new String("Failed to extract a product action from DataLayer. "));
                    }
                    break;
                }
            }
        }
        tracker.send(screenViewBuilder.build());
    }

    private ProductAction zzi(String string, Map<String, Object> map) {
        ProductAction productAction = new ProductAction(string);
        Object object = map.get("id");
        if (object != null) {
            productAction.setTransactionId(String.valueOf(object));
        }
        if ((object = map.get("affiliation")) != null) {
            productAction.setTransactionAffiliation(String.valueOf(object));
        }
        if ((object = map.get("coupon")) != null) {
            productAction.setTransactionCouponCode(String.valueOf(object));
        }
        if ((object = map.get("list")) != null) {
            productAction.setProductActionList(String.valueOf(object));
        }
        if ((object = map.get("option")) != null) {
            productAction.setCheckoutOptions(String.valueOf(object));
        }
        if ((object = map.get("revenue")) != null) {
            productAction.setTransactionRevenue(this.zzax(object));
        }
        if ((object = map.get("tax")) != null) {
            productAction.setTransactionTax(this.zzax(object));
        }
        if ((object = map.get("shipping")) != null) {
            productAction.setTransactionShipping(this.zzax(object));
        }
        if ((object = map.get("step")) != null) {
            productAction.setCheckoutStep(this.zzay(object));
        }
        return productAction;
    }

    private Promotion zzbg(Map<String, String> map) {
        Promotion promotion = new Promotion();
        String string = map.get("id");
        if (string != null) {
            promotion.setId(String.valueOf(string));
        }
        if ((string = map.get("name")) != null) {
            promotion.setName(String.valueOf(string));
        }
        if ((string = map.get("creative")) != null) {
            promotion.setCreative(String.valueOf(string));
        }
        if ((string = map.get("position")) != null) {
            promotion.setPosition(String.valueOf(string));
        }
        return promotion;
    }

    private Product zzbh(Map<String, Object> map) {
        Product product = new Product();
        Object object = map.get("id");
        if (object != null) {
            product.setId(String.valueOf(object));
        }
        if ((object = map.get("name")) != null) {
            product.setName(String.valueOf(object));
        }
        if ((object = map.get("brand")) != null) {
            product.setBrand(String.valueOf(object));
        }
        if ((object = map.get("category")) != null) {
            product.setCategory(String.valueOf(object));
        }
        if ((object = map.get("variant")) != null) {
            product.setVariant(String.valueOf(object));
        }
        if ((object = map.get("coupon")) != null) {
            product.setCouponCode(String.valueOf(object));
        }
        if ((object = map.get("position")) != null) {
            product.setPosition(this.zzay(object));
        }
        if ((object = map.get("price")) != null) {
            product.setPrice(this.zzax(object));
        }
        if ((object = map.get("quantity")) != null) {
            product.setQuantity(this.zzay(object));
        }
        for (String string : map.keySet()) {
            Matcher matcher = aEZ.matcher(string);
            if (matcher.matches()) {
                int n = 0;
                try {
                    n = Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    String string2 = String.valueOf(string);
                    zzbo.zzdf(string2.length() != 0 ? "illegal number in custom dimension value: ".concat(string2) : new String("illegal number in custom dimension value: "));
                    continue;
                }
                product.setCustomDimension(n, String.valueOf(map.get(string)));
                continue;
            }
            Matcher matcher2 = aFa.matcher(string);
            if (!matcher2.matches()) continue;
            int n = 0;
            try {
                n = Integer.parseInt(matcher2.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                String string3 = String.valueOf(string);
                zzbo.zzdf(string3.length() != 0 ? "illegal number in custom metric value: ".concat(string3) : new String("illegal number in custom metric value: "));
                continue;
            }
            product.setCustomMetric(n, this.zzay(map.get(string)));
        }
        return product;
    }

    private Map<String, String> zzc(zzai.zza zza2) {
        Object object = zzdm.zzl(zza2);
        if (!(object instanceof Map)) {
            return null;
        }
        Map map = (Map)object;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            linkedHashMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return linkedHashMap;
    }

    private Map<String, String> zzm(zzai.zza zza2) {
        if (zza2 == null) {
            return new HashMap<String, String>();
        }
        Map<String, String> map = this.zzc(zza2);
        if (map == null) {
            return new HashMap<String, String>();
        }
        String string = map.get("&aip");
        if (string != null && this.aFd.contains(string.toLowerCase())) {
            map.remove("&aip");
        }
        return map;
    }

    private Map<String, String> zzbi(Map<String, zzai.zza> map) {
        zzai.zza zza2 = map.get(aEW);
        if (zza2 != null) {
            return this.zzc(zza2);
        }
        if (aFb == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("transactionId", "&ti");
            hashMap.put("transactionAffiliation", "&ta");
            hashMap.put("transactionTax", "&tt");
            hashMap.put("transactionShipping", "&ts");
            hashMap.put("transactionTotal", "&tr");
            hashMap.put("transactionCurrency", "&cu");
            aFb = hashMap;
        }
        return aFb;
    }

    private Map<String, String> zzbj(Map<String, zzai.zza> map) {
        zzai.zza zza2 = map.get(aEX);
        if (zza2 != null) {
            return this.zzc(zza2);
        }
        if (aFc == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "&in");
            hashMap.put("sku", "&ic");
            hashMap.put("category", "&iv");
            hashMap.put("price", "&ip");
            hashMap.put("quantity", "&iq");
            hashMap.put("currency", "&cu");
            aFc = hashMap;
        }
        return aFc;
    }

    private Double zzax(Object object) {
        if (object instanceof String) {
            try {
                return Double.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(numberFormatException.getMessage());
                throw new RuntimeException(string.length() != 0 ? "Cannot convert the object to Double: ".concat(string) : new String("Cannot convert the object to Double: "));
            }
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return n.doubleValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        String string = String.valueOf(object.toString());
        throw new RuntimeException(string.length() != 0 ? "Cannot convert the object to Double: ".concat(string) : new String("Cannot convert the object to Double: "));
    }

    private Integer zzay(Object object) {
        if (object instanceof String) {
            try {
                return Integer.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(numberFormatException.getMessage());
                throw new RuntimeException(string.length() != 0 ? "Cannot convert the object to Integer: ".concat(string) : new String("Cannot convert the object to Integer: "));
            }
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return d.intValue();
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        String string = String.valueOf(object.toString());
        throw new RuntimeException(string.length() != 0 ? "Cannot convert the object to Integer: ".concat(string) : new String("Cannot convert the object to Integer: "));
    }
}

