/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.tagmanager.zzad;
import com.google.android.gms.tagmanager.zzas;
import com.google.android.gms.tagmanager.zzbo;
import com.google.android.gms.tagmanager.zzbt;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;

class zzdf
implements zzad {
    private final String zzbnw;
    private final Context mContext;
    private final zzb aEt;
    private final zza aEu;

    zzdf(zzb zzb2, Context context, zza zza2) {
        this.aEt = zzb2;
        this.mContext = context.getApplicationContext();
        this.aEu = zza2;
        this.zzbnw = this.zza("GoogleTagManager", "4.00", Build.VERSION.RELEASE, zzdf.zzc(Locale.getDefault()), Build.MODEL, Build.ID);
    }

    zzdf(Context context, zza zza2) {
        this(new zzb(){

            @Override
            public HttpURLConnection zzd(URL uRL) throws IOException {
                return (HttpURLConnection)uRL.openConnection();
            }
        }, context, zza2);
    }

    @Override
    public boolean zzcex() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            zzbo.v("...no network connectivity");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzal(List<zzas> list) {
        int n = Math.min(list.size(), 40);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            zzas zzas2 = list.get(i);
            URL uRL = this.zzd(zzas2);
            if (uRL == null) {
                zzbo.zzdf("No destination: discarding hit.");
                this.aEu.zzb(zzas2);
                continue;
            }
            HttpURLConnection httpURLConnection = null;
            InputStream inputStream = null;
            try {
                httpURLConnection = this.aEt.zzd(uRL);
                try {
                    if (bl) {
                        zzbt.zzej(this.mContext);
                        bl = false;
                    }
                    httpURLConnection.setRequestProperty("User-Agent", this.zzbnw);
                    int n2 = httpURLConnection.getResponseCode();
                    inputStream = httpURLConnection.getInputStream();
                    if (n2 != 200) {
                        zzbo.zzdf(new StringBuilder(25).append("Bad response: ").append(n2).toString());
                        this.aEu.zzc(zzas2);
                        continue;
                    }
                    this.aEu.zza(zzas2);
                    continue;
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    httpURLConnection.disconnect();
                }
            }
            catch (IOException iOException) {
                String string = String.valueOf(iOException.getClass().getSimpleName());
                zzbo.zzdf(string.length() != 0 ? "Exception sending hit: ".concat(string) : new String("Exception sending hit: "));
                zzbo.zzdf(iOException.getMessage());
                this.aEu.zzc(zzas2);
            }
        }
    }

    String zza(String string, String string2, String string3, String string4, String string5, String string6) {
        return String.format("%s/%s (Linux; U; Android %s; %s; %s Build/%s)", string, string2, string3, string4, string5, string6);
    }

    static String zzc(Locale locale) {
        if (locale == null) {
            return null;
        }
        if (locale.getLanguage() == null || locale.getLanguage().length() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(locale.getLanguage().toLowerCase());
        if (locale.getCountry() != null && locale.getCountry().length() != 0) {
            stringBuilder.append("-").append(locale.getCountry().toLowerCase());
        }
        return stringBuilder.toString();
    }

    URL zzd(zzas zzas2) {
        String string = zzas2.zzcfj();
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            zzbo.e("Error trying to parse the GTM url.");
            return null;
        }
    }

    static interface zzb {
        public HttpURLConnection zzd(URL var1) throws IOException;
    }

    public static interface zza {
        public void zza(zzas var1);

        public void zzb(zzas var1);

        public void zzc(zzas var1);
    }
}

