/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.internal.zzafe;
import com.google.android.gms.internal.zzafg;
import com.google.android.gms.internal.zzah;
import com.google.android.gms.internal.zzarj;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.tagmanager.zzbh;
import com.google.android.gms.tagmanager.zzbn;
import com.google.android.gms.tagmanager.zzbo;
import com.google.android.gms.tagmanager.zzcj;
import com.google.android.gms.tagmanager.zzp;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

class zzcv
implements zzp.zzf {
    private final Context mContext;
    private final String aAO;
    private final ExecutorService aDx;
    private zzbn<zzafe.zza> aDr;

    zzcv(Context context, String string) {
        this.mContext = context;
        this.aAO = string;
        this.aDx = Executors.newSingleThreadExecutor();
    }

    @Override
    public void zza(zzbn<zzafe.zza> zzbn2) {
        this.aDr = zzbn2;
    }

    @Override
    public void zzceh() {
        this.aDx.execute(new Runnable(){

            @Override
            public void run() {
                zzcv.this.zzcgg();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzcgg() {
        if (this.aDr == null) {
            throw new IllegalStateException("Callback must be set before execute");
        }
        this.aDr.zzceg();
        zzbo.v("Attempting to load resource from disk");
        if ((zzcj.zzcfy().zzcfz() == zzcj.zza.aDg || zzcj.zzcfy().zzcfz() == zzcj.zza.aDh) && this.aAO.equals(zzcj.zzcfy().getContainerId())) {
            this.aDr.zza(zzbn.zza.aCE);
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.zzcgh());
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbo.zzdd("Failed to find the resource in the disk");
            this.aDr.zza(zzbn.zza.aCE);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zzafg.zzc(fileInputStream, byteArrayOutputStream);
            zzafe.zza zza2 = zzafe.zza.zzao(byteArrayOutputStream.toByteArray());
            this.zzd(zza2);
            this.aDr.onSuccess(zza2);
        }
        catch (IOException iOException) {
            this.aDr.zza(zzbn.zza.aCF);
            zzbo.zzdf("Failed to read the resource from disk");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.aDr.zza(zzbn.zza.aCF);
            zzbo.zzdf("Failed to read the resource from disk. The resource is inconsistent");
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                zzbo.zzdf("Error closing stream for reading resource from disk");
            }
        }
        zzbo.v("The Disk resource was successfully read.");
    }

    @Override
    public void zzb(final zzafe.zza zza2) {
        this.aDx.execute(new Runnable(){

            @Override
            public void run() {
                zzcv.this.zzc(zza2);
            }
        });
    }

    @Override
    public zzafg.zzc zzaaj(int n) {
        InputStream inputStream = null;
        try {
            inputStream = this.mContext.getResources().openRawResource(n);
        }
        catch (Resources.NotFoundException notFoundException) {
            zzbo.zzdf(new StringBuilder(98).append("Failed to load the container. No default container resource found with the resource ID ").append(n).toString());
            return null;
        }
        Object object = String.valueOf(this.mContext.getResources().getResourceName(n));
        zzbo.v(new StringBuilder(66 + String.valueOf(object).length()).append("Attempting to load a container from the resource ID ").append(n).append(" (").append((String)object).append(")").toString());
        try {
            object = new ByteArrayOutputStream();
            zzafg.zzc(inputStream, (OutputStream)object);
            zzafg.zzc zzc2 = this.zza((ByteArrayOutputStream)object);
            if (zzc2 != null) {
                zzbo.v("The container was successfully loaded from the resource (using JSON file format)");
                return zzc2;
            }
            return this.zzak(((ByteArrayOutputStream)object).toByteArray());
        }
        catch (IOException iOException) {
            String string = String.valueOf(this.mContext.getResources().getResourceName(n));
            zzbo.zzdf(new StringBuilder(67 + String.valueOf(string).length()).append("Error reading the default container with resource ID ").append(n).append(" (").append(string).append(")").toString());
            return null;
        }
    }

    private zzafg.zzc zza(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            String string = byteArrayOutputStream.toString("UTF-8");
            return zzbh.zzpn(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            zzbo.zzdd("Failed to convert binary resource to string for JSON parsing; the file format is not UTF-8 format.");
            return null;
        }
        catch (JSONException jSONException) {
            zzbo.zzdf("Failed to extract the container from the resource file. Resource is a UTF-8 encoded string but doesn't contain a JSON container");
            return null;
        }
    }

    private zzafg.zzc zzak(byte[] byArray) {
        try {
            zzafg.zzc zzc2 = zzafg.zzb(zzah.zzf.zze(byArray));
            if (zzc2 != null) {
                zzbo.v("The container was successfully loaded from the resource (using binary file)");
            }
            return zzc2;
        }
        catch (zzarj zzarj2) {
            zzbo.e("The resource file is corrupted. The container cannot be extracted from the binary file");
            return null;
        }
        catch (zzafg.zzg zzg2) {
            zzbo.zzdf("The resource file is invalid. The container from the binary file is invalid");
            return null;
        }
    }

    public synchronized void release() {
        this.aDx.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzc(zzafe.zza zza2) {
        FileOutputStream fileOutputStream = null;
        File file = this.zzcgh();
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbo.e("Error opening resource file for writing");
            return false;
        }
        try {
            fileOutputStream.write(zzark.zzf((zzark)zza2));
            boolean bl = true;
            return true;
        }
        catch (IOException iOException) {
            zzbo.zzdf("Error writing resource to disk. Removing resource from disk.");
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                zzbo.zzdf("error closing stream for writing resource to disk");
            }
        }
        return false;
    }

    File zzcgh() {
        String string = String.valueOf("resource_");
        String string2 = String.valueOf(this.aAO);
        String string3 = string2.length() != 0 ? string.concat(string2) : new String(string);
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, string3);
    }

    private void zzd(zzafe.zza zza2) throws IllegalArgumentException {
        if (zza2.zzxr == null && zza2.aJk == null) {
            throw new IllegalArgumentException("Resource and SupplementedResource are NULL.");
        }
    }
}

